/*
 * Decompiled with CFR 0.152.
 */
package com.novamachina.exnihilosequentia.common.registries.barrel.fluid;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.novamachina.exnihilosequentia.common.api.ExNihiloRegistries;
import com.novamachina.exnihilosequentia.common.compat.jei.fluidontop.FluidOnTopJEIRecipe;
import com.novamachina.exnihilosequentia.common.json.AnnotatedDeserializer;
import com.novamachina.exnihilosequentia.common.json.FluidOnTopJson;
import com.novamachina.exnihilosequentia.common.registries.AbstractModRegistry;
import com.novamachina.exnihilosequentia.common.registries.barrel.fluid.FluidOnTopRecipe;
import com.novamachina.exnihilosequentia.common.utility.Constants;
import com.novamachina.exnihilosequentia.common.utility.LogUtil;
import com.novamachina.exnihilosequentia.common.utility.TagUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidOnTopRegistry
extends AbstractModRegistry {
    private final Map<ResourceLocation, List<FluidOnTopRecipe>> recipeMap = new HashMap<ResourceLocation, List<FluidOnTopRecipe>>();

    public FluidOnTopRegistry(ExNihiloRegistries.ModBus bus) {
        bus.register(this);
    }

    public boolean isValidRecipe(Fluid fluidInTank, Fluid fluidOnTop) {
        boolean isValid = false;
        ResourceLocation fluidInTankID = fluidInTank.getRegistryName();
        if (this.recipeMap.containsKey(fluidInTankID)) {
            List<FluidOnTopRecipe> recipeList = this.recipeMap.get(fluidInTankID);
            for (FluidOnTopRecipe recipe : recipeList) {
                if (!recipe.getFluidOnTop().equals((Object)fluidOnTop.getRegistryName())) continue;
                isValid = true;
            }
        }
        return isValid;
    }

    public Block getResult(Fluid fluidInTank, Fluid fluidOnTop) {
        ResourceLocation fluidInTankID = fluidInTank.getRegistryName();
        if (this.recipeMap.containsKey(fluidInTankID)) {
            List<FluidOnTopRecipe> recipeList = this.recipeMap.get(fluidInTankID);
            for (FluidOnTopRecipe recipe : recipeList) {
                if (!recipe.getFluidOnTop().equals((Object)fluidOnTop.getRegistryName())) continue;
                return (Block)ForgeRegistries.BLOCKS.getValue(recipe.getResult());
            }
        }
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("minecraft:air"));
    }

    public void addRecipe(Fluid fluidInTank, Fluid fluidOnTop, Block result) {
        this.addRecipe(fluidInTank.getRegistryName(), fluidOnTop.getRegistryName(), result.getRegistryName());
    }

    public void addRecipe(ResourceLocation fluidInTank, ResourceLocation fluidOnTop, ResourceLocation result) {
        List<FluidOnTopRecipe> list = this.recipeMap.get(fluidInTank);
        if (list == null) {
            list = new ArrayList<FluidOnTopRecipe>();
            this.recipeMap.put(fluidInTank, list);
        }
        for (FluidOnTopRecipe recipe : list) {
            if (!recipe.getFluidOnTop().equals((Object)fluidOnTop)) continue;
            LogUtil.warn(String.format("Duplicate recipe: %s(In Barrel) + %s(On Top). Keeping first result: %s", fluidInTank, fluidOnTop, recipe.getResult()));
        }
        list.add(new FluidOnTopRecipe(fluidInTank, fluidOnTop, result));
    }

    @Override
    public void useJson() {
        if (this.generateJson(Constants.Json.FLUID_ON_TOP_FILE, this)) {
            return;
        }
        try {
            List<FluidOnTopJson> registriesJson = this.readJson();
            for (FluidOnTopJson entry : registriesJson) {
                try {
                    if (this.itemExists(entry.getFluidInBarrel())) {
                        ResourceLocation fluidInBarrel = new ResourceLocation(entry.getFluidInBarrel());
                        if (this.itemExists(entry.getFluidOnTop())) {
                            ResourceLocation fluidOnTop = new ResourceLocation(entry.getFluidOnTop());
                            if (this.itemExists(entry.getResult())) {
                                ResourceLocation resultID = new ResourceLocation(entry.getResult());
                                this.addRecipe(fluidInBarrel, fluidOnTop, resultID);
                                continue;
                            }
                            LogUtil.warn(String.format("%s: Entry \"%s\" does not exist...Skipping...", Constants.Json.FLUID_ON_TOP_FILE, entry.getResult()));
                            continue;
                        }
                        LogUtil.warn(String.format("%s: Entry \"%s\" does not exist...Skipping...", Constants.Json.FLUID_ON_TOP_FILE, entry.getFluidOnTop()));
                        continue;
                    }
                    LogUtil.warn(String.format("%s: Entry \"%s\" does not exist...Skipping...", Constants.Json.FLUID_ON_TOP_FILE, entry.getFluidInBarrel()));
                }
                catch (ResourceLocationException e) {
                    LogUtil.warn(String.format("%s: %s. Skipping...", Constants.Json.FLUID_ON_TOP_FILE, e.getMessage()));
                }
            }
        }
        catch (JsonParseException e) {
            LogUtil.error(String.format("Malformed %s", Constants.Json.FLUID_ON_TOP_FILE));
            LogUtil.error(e.getMessage());
            if (e.getMessage().contains("IllegalStateException")) {
                LogUtil.error("Please consider deleting the file and regenerating it.");
            }
            LogUtil.error("Falling back to defaults");
            this.clear();
            ExNihiloRegistries.BUS.getDefaults().forEach(registry -> registry.registerFluidOnTop(this));
        }
    }

    private boolean itemExists(String entry) throws ResourceLocationException {
        ResourceLocation itemID = new ResourceLocation(entry);
        return TagUtils.isTag(itemID) || ForgeRegistries.BLOCKS.containsKey(itemID) || ForgeRegistries.ITEMS.containsKey(itemID) || ForgeRegistries.FLUIDS.containsKey(itemID);
    }

    private List<FluidOnTopJson> readJson() throws JsonParseException {
        Type listType = new TypeToken<ArrayList<FluidOnTopJson>>(){}.getType();
        Gson gson = new GsonBuilder().registerTypeAdapter(listType, new AnnotatedDeserializer()).create();
        Path path = Constants.Json.baseJsonPath.resolve(Constants.Json.FLUID_ON_TOP_FILE);
        List registryJson = null;
        try {
            StringBuilder builder = new StringBuilder();
            Files.readAllLines(path).forEach(builder::append);
            registryJson = (List)gson.fromJson(builder.toString(), listType);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return registryJson;
    }

    @Override
    public void clear() {
        this.recipeMap.clear();
    }

    @Override
    public List<FluidOnTopJson> toJSONReady() {
        ArrayList<FluidOnTopJson> gsonList = new ArrayList<FluidOnTopJson>();
        for (List<FluidOnTopRecipe> recipeList : this.recipeMap.values()) {
            for (FluidOnTopRecipe recipe : recipeList) {
                gsonList.add(new FluidOnTopJson(recipe));
            }
        }
        return gsonList;
    }

    public List<FluidOnTopJEIRecipe> getRecipeList() {
        ArrayList<FluidOnTopJEIRecipe> recipes = new ArrayList<FluidOnTopJEIRecipe>();
        for (List<FluidOnTopRecipe> list : this.recipeMap.values()) {
            for (FluidOnTopRecipe recipe : list) {
                FluidStack fluidOnTop = new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(recipe.getFluidOnTop()), 1000);
                FluidStack fluidInBarrel = new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(recipe.getFluidInBarrel()), 1000);
                ItemStack result = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(recipe.getResult()));
                recipes.add(new FluidOnTopJEIRecipe(fluidInBarrel, fluidOnTop, result));
            }
        }
        return recipes;
    }
}

