/*
 * Decompiled with CFR 0.152.
 */
package com.novamachina.exnihilosequentia.common.registries.barrel.transform;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.novamachina.exnihilosequentia.common.api.ExNihiloRegistries;
import com.novamachina.exnihilosequentia.common.compat.jei.fluidtransform.FluidTransformJEIRecipe;
import com.novamachina.exnihilosequentia.common.json.AnnotatedDeserializer;
import com.novamachina.exnihilosequentia.common.json.FluidTransformJson;
import com.novamachina.exnihilosequentia.common.registries.AbstractModRegistry;
import com.novamachina.exnihilosequentia.common.registries.barrel.transform.FluidTransformRecipe;
import com.novamachina.exnihilosequentia.common.utility.Constants;
import com.novamachina.exnihilosequentia.common.utility.LogUtil;
import com.novamachina.exnihilosequentia.common.utility.TagUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidTransformRegistry
extends AbstractModRegistry {
    private final Map<ResourceLocation, List<FluidTransformRecipe>> recipeMap = new HashMap<ResourceLocation, List<FluidTransformRecipe>>();

    public FluidTransformRegistry(ExNihiloRegistries.ModBus bus) {
        bus.register(this);
    }

    public boolean isValidRecipe(Fluid fluidInTank, Block blockBelow) {
        boolean isValid = false;
        ResourceLocation fluidInTankID = fluidInTank.getRegistryName();
        if (this.recipeMap.containsKey(fluidInTankID)) {
            List<FluidTransformRecipe> recipes = this.recipeMap.get(fluidInTankID);
            for (FluidTransformRecipe recipe : recipes) {
                if (!recipe.getBlockBelow().equals((Object)blockBelow.getRegistryName())) continue;
                isValid = true;
            }
        }
        return isValid;
    }

    public Fluid getResult(Fluid fluidInTank, Block blockBelow) {
        List<FluidTransformRecipe> possibleRecipes = this.recipeMap.get(fluidInTank.getRegistryName());
        if (possibleRecipes != null) {
            for (FluidTransformRecipe recipe : possibleRecipes) {
                if (!recipe.getBlockBelow().equals((Object)blockBelow.getRegistryName())) continue;
                return (Fluid)ForgeRegistries.FLUIDS.getValue(recipe.getResult());
            }
        }
        return null;
    }

    public void addRecipe(Fluid fluidInTank, Block blockBelow, Fluid result) {
        this.addRecipe(fluidInTank.getRegistryName(), blockBelow.getRegistryName(), result.getRegistryName());
    }

    public void addRecipe(ResourceLocation fluidInTank, ResourceLocation blockBelow, ResourceLocation result) {
        if (this.recipeMap.containsKey(fluidInTank)) {
            List<FluidTransformRecipe> recipes = this.recipeMap.get(fluidInTank);
            for (FluidTransformRecipe recipe : recipes) {
                if (!recipe.getBlockBelow().equals((Object)blockBelow)) continue;
                LogUtil.warn(String.format("Duplicate recipe: %s(Fluid) + %s(Block Below). Keeping first result: %s", fluidInTank.toString(), blockBelow.toString(), recipe.getResult().toString()));
                return;
            }
        }
        this.insertIntoMap(fluidInTank, new FluidTransformRecipe(fluidInTank, blockBelow, result));
    }

    private void insertIntoMap(ResourceLocation fluidInTank, FluidTransformRecipe recipe) {
        List<FluidTransformRecipe> recipes = this.recipeMap.get(fluidInTank);
        if (recipes == null) {
            recipes = new ArrayList<FluidTransformRecipe>();
            this.recipeMap.put(fluidInTank, recipes);
        }
        recipes.add(recipe);
    }

    @Override
    public void useJson() {
        if (this.generateJson(Constants.Json.FLUID_TRANSFORM_FILE, this)) {
            return;
        }
        try {
            List<FluidTransformJson> registriesJson = this.readJson();
            for (FluidTransformJson entry : registriesJson) {
                try {
                    if (this.itemExists(entry.getFluidInBarrel())) {
                        ResourceLocation fluidID = new ResourceLocation(entry.getFluidInBarrel());
                        if (this.itemExists(entry.getBlockBelow())) {
                            ResourceLocation inputID = new ResourceLocation(entry.getBlockBelow());
                            if (this.itemExists(entry.getResult())) {
                                ResourceLocation resultID = new ResourceLocation(entry.getResult());
                                this.addRecipe(fluidID, inputID, resultID);
                                continue;
                            }
                            LogUtil.warn(String.format("%s: Entry \"%s\" does not exist...Skipping...", Constants.Json.FLUID_TRANSFORM_FILE, entry.getResult()));
                            continue;
                        }
                        LogUtil.warn(String.format("%s: Entry \"%s\" does not exist...Skipping...", Constants.Json.FLUID_TRANSFORM_FILE, entry.getBlockBelow()));
                        continue;
                    }
                    LogUtil.warn(String.format("%s: Entry \"%s\" does not exist...Skipping...", Constants.Json.FLUID_TRANSFORM_FILE, entry.getFluidInBarrel()));
                }
                catch (ResourceLocationException e) {
                    LogUtil.warn(String.format("%s: %s. Skipping...", Constants.Json.FLUID_TRANSFORM_FILE, e.getMessage()));
                }
            }
        }
        catch (JsonParseException e) {
            LogUtil.error(String.format("Malformed %s", Constants.Json.FLUID_TRANSFORM_FILE));
            LogUtil.error(e.getMessage());
            if (e.getMessage().contains("IllegalStateException")) {
                LogUtil.error("Please consider deleting the file and regenerating it.");
            }
            LogUtil.error("Falling back to defaults");
            this.clear();
            ExNihiloRegistries.BUS.getDefaults().forEach(registry -> registry.registerFluidTransform(this));
        }
    }

    private boolean itemExists(String entry) throws ResourceLocationException {
        ResourceLocation itemID = new ResourceLocation(entry);
        return TagUtils.isTag(itemID) || ForgeRegistries.BLOCKS.containsKey(itemID) || ForgeRegistries.ITEMS.containsKey(itemID) || ForgeRegistries.FLUIDS.containsKey(itemID);
    }

    private List<FluidTransformJson> readJson() throws JsonParseException {
        Type listType = new TypeToken<ArrayList<FluidTransformJson>>(){}.getType();
        Gson gson = new GsonBuilder().registerTypeAdapter(listType, new AnnotatedDeserializer()).create();
        Path path = Constants.Json.baseJsonPath.resolve(Constants.Json.FLUID_TRANSFORM_FILE);
        List registryJson = null;
        try {
            StringBuilder builder = new StringBuilder();
            Files.readAllLines(path).forEach(builder::append);
            registryJson = (List)gson.fromJson(builder.toString(), listType);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return registryJson;
    }

    @Override
    public void clear() {
        this.recipeMap.clear();
    }

    @Override
    public List<FluidTransformJson> toJSONReady() {
        ArrayList<FluidTransformJson> gsonList = new ArrayList<FluidTransformJson>();
        for (List<FluidTransformRecipe> recipeList : this.recipeMap.values()) {
            for (FluidTransformRecipe recipe : recipeList) {
                gsonList.add(new FluidTransformJson(recipe));
            }
        }
        return gsonList;
    }

    public List<FluidTransformJEIRecipe> getRecipeList() {
        ArrayList<FluidTransformJEIRecipe> recipes = new ArrayList<FluidTransformJEIRecipe>();
        for (List<FluidTransformRecipe> recipeList : this.recipeMap.values()) {
            for (FluidTransformRecipe recipe : recipeList) {
                FluidStack fluid = new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(recipe.getFluidInBarrel()), 1000);
                ItemStack block = new ItemStack((IItemProvider)ForgeRegistries.BLOCKS.getValue(recipe.getBlockBelow()));
                FluidStack result = new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(recipe.getResult()), 1000);
                recipes.add(new FluidTransformJEIRecipe(fluid, block, result));
            }
        }
        return recipes;
    }
}

