/*
 * Decompiled with CFR 0.152.
 */
package com.novamachina.exnihilosequentia.common.registries.crook;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.novamachina.exnihilosequentia.common.api.ExNihiloRegistries;
import com.novamachina.exnihilosequentia.common.compat.jei.crook.CrookRecipe;
import com.novamachina.exnihilosequentia.common.item.resources.EnumResource;
import com.novamachina.exnihilosequentia.common.json.AnnotatedDeserializer;
import com.novamachina.exnihilosequentia.common.json.CrookJson;
import com.novamachina.exnihilosequentia.common.registries.AbstractModRegistry;
import com.novamachina.exnihilosequentia.common.registries.crook.CrookDropEntry;
import com.novamachina.exnihilosequentia.common.utility.Constants;
import com.novamachina.exnihilosequentia.common.utility.LogUtil;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraftforge.registries.ForgeRegistries;

public class CrookRegistry
extends AbstractModRegistry {
    private final List<CrookDropEntry> crookDrops = new ArrayList<CrookDropEntry>();

    public CrookRegistry(ExNihiloRegistries.ModBus bus) {
        bus.register(this);
    }

    @Override
    public void useJson() {
        if (this.generateJson(Constants.Json.CROOK_FILE, this)) {
            return;
        }
        try {
            List<CrookJson> list = this.readJson();
            for (CrookJson entry : list) {
                try {
                    if (this.itemExists(entry.getResult())) {
                        ResourceLocation entryID = new ResourceLocation(entry.getResult());
                        this.addDrop(entryID, entry.getRarity().floatValue());
                        continue;
                    }
                    LogUtil.warn(String.format("%s: Entry \"%s\" does not exist...Skipping...", Constants.Json.CROOK_FILE, entry.getResult()));
                }
                catch (ResourceLocationException e) {
                    LogUtil.warn(String.format("%s: %s. Skipping...", Constants.Json.CROOK_FILE, e.getMessage()));
                }
            }
        }
        catch (JsonParseException e) {
            LogUtil.error(String.format("Malformed %s", Constants.Json.CROOK_FILE));
            LogUtil.error(e.getMessage());
            if (e.getMessage().contains("IllegalStateException")) {
                LogUtil.error("Please consider deleting the file and regenerating it.");
            }
            LogUtil.error("Falling back to defaults");
            this.clear();
            this.useDefaults();
        }
    }

    private boolean itemExists(String entry) throws ResourceLocationException {
        ResourceLocation itemID = new ResourceLocation(entry);
        return ForgeRegistries.BLOCKS.containsKey(itemID) || ForgeRegistries.ITEMS.containsKey(itemID);
    }

    private List<CrookJson> readJson() throws JsonParseException {
        Type listType = new TypeToken<ArrayList<CrookJson>>(){}.getType();
        Gson gson = new GsonBuilder().registerTypeAdapter(listType, new AnnotatedDeserializer()).create();
        Path path = Constants.Json.baseJsonPath.resolve(Constants.Json.CROOK_FILE);
        List list = null;
        try {
            StringBuilder builder = new StringBuilder();
            Files.readAllLines(path).forEach(builder::append);
            list = (List)gson.fromJson(builder.toString(), listType);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void useDefaults() {
        this.addDrop((Item)EnumResource.SILKWORM.getRegistryObject().get(), 0.1f);
    }

    public List<CrookDropEntry> getDrops() {
        return this.crookDrops;
    }

    public void addDrop(Item item, float rarity) {
        this.addDrop(item.getRegistryName(), rarity);
    }

    public void addDrop(ResourceLocation item, float rarity) {
        this.crookDrops.add(new CrookDropEntry(item, rarity));
    }

    @Override
    public List<CrookJson> toJSONReady() {
        ArrayList<CrookJson> jsonList = new ArrayList<CrookJson>();
        for (CrookDropEntry entry : this.crookDrops) {
            jsonList.add(new CrookJson(entry));
        }
        return jsonList;
    }

    @Override
    public void clear() {
        this.crookDrops.clear();
    }

    public List<CrookRecipe> getRecipeList() {
        ArrayList<CrookRecipe> recipes = new ArrayList<CrookRecipe>();
        List<ItemStack> inputs = BlockTags.func_199896_a().func_199910_a(new ResourceLocation("minecraft", "leaves")).func_199885_a().stream().map(ItemStack::new).collect(Collectors.toList());
        for (CrookDropEntry entry : this.crookDrops) {
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
            outputs.add(new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(entry.getItem())));
            recipes.add(new CrookRecipe(inputs, outputs));
        }
        return recipes;
    }
}

