/*
 * Decompiled with CFR 0.152.
 */
package com.novamachina.exnihilosequentia.common.registries.crucible;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.novamachina.exnihilosequentia.common.api.ExNihiloRegistries;
import com.novamachina.exnihilosequentia.common.compat.jei.crucible.CrucibleRecipe;
import com.novamachina.exnihilosequentia.common.json.AnnotatedDeserializer;
import com.novamachina.exnihilosequentia.common.json.CrucibleJson;
import com.novamachina.exnihilosequentia.common.registries.AbstractModRegistry;
import com.novamachina.exnihilosequentia.common.registries.crucible.Meltable;
import com.novamachina.exnihilosequentia.common.tileentity.crucible.CrucilbeTypeEnum;
import com.novamachina.exnihilosequentia.common.utility.Constants;
import com.novamachina.exnihilosequentia.common.utility.LogUtil;
import com.novamachina.exnihilosequentia.common.utility.TagUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CrucibleRegistry
extends AbstractModRegistry {
    private final Map<ResourceLocation, Meltable> meltableMap = new HashMap<ResourceLocation, Meltable>();

    public CrucibleRegistry(ExNihiloRegistries.ModBus bus) {
        bus.register(this);
    }

    public void addMeltable(ForgeRegistryEntry<? extends IItemProvider> entry, int amount, Fluid fluid, CrucilbeTypeEnum crucibleType) {
        this.addMeltable(entry.getRegistryName(), amount, fluid.getRegistryName(), crucibleType);
    }

    public void addMeltable(ResourceLocation entry, int amount, ResourceLocation fluid, CrucilbeTypeEnum crucibleType) {
        List<ResourceLocation> idList = TagUtils.getTagsOwnedBy(entry);
        for (ResourceLocation id : idList) {
            if (!this.meltableMap.containsKey(id)) continue;
            LogUtil.info(String.format("ID: %s falls under Tag: %s. Removing %s ...", id.toString(), this.meltableMap.toString(), id.toString()));
            this.meltableMap.remove(id);
        }
        Collection<ResourceLocation> tags = TagUtils.getTags(entry);
        if (tags != null) {
            for (ResourceLocation id : tags) {
                if (!this.meltableMap.containsKey(id)) continue;
                LogUtil.info(String.format("Tag: %s already registered. Skipping item %s ...", id.toString(), entry));
                return;
            }
        }
        if (this.meltableMap.containsKey(entry)) {
            LogUtil.info(String.format("Tag: %s already registered. Skipping...", entry));
            return;
        }
        this.insertIntoMap(entry, new Meltable(amount, fluid, crucibleType));
    }

    private void insertIntoMap(ResourceLocation name, Meltable meltable) {
        this.meltableMap.put(name, meltable);
    }

    public boolean isMeltable(ForgeRegistryEntry<? extends IItemProvider> entry, int level) {
        Collection<ResourceLocation> tags = TagUtils.getTags(entry.getRegistryName());
        for (ResourceLocation tag : tags) {
            if (!this.meltableMap.containsKey(tag) || this.meltableMap.get(tag).getCrucibleType().getLevel() > level) continue;
            return true;
        }
        return this.meltableMap.containsKey(entry.getRegistryName()) && this.meltableMap.get(entry.getRegistryName()).getCrucibleType().getLevel() <= level;
    }

    public Meltable getMeltable(ForgeRegistryEntry<? extends IItemProvider> entry) {
        Collection<ResourceLocation> tags = TagUtils.getTags(entry.getRegistryName());
        for (ResourceLocation tag : tags) {
            if (!this.meltableMap.containsKey(tag)) continue;
            return this.meltableMap.get(tag);
        }
        return this.meltableMap.getOrDefault(entry.getRegistryName(), Meltable.DEFAULT);
    }

    @Override
    public void clear() {
        this.meltableMap.clear();
    }

    @Override
    public List<CrucibleJson> toJSONReady() {
        ArrayList<CrucibleJson> jsonList = new ArrayList<CrucibleJson>();
        for (Map.Entry<ResourceLocation, Meltable> entry : this.meltableMap.entrySet()) {
            jsonList.add(new CrucibleJson(entry.getKey().toString(), entry.getValue()));
        }
        return jsonList;
    }

    protected boolean itemExists(String entry) throws ResourceLocationException {
        ResourceLocation itemID = new ResourceLocation(entry);
        return TagUtils.isTag(itemID) || ForgeRegistries.BLOCKS.containsKey(itemID) || ForgeRegistries.ITEMS.containsKey(itemID) || ForgeRegistries.FLUIDS.containsKey(itemID);
    }

    public List<CrucibleRecipe> getRecipeList() {
        ArrayList<CrucibleRecipe> recipes = new ArrayList<CrucibleRecipe>();
        for (ResourceLocation entry : this.meltableMap.keySet()) {
            ArrayList<ItemStack> blocks;
            Meltable meltable = this.getMeltable(entry);
            Tag itemTag = ItemTags.func_199903_a().func_199910_a(entry);
            if (itemTag != null) {
                blocks = itemTag.func_199885_a().stream().map(ItemStack::new).collect(Collectors.toList());
            } else {
                blocks = new ArrayList<ItemStack>();
                blocks.add(new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(entry)));
            }
            recipes.add(new CrucibleRecipe(blocks, new FluidStack(meltable.getFluid(), 1000)));
        }
        return recipes;
    }

    private Meltable getMeltable(ResourceLocation entry) {
        return this.meltableMap.get(entry);
    }

    @Override
    public void useJson() {
        if (this.generateJson("CrucibleRegistry.json", this)) {
            return;
        }
        try {
            List<CrucibleJson> registriesJson = this.readJson();
            for (CrucibleJson entry : registriesJson) {
                try {
                    if (this.itemExists(entry.getEntry())) {
                        ResourceLocation entryID = new ResourceLocation(entry.getEntry());
                        if (this.itemExists(entry.getFluid())) {
                            ResourceLocation fluidID = new ResourceLocation(entry.getFluid());
                            this.addMeltable(entryID, (int)entry.getAmount(), fluidID, entry.getCrucibleType());
                            continue;
                        }
                        LogUtil.warn(String.format("%s: Entry \"%s\" does not exist...Skipping...", "CrucibleRegistry.json", entry.getFluid()));
                        continue;
                    }
                    LogUtil.warn(String.format("%s: Entry \"%s\" does not exist...Skipping...", "CrucibleRegistry.json", entry.getEntry()));
                }
                catch (ResourceLocationException e) {
                    LogUtil.warn(String.format("%s: %s. Skipping...", "CrucibleRegistry.json", e.getMessage()));
                }
            }
        }
        catch (JsonParseException e) {
            LogUtil.error(String.format("Malformed %s", "CrucibleRegistry.json"));
            LogUtil.error(e.getMessage());
            if (e.getMessage().contains("IllegalStateException")) {
                LogUtil.error("Please consider deleting the file and regenerating it.");
            }
            LogUtil.error("Falling back to defaults");
            this.clear();
            ExNihiloRegistries.BUS.getDefaults().forEach(registry -> registry.registerFiredCrucible(this));
        }
    }

    private List<CrucibleJson> readJson() throws JsonParseException {
        Type listType = new TypeToken<ArrayList<CrucibleJson>>(){}.getType();
        Gson gson = new GsonBuilder().registerTypeAdapter(listType, new AnnotatedDeserializer()).create();
        Path path = Constants.Json.baseJsonPath.resolve("CrucibleRegistry.json");
        List registryJson = null;
        try {
            StringBuilder builder = new StringBuilder();
            Files.readAllLines(path).forEach(builder::append);
            registryJson = (List)gson.fromJson(builder.toString(), listType);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return registryJson;
    }

    public List<CrucibleRecipe> getFiredRecipeList() {
        ArrayList<CrucibleRecipe> recipes = new ArrayList<CrucibleRecipe>();
        for (ResourceLocation entry : this.meltableMap.keySet()) {
            ArrayList<ItemStack> blocks;
            Meltable meltable = this.getMeltable(entry);
            Tag itemTag = ItemTags.func_199903_a().func_199910_a(entry);
            if (itemTag != null) {
                blocks = itemTag.func_199885_a().stream().map(ItemStack::new).collect(Collectors.toList());
            } else {
                blocks = new ArrayList<ItemStack>();
                blocks.add(new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(entry)));
            }
            recipes.add(new CrucibleRecipe(blocks, new FluidStack(meltable.getFluid(), 1000)));
        }
        return recipes;
    }

    public List<CrucibleRecipe> getWoodRecipeList() {
        ArrayList<CrucibleRecipe> recipes = new ArrayList<CrucibleRecipe>();
        for (ResourceLocation entry : this.meltableMap.keySet()) {
            ArrayList<ItemStack> blocks;
            Meltable meltable = this.getMeltable(entry);
            if (meltable.getCrucibleType() != CrucilbeTypeEnum.WOOD) continue;
            Tag itemTag = ItemTags.func_199903_a().func_199910_a(entry);
            if (itemTag != null) {
                blocks = itemTag.func_199885_a().stream().map(ItemStack::new).collect(Collectors.toList());
            } else {
                blocks = new ArrayList<ItemStack>();
                blocks.add(new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(entry)));
            }
            recipes.add(new CrucibleRecipe(blocks, new FluidStack(meltable.getFluid(), 1000)));
        }
        return recipes;
    }
}

