/*
 * Decompiled with CFR 0.152.
 */
package com.novamachina.exnihilosequentia.common.registries.crucible;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.novamachina.exnihilosequentia.common.api.ExNihiloRegistries;
import com.novamachina.exnihilosequentia.common.compat.jei.heat.HeatRecipe;
import com.novamachina.exnihilosequentia.common.json.AnnotatedDeserializer;
import com.novamachina.exnihilosequentia.common.json.HeatJson;
import com.novamachina.exnihilosequentia.common.registries.AbstractModRegistry;
import com.novamachina.exnihilosequentia.common.utility.Constants;
import com.novamachina.exnihilosequentia.common.utility.LogUtil;
import com.novamachina.exnihilosequentia.common.utility.TagUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class HeatRegistry
extends AbstractModRegistry {
    private final Map<ResourceLocation, Integer> heatMap = new HashMap<ResourceLocation, Integer>();

    public HeatRegistry(ExNihiloRegistries.ModBus bus) {
        bus.register(this);
    }

    public void addHeatSource(ForgeRegistryEntry<? extends IItemProvider> entry, int amount) {
        this.addHeatSource(entry.getRegistryName(), amount);
    }

    public void addHeatSource(ResourceLocation entry, int amount) {
        List<ResourceLocation> idList = TagUtils.getTagsOwnedBy(entry);
        for (ResourceLocation id : idList) {
            if (!this.heatMap.containsKey(id)) continue;
            LogUtil.info(String.format("ID: %s falls under Tag: %s. Removing %s ...", id.toString(), entry.toString(), id.toString()));
            this.heatMap.remove(id);
        }
        Collection<ResourceLocation> tags = TagUtils.getTags(entry);
        if (tags != null) {
            for (ResourceLocation tag : tags) {
                if (!this.heatMap.containsKey(tag)) continue;
                LogUtil.info(String.format("Tag: %s already registered. Skipping item %s ...", tag.toString(), entry));
                return;
            }
        }
        if (this.heatMap.containsKey(entry)) {
            LogUtil.info(String.format("Tag: %s already registered. Skipping...", entry));
            return;
        }
        this.insertIntoMap(entry, amount);
    }

    private void insertIntoMap(ResourceLocation name, int amount) {
        this.heatMap.put(name, amount);
    }

    public int getHeatAmount(ForgeRegistryEntry<? extends IItemProvider> entry) {
        return this.heatMap.getOrDefault(entry.getRegistryName(), 0);
    }

    @Override
    public void useJson() {
        if (this.generateJson(Constants.Json.HEAT_FILE, this)) {
            return;
        }
        try {
            List<HeatJson> registriesJson = this.readJson();
            for (HeatJson entry : registriesJson) {
                try {
                    if (this.itemExists(entry.getEntry())) {
                        ResourceLocation entryID = new ResourceLocation(entry.getEntry());
                        this.addHeatSource(entryID, (int)entry.getRate());
                        continue;
                    }
                    LogUtil.warn(String.format("%s: Entry \"%s\" does not exist...Skipping...", Constants.Json.HEAT_FILE, entry.getEntry()));
                }
                catch (ResourceLocationException e) {
                    LogUtil.warn(String.format("%s: %s. Skipping...", Constants.Json.HEAT_FILE, e.getMessage()));
                }
            }
        }
        catch (JsonParseException e) {
            LogUtil.error(String.format("Malformed %s", Constants.Json.HEAT_FILE));
            LogUtil.error(e.getMessage());
            if (e.getMessage().contains("IllegalStateException")) {
                LogUtil.error("Please consider deleting the file and regenerating it.");
            }
            LogUtil.error("Falling back to defaults");
            this.clear();
            ExNihiloRegistries.BUS.getDefaults().forEach(registry -> registry.registerHeat(this));
        }
    }

    private boolean itemExists(String entry) throws ResourceLocationException {
        ResourceLocation itemID = new ResourceLocation(entry);
        return TagUtils.isTag(itemID) || ForgeRegistries.BLOCKS.containsKey(itemID) || ForgeRegistries.ITEMS.containsKey(itemID) || ForgeRegistries.FLUIDS.containsKey(itemID);
    }

    private List<HeatJson> readJson() throws JsonParseException {
        Type listType = new TypeToken<ArrayList<HeatJson>>(){}.getType();
        Gson gson = new GsonBuilder().registerTypeAdapter(listType, new AnnotatedDeserializer()).create();
        Path path = Constants.Json.baseJsonPath.resolve(Constants.Json.HEAT_FILE);
        List registryJson = null;
        try {
            StringBuilder builder = new StringBuilder();
            Files.readAllLines(path).forEach(builder::append);
            registryJson = (List)gson.fromJson(builder.toString(), listType);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return registryJson;
    }

    @Override
    public void clear() {
        this.heatMap.clear();
    }

    @Override
    public List<HeatJson> toJSONReady() {
        ArrayList<HeatJson> jsonList = new ArrayList<HeatJson>();
        for (Map.Entry<ResourceLocation, Integer> entry : this.heatMap.entrySet()) {
            jsonList.add(new HeatJson(entry.getKey().toString(), entry.getValue()));
        }
        return jsonList;
    }

    public List<HeatRecipe> getRecipeList() {
        ArrayList<HeatRecipe> recipes = new ArrayList<HeatRecipe>();
        for (Map.Entry<ResourceLocation, Integer> entry : this.heatMap.entrySet()) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(entry.getKey());
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(entry.getKey());
            List<Object> blockList = new ArrayList<ItemStack>();
            ArrayList<FluidStack> fluidList = new ArrayList<FluidStack>();
            if (block == Blocks.field_150480_ab) {
                blockList.add(new ItemStack((IItemProvider)Items.field_151033_d));
            } else {
                if (block != Blocks.field_150350_a && fluid == Fluids.field_204541_a) {
                    Tag blockTag = BlockTags.func_199896_a().func_199910_a(entry.getKey());
                    if (blockTag != null) {
                        blockList = blockTag.func_199885_a().stream().map(ItemStack::new).collect(Collectors.toList());
                    } else {
                        blockList.add(new ItemStack((IItemProvider)block));
                    }
                }
                if (fluid != Fluids.field_204541_a) {
                    fluidList.add(new FluidStack(fluid, 1000));
                }
            }
            recipes.add(new HeatRecipe(blockList, fluidList, entry.getValue()));
        }
        return recipes;
    }
}

