/*
 * Decompiled with CFR 0.152.
 */
package com.novamachina.exnihilosequentia.common.registries.hammer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.novamachina.exnihilosequentia.common.api.ExNihiloRegistries;
import com.novamachina.exnihilosequentia.common.compat.jei.hammer.HammerRecipe;
import com.novamachina.exnihilosequentia.common.json.AnnotatedDeserializer;
import com.novamachina.exnihilosequentia.common.json.HammerJson;
import com.novamachina.exnihilosequentia.common.registries.AbstractModRegistry;
import com.novamachina.exnihilosequentia.common.utility.Constants;
import com.novamachina.exnihilosequentia.common.utility.LogUtil;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraftforge.registries.ForgeRegistries;

public class HammerRegistry
extends AbstractModRegistry {
    private final Map<ResourceLocation, ResourceLocation> hammerDrops = new HashMap<ResourceLocation, ResourceLocation>();

    public HammerRegistry(ExNihiloRegistries.ModBus bus) {
        bus.register(this);
    }

    public void addRecipe(Block input, Block output) {
        this.addRecipe(input.getRegistryName(), output.getRegistryName());
    }

    private void addRecipe(ResourceLocation input, ResourceLocation output) {
        if (this.hammerDrops.containsKey(input)) {
            LogUtil.warn(String.format("%s: Input %s already has a drop assigned. Skipping...", Constants.Json.HAMMER_FILE, input.toString()));
            return;
        }
        this.hammerDrops.put(input, output);
    }

    public Block getResult(ResourceLocation input) {
        ResourceLocation output;
        if (this.hammerDrops.containsKey(input) && ForgeRegistries.BLOCKS.containsKey(output = this.hammerDrops.get(input))) {
            return (Block)ForgeRegistries.BLOCKS.getValue(output);
        }
        return (Block)ForgeRegistries.BLOCKS.getValue(input);
    }

    @Override
    public void clear() {
        this.hammerDrops.clear();
    }

    @Override
    public List<HammerJson> toJSONReady() {
        ArrayList<HammerJson> jsonList = new ArrayList<HammerJson>();
        for (Map.Entry<ResourceLocation, ResourceLocation> entry : this.hammerDrops.entrySet()) {
            jsonList.add(new HammerJson(entry.getKey().toString(), entry.getValue().toString()));
        }
        return jsonList;
    }

    @Override
    public void useJson() {
        if (this.generateJson(Constants.Json.HAMMER_FILE, this)) {
            return;
        }
        try {
            List<HammerJson> list = this.readJson();
            for (HammerJson entry : list) {
                try {
                    if (this.itemExists(entry.getInput())) {
                        ResourceLocation inputID = new ResourceLocation(entry.getInput());
                        if (this.itemExists(entry.getOutput())) {
                            ResourceLocation outputID = new ResourceLocation(entry.getOutput());
                            this.addRecipe(inputID, outputID);
                            continue;
                        }
                        LogUtil.warn(String.format("%s: Entry \"%s\" does not exist...Skipping...", Constants.Json.HAMMER_FILE, entry.getOutput()));
                        continue;
                    }
                    LogUtil.warn(String.format("%s: Entry \"%s\" does not exist...Skipping...", Constants.Json.HAMMER_FILE, entry.getInput()));
                }
                catch (ResourceLocationException e) {
                    LogUtil.warn(String.format("%s: %s. Skipping...", Constants.Json.HAMMER_FILE, e.getMessage()));
                }
            }
        }
        catch (JsonParseException e) {
            LogUtil.error(String.format("Malformed %s", Constants.Json.HAMMER_FILE));
            LogUtil.error(e.getMessage());
            if (e.getMessage().contains("IllegalStateException")) {
                LogUtil.error("Please consider deleting the file and regenerating it.");
            }
            LogUtil.error("Falling back to defaults");
            this.clear();
            ExNihiloRegistries.BUS.getDefaults().forEach(registry -> registry.registerHammer(this));
        }
    }

    private boolean itemExists(String entry) throws ResourceLocationException {
        ResourceLocation itemID = new ResourceLocation(entry);
        return ForgeRegistries.BLOCKS.containsKey(itemID);
    }

    private List<HammerJson> readJson() {
        Type listType = new TypeToken<ArrayList<HammerJson>>(){}.getType();
        Gson gson = new GsonBuilder().registerTypeAdapter(listType, new AnnotatedDeserializer()).create();
        Path path = Constants.Json.baseJsonPath.resolve(Constants.Json.HAMMER_FILE);
        List list = null;
        try {
            StringBuilder builder = new StringBuilder();
            Files.readAllLines(path).forEach(builder::append);
            list = (List)gson.fromJson(builder.toString(), listType);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    public boolean isHammerable(ResourceLocation blockID) {
        return this.hammerDrops.containsKey(blockID);
    }

    public List<HammerRecipe> getRecipeList() {
        ArrayList<HammerRecipe> recipes = new ArrayList<HammerRecipe>();
        for (ResourceLocation inputID : this.hammerDrops.keySet()) {
            Block input = (Block)ForgeRegistries.BLOCKS.getValue(inputID);
            Block output = this.getResult(inputID);
            recipes.add(new HammerRecipe(new ItemStack((IItemProvider)input), new ItemStack((IItemProvider)output)));
        }
        return recipes;
    }
}

