/*
 * Decompiled with CFR 0.152.
 */
package com.novamachina.exnihilosequentia.common.registries.sieve;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.novamachina.exnihilosequentia.common.api.ExNihiloRegistries;
import com.novamachina.exnihilosequentia.common.compat.jei.sieve.SieveRecipe;
import com.novamachina.exnihilosequentia.common.item.mesh.EnumMesh;
import com.novamachina.exnihilosequentia.common.json.AnnotatedDeserializer;
import com.novamachina.exnihilosequentia.common.json.SieveJson;
import com.novamachina.exnihilosequentia.common.registries.AbstractModRegistry;
import com.novamachina.exnihilosequentia.common.registries.sieve.SieveDropEntry;
import com.novamachina.exnihilosequentia.common.utility.Config;
import com.novamachina.exnihilosequentia.common.utility.Constants;
import com.novamachina.exnihilosequentia.common.utility.LogUtil;
import com.novamachina.exnihilosequentia.common.utility.TagUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraftforge.registries.ForgeRegistries;

public class SieveRegistry
extends AbstractModRegistry {
    private final Map<ResourceLocation, List<SieveDropEntry>> stringMeshMap = new HashMap<ResourceLocation, List<SieveDropEntry>>();
    private final Map<ResourceLocation, List<SieveDropEntry>> flintMeshMap = new HashMap<ResourceLocation, List<SieveDropEntry>>();
    private final Map<ResourceLocation, List<SieveDropEntry>> ironMeshMap = new HashMap<ResourceLocation, List<SieveDropEntry>>();
    private final Map<ResourceLocation, List<SieveDropEntry>> diamondMeshMap = new HashMap<ResourceLocation, List<SieveDropEntry>>();
    private final Map<ResourceLocation, List<SieveDropEntry>> waterloggedStringMeshMap = new HashMap<ResourceLocation, List<SieveDropEntry>>();
    private final Map<ResourceLocation, List<SieveDropEntry>> waterloggedFlintMeshMap = new HashMap<ResourceLocation, List<SieveDropEntry>>();
    private final Map<ResourceLocation, List<SieveDropEntry>> waterloggedIronMeshMap = new HashMap<ResourceLocation, List<SieveDropEntry>>();
    private final Map<ResourceLocation, List<SieveDropEntry>> waterloggedDiamondMeshMap = new HashMap<ResourceLocation, List<SieveDropEntry>>();
    private final boolean flattenRecipes = (Boolean)Config.FLATTEN_SIEVE_RECIPES.get();

    public SieveRegistry(ExNihiloRegistries.ModBus bus) {
        bus.register(this);
    }

    public void addDrop(Block input, Item result, float rarity, EnumMesh meshType, boolean isWaterlogged) {
        this.addDrop(input.getRegistryName(), result.getRegistryName(), rarity, meshType, isWaterlogged);
    }

    public void addDrop(ResourceLocation input, ResourceLocation result, float rarity, EnumMesh meshType, boolean isWaterlogged) {
        if (isWaterlogged) {
            this.insertIntoWaterloggedMap(input, result, rarity, meshType);
        } else {
            this.insertIntoDryMap(input, result, rarity, meshType);
        }
    }

    private void insertIntoDryMap(ResourceLocation input, ResourceLocation result, float rarity, EnumMesh meshType) {
        switch (meshType) {
            case STRING: {
                this.insertIntoMap(this.stringMeshMap, input, result, rarity);
                break;
            }
            case FLINT: {
                this.insertIntoMap(this.flintMeshMap, input, result, rarity);
                break;
            }
            case IRON: {
                this.insertIntoMap(this.ironMeshMap, input, result, rarity);
                break;
            }
            case DIAMOND: {
                this.insertIntoMap(this.diamondMeshMap, input, result, rarity);
                break;
            }
            default: {
                LogUtil.warn(String.format("Mesh type \"%s\" does not exist.", meshType.func_176610_l()));
            }
        }
    }

    private void insertIntoWaterloggedMap(ResourceLocation input, ResourceLocation result, float rarity, EnumMesh meshType) {
        switch (meshType) {
            case STRING: {
                this.insertIntoMap(this.waterloggedStringMeshMap, input, result, rarity);
                break;
            }
            case FLINT: {
                this.insertIntoMap(this.waterloggedFlintMeshMap, input, result, rarity);
                break;
            }
            case IRON: {
                this.insertIntoMap(this.waterloggedIronMeshMap, input, result, rarity);
                break;
            }
            case DIAMOND: {
                this.insertIntoMap(this.waterloggedDiamondMeshMap, input, result, rarity);
                break;
            }
            default: {
                LogUtil.warn(String.format("Mesh type \"%s\" does not exist.", meshType.func_176610_l()));
            }
        }
    }

    private void insertIntoMap(Map<ResourceLocation, List<SieveDropEntry>> map, ResourceLocation input, ResourceLocation result, float rarity) {
        if (map.containsKey(input)) {
            map.get(input).add(new SieveDropEntry(result, rarity));
        } else {
            ArrayList<SieveDropEntry> list = new ArrayList<SieveDropEntry>();
            list.add(new SieveDropEntry(result, rarity));
            map.put(input, list);
        }
    }

    public List<SieveDropEntry> getDrops(Block input, EnumMesh meshType, boolean isWaterlogged) {
        return this.getDrops(input.getRegistryName(), meshType, isWaterlogged);
    }

    public List<SieveDropEntry> getDrops(ResourceLocation input, EnumMesh meshType, boolean isWaterlogged) {
        ArrayList<SieveDropEntry> returnList = new ArrayList<SieveDropEntry>();
        switch (meshType) {
            case DIAMOND: {
                returnList.addAll(this.retrieveFromMap(isWaterlogged ? this.waterloggedDiamondMeshMap : this.diamondMeshMap, input));
                if (!this.flattenRecipes) break;
            }
            case IRON: {
                returnList.addAll(this.retrieveFromMap(isWaterlogged ? this.waterloggedIronMeshMap : this.ironMeshMap, input));
                if (!this.flattenRecipes) break;
            }
            case FLINT: {
                returnList.addAll(this.retrieveFromMap(isWaterlogged ? this.waterloggedFlintMeshMap : this.flintMeshMap, input));
                if (!this.flattenRecipes) break;
            }
            case STRING: {
                returnList.addAll(this.retrieveFromMap(isWaterlogged ? this.waterloggedStringMeshMap : this.stringMeshMap, input));
                break;
            }
            default: {
                LogUtil.warn(String.format("Mesh type \"%s\" does not exist.", meshType.func_176610_l()));
            }
        }
        return returnList;
    }

    @Override
    public void useJson() {
        if (this.generateJson(Constants.Json.SIEVE_FILE, this)) {
            return;
        }
        try {
            List<SieveJson> registryJson = this.readJson();
            for (SieveJson entry : registryJson) {
                try {
                    if (this.itemExists(entry.getInput())) {
                        ResourceLocation inputID = new ResourceLocation(entry.getInput());
                        if (this.itemExists(entry.getResult())) {
                            ResourceLocation outputID = new ResourceLocation(entry.getResult());
                            this.addDrop(inputID, outputID, entry.getRarity().floatValue(), entry.getMesh(), entry.isWaterlogged());
                            continue;
                        }
                        LogUtil.warn(String.format("%s: Entry \"%s\" does not exist...Skipping...", Constants.Json.SIEVE_FILE, entry.getResult()));
                        continue;
                    }
                    LogUtil.warn(String.format("%s: Entry \"%s\" does not exist...Skipping...", Constants.Json.SIEVE_FILE, entry.getInput()));
                }
                catch (ResourceLocationException e) {
                    LogUtil.warn(String.format("%s: %s. Skipping...", Constants.Json.SIEVE_FILE, e.getMessage()));
                }
            }
        }
        catch (JsonParseException e) {
            LogUtil.error(String.format("Malformed %s", Constants.Json.SIEVE_FILE));
            LogUtil.error(e.getMessage());
            if (e.getMessage().contains("IllegalStateException")) {
                LogUtil.error("Please consider deleting the file and regenerating it.");
            }
            LogUtil.error("Falling back to defaults");
            this.clear();
            ExNihiloRegistries.BUS.getDefaults().forEach(registry -> registry.registerSieve(this));
        }
    }

    private boolean itemExists(String entry) throws ResourceLocationException {
        ResourceLocation itemID = new ResourceLocation(entry);
        return TagUtils.isTag(itemID) || ForgeRegistries.BLOCKS.containsKey(itemID) || ForgeRegistries.ITEMS.containsKey(itemID);
    }

    protected List<SieveJson> readJson() throws JsonParseException {
        Type listType = new TypeToken<ArrayList<SieveJson>>(){}.getType();
        Gson gson = new GsonBuilder().registerTypeAdapter(listType, new AnnotatedDeserializer()).create();
        Path path = Constants.Json.baseJsonPath.resolve(Constants.Json.SIEVE_FILE);
        List registryJson = null;
        try {
            StringBuilder builder = new StringBuilder();
            Files.readAllLines(path).forEach(builder::append);
            registryJson = (List)gson.fromJson(builder.toString(), listType);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return registryJson;
    }

    public void addMultiMeshDrop(Block input, Item result, Float stringRarity, Float flintRarity, Float ironRarity, Float diamondRarity, boolean isWaterlogged) {
        this.addMultiMeshDrop(input.getRegistryName(), result.getRegistryName(), stringRarity, flintRarity, ironRarity, diamondRarity, isWaterlogged);
    }

    private void addMultiMeshDrop(ResourceLocation input, ResourceLocation result, Float stringRarity, Float flintRarity, Float ironRarity, Float diamondRarity, boolean isWaterlogged) {
        if (stringRarity != null) {
            this.addDrop(input, result, stringRarity.floatValue(), EnumMesh.STRING, isWaterlogged);
        }
        if (flintRarity != null) {
            this.addDrop(input, result, flintRarity.floatValue(), EnumMesh.FLINT, isWaterlogged);
        }
        if (ironRarity != null) {
            this.addDrop(input, result, ironRarity.floatValue(), EnumMesh.IRON, isWaterlogged);
        }
        if (diamondRarity != null) {
            this.addDrop(input, result, diamondRarity.floatValue(), EnumMesh.DIAMOND, isWaterlogged);
        }
    }

    private Collection<SieveDropEntry> retrieveFromMap(Map<ResourceLocation, List<SieveDropEntry>> dropsMap, ResourceLocation input) {
        ArrayList<SieveDropEntry> returnList = new ArrayList<SieveDropEntry>();
        Collection<ResourceLocation> tags = TagUtils.getTags(input);
        for (ResourceLocation tag : tags) {
            if (!dropsMap.containsKey(tag)) continue;
            returnList.addAll((Collection<SieveDropEntry>)dropsMap.get(tag));
            return returnList;
        }
        if (!dropsMap.containsKey(input)) {
            return returnList;
        }
        returnList.addAll((Collection<SieveDropEntry>)dropsMap.get(input));
        return returnList;
    }

    public boolean isBlockSiftable(Block block, EnumMesh mesh, boolean isWaterlogged) {
        Objects.requireNonNull(block.getRegistryName());
        ResourceLocation blockId = block.getRegistryName();
        boolean isSiftable = false;
        switch (mesh) {
            case DIAMOND: {
                boolean bl = isSiftable = isWaterlogged ? this.waterloggedDiamondMeshMap.containsKey(blockId) : this.diamondMeshMap.containsKey(blockId);
                if (!this.flattenRecipes || isSiftable) break;
            }
            case IRON: {
                boolean bl = isSiftable = isWaterlogged ? this.waterloggedIronMeshMap.containsKey(blockId) : this.ironMeshMap.containsKey(blockId);
                if (!this.flattenRecipes || isSiftable) break;
            }
            case FLINT: {
                boolean bl = isSiftable = isWaterlogged ? this.waterloggedFlintMeshMap.containsKey(blockId) : this.flintMeshMap.containsKey(blockId);
                if (!this.flattenRecipes || isSiftable) break;
            }
            case STRING: {
                isSiftable = isWaterlogged ? this.waterloggedStringMeshMap.containsKey(blockId) : this.stringMeshMap.containsKey(blockId);
            }
        }
        return isSiftable;
    }

    @Override
    public void clear() {
        this.stringMeshMap.clear();
        this.flintMeshMap.clear();
        this.ironMeshMap.clear();
        this.diamondMeshMap.clear();
    }

    @Override
    public List<SieveJson> toJSONReady() {
        List<SieveDropEntry> dropList;
        ResourceLocation input;
        ArrayList<SieveJson> jsonList = new ArrayList<SieveJson>();
        for (Map.Entry<ResourceLocation, List<SieveDropEntry>> entry : this.stringMeshMap.entrySet()) {
            input = entry.getKey();
            dropList = entry.getValue();
            for (SieveDropEntry dropEntry : dropList) {
                jsonList.add(new SieveJson(input.toString(), dropEntry.getResult().toString(), Float.valueOf(dropEntry.getRarity()), EnumMesh.STRING, false));
            }
        }
        for (Map.Entry<ResourceLocation, List<SieveDropEntry>> entry : this.flintMeshMap.entrySet()) {
            input = entry.getKey();
            dropList = entry.getValue();
            for (SieveDropEntry dropEntry : dropList) {
                jsonList.add(new SieveJson(input.toString(), dropEntry.getResult().toString(), Float.valueOf(dropEntry.getRarity()), EnumMesh.FLINT, false));
            }
        }
        for (Map.Entry<ResourceLocation, List<SieveDropEntry>> entry : this.ironMeshMap.entrySet()) {
            input = entry.getKey();
            dropList = entry.getValue();
            for (SieveDropEntry dropEntry : dropList) {
                jsonList.add(new SieveJson(input.toString(), dropEntry.getResult().toString(), Float.valueOf(dropEntry.getRarity()), EnumMesh.IRON, false));
            }
        }
        for (Map.Entry<ResourceLocation, List<SieveDropEntry>> entry : this.diamondMeshMap.entrySet()) {
            input = entry.getKey();
            dropList = entry.getValue();
            for (SieveDropEntry dropEntry : dropList) {
                jsonList.add(new SieveJson(input.toString(), dropEntry.getResult().toString(), Float.valueOf(dropEntry.getRarity()), EnumMesh.DIAMOND, false));
            }
        }
        for (Map.Entry<ResourceLocation, List<SieveDropEntry>> entry : this.waterloggedStringMeshMap.entrySet()) {
            input = entry.getKey();
            dropList = entry.getValue();
            for (SieveDropEntry dropEntry : dropList) {
                jsonList.add(new SieveJson(input.toString(), dropEntry.getResult().toString(), Float.valueOf(dropEntry.getRarity()), EnumMesh.STRING, true));
            }
        }
        for (Map.Entry<ResourceLocation, List<SieveDropEntry>> entry : this.waterloggedFlintMeshMap.entrySet()) {
            input = entry.getKey();
            dropList = entry.getValue();
            for (SieveDropEntry dropEntry : dropList) {
                jsonList.add(new SieveJson(input.toString(), dropEntry.getResult().toString(), Float.valueOf(dropEntry.getRarity()), EnumMesh.FLINT, true));
            }
        }
        for (Map.Entry<ResourceLocation, List<SieveDropEntry>> entry : this.waterloggedIronMeshMap.entrySet()) {
            input = entry.getKey();
            dropList = entry.getValue();
            for (SieveDropEntry dropEntry : dropList) {
                jsonList.add(new SieveJson(input.toString(), dropEntry.getResult().toString(), Float.valueOf(dropEntry.getRarity()), EnumMesh.IRON, true));
            }
        }
        for (Map.Entry<ResourceLocation, List<SieveDropEntry>> entry : this.waterloggedDiamondMeshMap.entrySet()) {
            input = entry.getKey();
            dropList = entry.getValue();
            for (SieveDropEntry dropEntry : dropList) {
                jsonList.add(new SieveJson(input.toString(), dropEntry.getResult().toString(), Float.valueOf(dropEntry.getRarity()), EnumMesh.DIAMOND, true));
            }
        }
        return jsonList;
    }

    public List<SieveRecipe> getDryRecipeList() {
        ArrayList<SieveRecipe> recipes = new ArrayList<SieveRecipe>();
        recipes.addAll(this.collectRecipes(EnumMesh.STRING, this.stringMeshMap, false));
        recipes.addAll(this.collectRecipes(EnumMesh.FLINT, this.flintMeshMap, false));
        recipes.addAll(this.collectRecipes(EnumMesh.IRON, this.ironMeshMap, false));
        recipes.addAll(this.collectRecipes(EnumMesh.DIAMOND, this.diamondMeshMap, false));
        return recipes;
    }

    private List<SieveRecipe> collectRecipes(EnumMesh mesh, Map<ResourceLocation, List<SieveDropEntry>> dropMap, boolean isWaterlogged) {
        ArrayList<SieveRecipe> recipes = new ArrayList<SieveRecipe>();
        for (ResourceLocation inputID : dropMap.keySet()) {
            SieveRecipe recipe = this.createRecipe(mesh, inputID, isWaterlogged);
            if (recipes.contains(recipe)) continue;
            recipes.add(this.createRecipe(mesh, inputID, isWaterlogged));
        }
        return recipes;
    }

    private SieveRecipe createRecipe(EnumMesh mesh, ResourceLocation inputID, boolean isWaterlogged) {
        ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
        inputs.add(Collections.singletonList(new ItemStack((IItemProvider)mesh.getRegistryObject().get())));
        Tag blockTag = BlockTags.func_199896_a().func_199910_a(inputID);
        ArrayList<ItemStack> inputBlocks = new ArrayList<ItemStack>();
        if (blockTag != null) {
            inputBlocks.addAll(blockTag.func_199885_a().stream().map(ItemStack::new).collect(Collectors.toList()));
        } else {
            inputBlocks.add(new ItemStack((IItemProvider)ForgeRegistries.BLOCKS.getValue(inputID)));
        }
        List<SieveDropEntry> dropEntries = this.getDrops((Block)ForgeRegistries.BLOCKS.getValue(inputID), mesh, isWaterlogged);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (SieveDropEntry entry : dropEntries) {
            boolean alreadyExists = false;
            ItemStack stack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(entry.getResult()));
            for (ItemStack itemStack : drops) {
                if (itemStack.func_77973_b() != stack.func_77973_b()) continue;
                itemStack.func_190917_f(1);
                alreadyExists = true;
            }
            if (alreadyExists) continue;
            drops.add(new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(entry.getResult())));
        }
        inputs.add(inputBlocks);
        return new SieveRecipe(inputs, drops);
    }

    @Deprecated
    public List<SieveDropEntry> getAllDrops(ResourceLocation input, EnumMesh mesh, boolean isWaterlogged) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(input);
        return this.getAllDrops(block, mesh, isWaterlogged);
    }

    @Deprecated
    private List<SieveDropEntry> getAllDrops(Block input, EnumMesh meshType, boolean isWaterlogged) {
        ArrayList<SieveDropEntry> returnList = new ArrayList<SieveDropEntry>();
        List<SieveDropEntry> list = null;
        ResourceLocation blockID = input.getRegistryName();
        switch (meshType) {
            case DIAMOND: {
                List<SieveDropEntry> list2 = list = isWaterlogged ? this.waterloggedDiamondMeshMap.get(blockID) : this.diamondMeshMap.get(blockID);
                if (list != null) {
                    for (SieveDropEntry element : list) {
                        if (returnList.contains(element)) continue;
                        returnList.add(element);
                    }
                }
                if (!this.flattenRecipes) break;
            }
            case IRON: {
                List<SieveDropEntry> list3 = list = isWaterlogged ? this.waterloggedIronMeshMap.get(blockID) : this.ironMeshMap.get(blockID);
                if (list != null) {
                    for (SieveDropEntry element : list) {
                        if (returnList.contains(element)) continue;
                        returnList.add(element);
                    }
                }
                if (!this.flattenRecipes) break;
            }
            case FLINT: {
                List<SieveDropEntry> list4 = list = isWaterlogged ? this.waterloggedFlintMeshMap.get(blockID) : this.flintMeshMap.get(blockID);
                if (list != null) {
                    for (SieveDropEntry element : list) {
                        if (returnList.contains(element)) continue;
                        returnList.add(element);
                    }
                }
                if (!this.flattenRecipes) break;
            }
            case STRING: {
                List<SieveDropEntry> list5 = list = isWaterlogged ? this.waterloggedStringMeshMap.get(blockID) : this.stringMeshMap.get(blockID);
                if (list == null) break;
                for (SieveDropEntry element : list) {
                    if (returnList.contains(element)) continue;
                    returnList.add(element);
                }
                break;
            }
            default: {
                LogUtil.warn(String.format("Mesh type \"%s\" does not exist.", meshType.func_176610_l()));
            }
        }
        if (list == null) {
            list = new ArrayList<SieveDropEntry>();
        }
        return returnList;
    }

    public List<SieveRecipe> getWetRecipeList() {
        ArrayList<SieveRecipe> recipes = new ArrayList<SieveRecipe>();
        recipes.addAll(this.collectRecipes(EnumMesh.STRING, this.waterloggedStringMeshMap, true));
        recipes.addAll(this.collectRecipes(EnumMesh.FLINT, this.waterloggedFlintMeshMap, true));
        recipes.addAll(this.collectRecipes(EnumMesh.IRON, this.waterloggedIronMeshMap, true));
        recipes.addAll(this.collectRecipes(EnumMesh.DIAMOND, this.waterloggedDiamondMeshMap, true));
        return recipes;
    }
}

