/*
 * Decompiled with CFR 0.152.
 */
package com.novamachina.exnihilosequentia.common.tileentity.barrel;

import com.novamachina.exnihilosequentia.common.tileentity.barrel.BarrelFluidHandler;
import com.novamachina.exnihilosequentia.common.tileentity.barrel.mode.AbstractBarrelMode;
import com.novamachina.exnihilosequentia.common.tileentity.barrel.mode.BarrelModeRegistry;
import com.novamachina.exnihilosequentia.common.utility.Config;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class AbstractBarrelTile
extends TileEntity
implements ITickableTileEntity {
    public static int MAX_SOLID_AMOUNT = (Integer)Config.BARREL_MAX_SOLID_AMOUNT.get();
    public static int MAX_FLUID_AMOUNT = (Integer)Config.BARREL_NUMBER_OF_BUCKETS.get() * 1000;
    private ItemStackHandler inventory;
    private final LazyOptional<IItemHandler> inventoryHolder = LazyOptional.of(() -> this.inventory);
    private BarrelFluidHandler tank;
    private final LazyOptional<IFluidHandler> tankHolder = LazyOptional.of(() -> this.tank);
    private AbstractBarrelMode mode = BarrelModeRegistry.getModeFromName("empty");
    private int solidAmount = 0;

    public AbstractBarrelTile(TileEntityType<? extends AbstractBarrelTile> tileEntityType) {
        super(tileEntityType);
        this.inventory = new ItemStackHandler();
        this.tank = new BarrelFluidHandler(this);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_201670_d()) {
            return;
        }
        if (this.mode.isEmptyMode() || this.mode.getModeName().equals("fluid")) {
            BlockPos abovePos = this.field_174879_c.func_177982_a(0, 1, 0);
            if (this.func_145831_w().func_175727_C(abovePos)) {
                FluidStack stack = new FluidStack((Fluid)Fluids.field_204546_a, ((Integer)Config.RAIN_FILL_AMOUNT.get()).intValue());
                this.tank.fill(stack, IFluidHandler.FluidAction.EXECUTE);
            }
        }
        this.mode.tick(this);
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("inventory", (INBT)this.inventory.serializeNBT());
        compound.func_218657_a("tank", (INBT)this.tank.writeToNBT(new CompoundNBT()));
        compound.func_74778_a("barrelMode", this.mode.getModeName());
        compound.func_218657_a("modeInfo", (INBT)this.mode.write());
        compound.func_74768_a("solidAmount", this.solidAmount);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(CompoundNBT compound) {
        if (compound.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        if (compound.func_74764_b("tank")) {
            this.tank.readFromNBT(compound.func_74775_l("tank"));
        }
        if (compound.func_74764_b("barrelMode")) {
            this.mode = BarrelModeRegistry.getModeFromName(compound.func_74779_i("barrelMode"));
        }
        if (compound.func_74764_b("modeInfo")) {
            this.mode.read(compound.func_74775_l("modeInfo"));
        }
        if (compound.func_74764_b("solidAmount")) {
            this.solidAmount = compound.func_74762_e("solidAmount");
        }
        super.func_145839_a(compound);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT nbt = pkt.func_148857_g();
        if (nbt.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(nbt.func_74775_l("inventory"));
        }
        if (nbt.func_74764_b("tank")) {
            this.tank.readFromNBT(nbt.func_74775_l("tank"));
        }
        this.mode = BarrelModeRegistry.getModeFromName(nbt.func_74779_i("mode"));
        if (nbt.func_74764_b("modeInfo")) {
            this.mode.read(nbt.func_74775_l("modeInfo"));
        }
        this.solidAmount = nbt.func_74762_e("solidAmount");
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("inventory", (INBT)this.inventory.serializeNBT());
        nbt.func_218657_a("tank", (INBT)this.tank.writeToNBT(new CompoundNBT()));
        nbt.func_74778_a("mode", this.mode.getModeName());
        nbt.func_218657_a("modeInfo", (INBT)this.mode.write());
        nbt.func_74768_a("solidAmount", this.solidAmount);
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, nbt);
    }

    public ActionResultType onBlockActivated(PlayerEntity player, Hand handIn, IFluidHandler fluidHandler, IItemHandler itemHandler) {
        return this.mode.onBlockActivated(this, player, handIn, fluidHandler, itemHandler);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryHolder.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.tankHolder.cast();
        }
        return super.getCapability(cap, side);
    }

    public int getSolidAmount() {
        return this.solidAmount;
    }

    public int getFluidAmount() {
        return this.tank.getFluidAmount();
    }

    public boolean addSolid(int amount) {
        if (amount <= 0) {
            return false;
        }
        if (this.solidAmount == MAX_SOLID_AMOUNT) {
            return false;
        }
        this.solidAmount += amount;
        if (this.solidAmount > MAX_SOLID_AMOUNT) {
            this.solidAmount = MAX_SOLID_AMOUNT;
        }
        return true;
    }

    public void removeSolid(int amount) {
        this.solidAmount -= amount;
        if (this.solidAmount < 0) {
            this.solidAmount = 0;
        }
    }

    public AbstractBarrelMode getMode() {
        return this.mode;
    }

    public void setMode(String nextState) {
        this.mode = BarrelModeRegistry.getModeFromName(nextState);
        if (this.mode == null) {
            this.mode = BarrelModeRegistry.getModeFromName("empty");
        }
    }

    public void setMode(AbstractBarrelMode mode) {
        this.mode = mode;
    }

    public ResourceLocation getSolidTexture() {
        if (!this.inventory.getStackInSlot(0).func_190926_b()) {
            return this.inventory.getStackInSlot(0).func_77973_b().getRegistryName();
        }
        return null;
    }

    public Fluid getFluid() {
        if (!this.tank.isEmpty()) {
            return this.tank.getFluid().getFluid();
        }
        return null;
    }

    public float getSolidProportion() {
        return (float)this.solidAmount / (float)MAX_SOLID_AMOUNT;
    }

    public float getFluidProportion() {
        return (float)this.tank.getFluidAmount() / (float)MAX_FLUID_AMOUNT;
    }

    public void func_145843_s() {
        super.func_145843_s();
        NonNullList list = NonNullList.func_191196_a();
        list.add((Object)this.inventory.getStackInSlot(0));
        InventoryHelper.func_219961_a((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (NonNullList)list);
    }

    public List<ITextComponent> getWailaInfo() {
        return this.mode.getWailaInfo(this);
    }

    public abstract boolean canAcceptFluidTemperature(FluidStack var1);
}

