/*
 * Decompiled with CFR 0.152.
 */
package com.novamachina.exnihilosequentia.common.tileentity.barrel.mode;

import com.novamachina.exnihilosequentia.common.tileentity.barrel.mode.AbstractBarrelMode;
import com.novamachina.exnihilosequentia.common.tileentity.barrel.mode.BlockBarrelMode;
import com.novamachina.exnihilosequentia.common.tileentity.barrel.mode.CompostBarrelMode;
import com.novamachina.exnihilosequentia.common.tileentity.barrel.mode.EmptyBarrelMode;
import com.novamachina.exnihilosequentia.common.tileentity.barrel.mode.FluidTransformBarrelMode;
import com.novamachina.exnihilosequentia.common.tileentity.barrel.mode.FluidsBarrelMode;
import com.novamachina.exnihilosequentia.common.tileentity.barrel.mode.MobSpawnBarrelMode;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class BarrelModeRegistry {
    private static final Map<String, Supplier<AbstractBarrelMode>> modeNameMap = new HashMap<String, Supplier<AbstractBarrelMode>>();
    private static final Map<TriggerType, ArrayList<Supplier<AbstractBarrelMode>>> modeMap = new EnumMap<TriggerType, ArrayList<Supplier<AbstractBarrelMode>>>(TriggerType.class);

    public static AbstractBarrelMode getModeFromName(String barrelMode) {
        return (AbstractBarrelMode)((Supplier)modeNameMap.getOrDefault(barrelMode, null)).get();
    }

    public static ArrayList<Supplier<AbstractBarrelMode>> getModes(TriggerType type) {
        return modeMap.get((Object)type);
    }

    public static void initialize() {
        BarrelModeRegistry.addMode(() -> new EmptyBarrelMode("empty"), TriggerType.NONE);
        BarrelModeRegistry.addMode(() -> new CompostBarrelMode("compost"), TriggerType.ITEM);
        BarrelModeRegistry.addMode(() -> new FluidsBarrelMode("fluid"), TriggerType.FLUID);
        BarrelModeRegistry.addMode(() -> new BlockBarrelMode("block"), TriggerType.NONE);
        BarrelModeRegistry.addMode(() -> new MobSpawnBarrelMode("mob"), TriggerType.NONE);
        BarrelModeRegistry.addMode(() -> new FluidTransformBarrelMode("transform"), TriggerType.NONE);
    }

    public static void addMode(Supplier<AbstractBarrelMode> mode, TriggerType type) {
        ArrayList<Supplier<AbstractBarrelMode>> list = modeMap.get((Object)type);
        if (list == null) {
            list = new ArrayList();
        }
        list.add(mode);
        modeMap.put(type, list);
        modeNameMap.put(mode.get().getModeName(), mode);
    }

    public static enum TriggerType {
        ITEM,
        FLUID,
        NONE;

    }
}

