/*
 * Decompiled with CFR 0.152.
 */
package com.novamachina.exnihilosequentia.common.tileentity.barrel.mode;

import com.novamachina.exnihilosequentia.common.api.ExNihiloRegistries;
import com.novamachina.exnihilosequentia.common.tileentity.barrel.AbstractBarrelTile;
import com.novamachina.exnihilosequentia.common.tileentity.barrel.mode.AbstractBarrelMode;
import com.novamachina.exnihilosequentia.common.utility.Config;
import com.novamachina.exnihilosequentia.common.utility.StringUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class CompostBarrelMode
extends AbstractBarrelMode {
    private int currentProgress = 0;

    public CompostBarrelMode(String name) {
        super(name);
    }

    @Override
    public void tick(AbstractBarrelTile barrelTile) {
        if (barrelTile.getSolidAmount() >= AbstractBarrelTile.MAX_SOLID_AMOUNT && barrelTile.getInventory().getStackInSlot(0).func_190926_b()) {
            ++this.currentProgress;
            this.spawnParticle(barrelTile);
            if (this.currentProgress >= (Integer)Config.SECONDS_TO_COMPOST.get() * 20) {
                this.currentProgress = 0;
                barrelTile.getInventory().setStackInSlot(0, new ItemStack((IItemProvider)ForgeRegistries.BLOCKS.getValue(Blocks.field_150346_d.getRegistryName())));
                barrelTile.removeSolid(barrelTile.getSolidAmount());
                barrelTile.setMode("block");
            }
        }
    }

    @Override
    public ActionResultType onBlockActivated(AbstractBarrelTile barrelTile, PlayerEntity player, Hand handIn, IFluidHandler fluidHandler, IItemHandler itemHandler) {
        if (ExNihiloRegistries.COMPOST_REGISTRY.containsSolid((IItemProvider)player.func_184586_b(handIn).func_77973_b()) && barrelTile.addSolid(ExNihiloRegistries.COMPOST_REGISTRY.getSolidAmount((IItemProvider)player.func_184586_b(handIn).func_77973_b()))) {
            player.func_184586_b(handIn).func_190918_g(1);
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public boolean canFillWithFluid(AbstractBarrelTile barrel) {
        return false;
    }

    @Override
    public boolean isEmptyMode() {
        return false;
    }

    @Override
    protected boolean isTriggerItem(ItemStack stack) {
        return ExNihiloRegistries.COMPOST_REGISTRY.containsSolid((IItemProvider)stack.func_77973_b());
    }

    @Override
    public void read(CompoundNBT nbt) {
        this.currentProgress = nbt.func_74762_e("currentProgress");
    }

    @Override
    public CompoundNBT write() {
        CompoundNBT modeInfo = new CompoundNBT();
        modeInfo.func_74768_a("currentProgress", this.currentProgress);
        return modeInfo;
    }

    @Override
    protected void spawnParticle(AbstractBarrelTile barrelTile) {
        ((ServerWorld)barrelTile.func_145831_w()).func_195598_a((IParticleData)ParticleTypes.field_197620_m, (double)barrelTile.func_174877_v().func_177958_n() + barrelTile.func_145831_w().field_73012_v.nextDouble(), (double)barrelTile.func_174877_v().func_177956_o() + barrelTile.func_145831_w().field_73012_v.nextDouble(), (double)barrelTile.func_174877_v().func_177952_p() + barrelTile.func_145831_w().field_73012_v.nextDouble(), 1, 0.0, 0.0, 0.0, 0.05);
    }

    @Override
    public List<ITextComponent> getWailaInfo(AbstractBarrelTile barrelTile) {
        ArrayList<ITextComponent> info = new ArrayList<ITextComponent>();
        if (this.currentProgress <= 0) {
            info.add((ITextComponent)new TranslationTextComponent("waila.barrel.solidAmount", new Object[]{barrelTile.getSolidAmount(), AbstractBarrelTile.MAX_SOLID_AMOUNT}));
        } else {
            info.add((ITextComponent)new TranslationTextComponent("waila.progress", new Object[]{StringUtils.formatPercent(Float.valueOf((float)this.currentProgress / (float)((Integer)Config.SECONDS_TO_COMPOST.get() * 20)))}));
        }
        return info;
    }
}

