/*
 * Decompiled with CFR 0.152.
 */
package com.novamachina.exnihilosequentia.common.tileentity.barrel.mode;

import com.novamachina.exnihilosequentia.common.api.ExNihiloRegistries;
import com.novamachina.exnihilosequentia.common.tileentity.barrel.AbstractBarrelTile;
import com.novamachina.exnihilosequentia.common.tileentity.barrel.mode.AbstractBarrelMode;
import com.novamachina.exnihilosequentia.common.utility.Config;
import com.novamachina.exnihilosequentia.common.utility.StringUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class FluidTransformBarrelMode
extends AbstractBarrelMode {
    private int currentProgress = 0;

    public FluidTransformBarrelMode(String name) {
        super(name);
    }

    @Override
    public void tick(AbstractBarrelTile barrelTile) {
        Block blockBelow = barrelTile.func_145831_w().func_180495_p(barrelTile.func_174877_v().func_177982_a(0, -1, 0)).func_177230_c();
        Fluid fluidInTank = barrelTile.getTank().getFluid().getFluid();
        if (ExNihiloRegistries.FLUID_TRANSFORM_REGISTRY.isValidRecipe(fluidInTank, blockBelow)) {
            ++this.currentProgress;
            this.spawnParticle(barrelTile);
            if (this.currentProgress >= (Integer)Config.SECONDS_TO_FLUID_TRANSFORM.get() * 20) {
                this.currentProgress = 0;
                Fluid newFluid = ExNihiloRegistries.FLUID_TRANSFORM_REGISTRY.getResult(fluidInTank, blockBelow);
                barrelTile.getTank().setFluid(new FluidStack(newFluid, AbstractBarrelTile.MAX_FLUID_AMOUNT));
                barrelTile.setMode("fluid");
            }
        }
    }

    @Override
    public ActionResultType onBlockActivated(AbstractBarrelTile barrelTile, PlayerEntity player, Hand handIn, IFluidHandler fluidHandler, IItemHandler itemHandler) {
        return null;
    }

    @Override
    public boolean canFillWithFluid(AbstractBarrelTile barrel) {
        return false;
    }

    @Override
    public boolean isEmptyMode() {
        return false;
    }

    @Override
    protected boolean isTriggerItem(ItemStack stack) {
        return false;
    }

    @Override
    public void read(CompoundNBT nbt) {
        this.currentProgress = nbt.func_74762_e("currentProgress");
    }

    @Override
    public CompoundNBT write() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("currentProgress", this.currentProgress);
        return nbt;
    }

    @Override
    protected void spawnParticle(AbstractBarrelTile barrelTile) {
        ((ServerWorld)barrelTile.func_145831_w()).func_195598_a((IParticleData)ParticleTypes.field_197620_m, (double)barrelTile.func_174877_v().func_177958_n() + barrelTile.func_145831_w().field_73012_v.nextDouble(), (double)barrelTile.func_174877_v().func_177956_o() + barrelTile.func_145831_w().field_73012_v.nextDouble(), (double)barrelTile.func_174877_v().func_177952_p() + barrelTile.func_145831_w().field_73012_v.nextDouble(), 1, 0.0, 0.0, 0.0, 0.05);
    }

    @Override
    public List<ITextComponent> getWailaInfo(AbstractBarrelTile barrelTile) {
        ArrayList<ITextComponent> info = new ArrayList<ITextComponent>();
        info.add((ITextComponent)new TranslationTextComponent("waila.progress", new Object[]{StringUtils.formatPercent(Float.valueOf((float)this.currentProgress / (float)((Integer)Config.SECONDS_TO_FLUID_TRANSFORM.get() * 20)))}));
        return info;
    }
}

