/*
 * Decompiled with CFR 0.152.
 */
package com.novamachina.exnihilosequentia.common.tileentity.crucible;

import com.novamachina.exnihilosequentia.common.api.ExNihiloRegistries;
import com.novamachina.exnihilosequentia.common.registries.crucible.Meltable;
import com.novamachina.exnihilosequentia.common.tileentity.crucible.CrucilbeTypeEnum;
import com.novamachina.exnihilosequentia.common.tileentity.crucible.MeltableItemHandler;
import com.novamachina.exnihilosequentia.common.utility.Config;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class BaseCrucibleTile
extends TileEntity
implements ITickableTileEntity {
    protected static int MAX_FLUID_AMOUNT = (Integer)Config.CRUCIBLE_NUMBER_OF_BUCKETS.get() * 1000;
    protected MeltableItemHandler inventory;
    private final LazyOptional<IItemHandler> inventoryHolder = LazyOptional.of(() -> this.inventory);
    protected FluidTank tank;
    private final LazyOptional<IFluidHandler> tankHolder = LazyOptional.of(() -> this.tank);
    protected int ticksSinceLast = 0;
    protected int solidAmount = 0;
    protected ItemStack currentItem;

    public BaseCrucibleTile(TileEntityType<? extends BaseCrucibleTile> tileEntityType) {
        super(tileEntityType);
        this.inventory = new MeltableItemHandler(this.getCrucibleType());
        this.tank = new FluidTank(MAX_FLUID_AMOUNT);
        this.currentItem = ItemStack.field_190927_a;
    }

    public void func_145839_a(CompoundNBT compound) {
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        this.tank.readFromNBT(compound.func_74775_l("tank"));
        this.ticksSinceLast = compound.func_74762_e("ticksSinceLast");
        this.solidAmount = compound.func_74762_e("solidAmount");
        this.currentItem = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("currentItem"));
        super.func_145839_a(compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("inventory", (INBT)this.inventory.serializeNBT());
        compound.func_218657_a("tank", (INBT)this.tank.writeToNBT(new CompoundNBT()));
        compound.func_74768_a("ticksSinceLast", this.ticksSinceLast);
        compound.func_74768_a("solidAmount", this.solidAmount);
        compound.func_218657_a("currentItem", (INBT)this.currentItem.func_77955_b(new CompoundNBT()));
        return super.func_189515_b(compound);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryHolder.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.tankHolder.cast();
        }
        return super.getCapability(cap, side);
    }

    public abstract void func_73660_a();

    protected abstract int getHeat();

    public ActionResultType onBlockActivated(PlayerEntity player, Hand handIn, IFluidHandler handler) {
        ItemStack stack = player.func_184586_b(handIn);
        if (stack.func_190926_b()) {
            return ActionResultType.SUCCESS;
        }
        boolean result = FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)handIn, (IFluidHandler)handler);
        if (result) {
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
            this.func_70296_d();
            return ActionResultType.SUCCESS;
        }
        if (!this.tank.isEmpty() && !this.tank.getFluid().getFluid().func_207187_a(this.getMeltable().getFluid())) {
            return ActionResultType.SUCCESS;
        }
        ItemStack addStack = stack.func_77946_l();
        addStack.func_190920_e(1);
        ItemStack insertStack = this.inventory.insertItem(0, addStack, true);
        if (!ItemStack.func_77989_b((ItemStack)addStack, (ItemStack)insertStack)) {
            this.inventory.insertItem(0, addStack, false);
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            this.func_70296_d();
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.SUCCESS;
    }

    public ResourceLocation getSolidTexture() {
        if (!this.inventory.getStackInSlot(0).func_190926_b()) {
            return this.inventory.getStackInSlot(0).func_77973_b().getRegistryName();
        }
        if (!this.currentItem.func_190926_b()) {
            return this.currentItem.func_77973_b().getRegistryName();
        }
        return null;
    }

    public Fluid getFluid() {
        if (!this.tank.isEmpty()) {
            return this.tank.getFluid().getFluid();
        }
        return null;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        if (!this.inventory.getStackInSlot(0).func_190926_b()) {
            CompoundNBT blockNbt = this.inventory.getStackInSlot(0).func_77955_b(new CompoundNBT());
            nbt.func_218657_a("block", (INBT)blockNbt);
        }
        if (!this.currentItem.func_190926_b()) {
            CompoundNBT currentItemTag = this.currentItem.func_77955_b(new CompoundNBT());
            nbt.func_218657_a("currentItem", (INBT)currentItemTag);
        }
        if (!this.tank.isEmpty()) {
            CompoundNBT fluidNbt = this.tank.writeToNBT(new CompoundNBT());
            nbt.func_218657_a("fluid", (INBT)fluidNbt);
        }
        nbt.func_74768_a("solidAmount", this.solidAmount);
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        CompoundNBT nbt = packet.func_148857_g();
        this.currentItem = nbt.func_74764_b("currentItem") ? ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)nbt.func_74781_a("currentItem"))) : ItemStack.field_190927_a;
        if (nbt.func_74764_b("block")) {
            this.inventory.setStackInSlot(0, ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)nbt.func_74781_a("block"))));
        } else {
            this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
        }
        if (nbt.func_74764_b("fluid")) {
            this.tank.readFromNBT(nbt.func_74775_l("fluid"));
        } else {
            this.tank.setFluid(FluidStack.EMPTY);
        }
        this.solidAmount = nbt.func_74762_e("solidAmount");
    }

    public float getFluidProportion() {
        return (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity();
    }

    public float getSolidProportion() {
        int itemCount = this.inventory.getStackInSlot(0).func_190926_b() ? 0 : this.inventory.getStackInSlot(0).func_190916_E();
        float solidProportion = (float)itemCount / 4.0f;
        if (this.solidAmount > 0) {
            Meltable meltable = this.getMeltable();
            solidProportion += (float)this.solidAmount / (float)(4 * meltable.getAmount());
        }
        return solidProportion;
    }

    public abstract CrucilbeTypeEnum getCrucibleType();

    private Meltable getMeltable() {
        return ExNihiloRegistries.CRUCIBLE_REGISTRY.getMeltable((ForgeRegistryEntry<? extends IItemProvider>)this.currentItem.func_77973_b());
    }

    public int getFluidAmount() {
        return this.tank.getFluidAmount();
    }

    public abstract int getSolidAmount();
}

