/*
 * Decompiled with CFR 0.152.
 */
package com.novamachina.exnihilosequentia.common.tileentity.crucible;

import com.novamachina.exnihilosequentia.common.api.ExNihiloRegistries;
import com.novamachina.exnihilosequentia.common.tileentity.crucible.CrucilbeTypeEnum;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class MeltableItemHandler
extends ItemStackHandler {
    private boolean crucibleHasRoom = true;
    private CrucilbeTypeEnum type;

    public MeltableItemHandler(CrucilbeTypeEnum crucibleType) {
        super(1);
        this.type = crucibleType;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.crucibleHasRoom) {
            return super.insertItem(slot, stack, simulate);
        }
        return stack;
    }

    public void setCrucibleHasRoom(boolean crucibleHasRoom) {
        this.crucibleHasRoom = crucibleHasRoom;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return ExNihiloRegistries.CRUCIBLE_REGISTRY.isMeltable((ForgeRegistryEntry<? extends IItemProvider>)stack.func_77973_b(), this.type.getLevel());
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return 4;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = super.serializeNBT();
        nbt.func_74757_a("hasRoom", this.crucibleHasRoom);
        nbt.func_74778_a("type", this.type.getName());
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        this.crucibleHasRoom = nbt.func_74767_n("hasRoom");
        this.type = CrucilbeTypeEnum.getTypeByName(nbt.func_74779_i("type"));
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.field_190927_a;
    }
}

