/*
 * Decompiled with CFR 0.152.
 */
package com.novamachina.exnihilosequentia.common.tileentity.sieve;

import com.novamachina.exnihilosequentia.common.api.ExNihiloRegistries;
import com.novamachina.exnihilosequentia.common.block.BlockSieve;
import com.novamachina.exnihilosequentia.common.init.ModTiles;
import com.novamachina.exnihilosequentia.common.item.mesh.EnumMesh;
import com.novamachina.exnihilosequentia.common.item.mesh.MeshItem;
import com.novamachina.exnihilosequentia.common.registries.sieve.SieveDropEntry;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class SieveTile
extends TileEntity {
    private ItemStack meshStack = ItemStack.field_190927_a;
    private ItemStack blockStack = ItemStack.field_190927_a;
    private EnumMesh meshType = EnumMesh.NONE;
    private float progress = 0.0f;

    public SieveTile() {
        super((TileEntityType)ModTiles.SIEVE.get());
    }

    public void insertMesh(ItemStack stack) {
        EnumMesh mesh = ((MeshItem)stack.func_77973_b()).getMesh();
        if (this.meshStack.func_190926_b()) {
            this.meshStack = stack.func_77946_l();
            this.meshStack.func_190920_e(1);
            stack.func_190918_g(1);
            this.meshType = mesh;
            if (!this.func_145837_r()) {
                this.setSieveState();
            }
            this.func_70296_d();
        }
    }

    public void removeMesh(boolean rerenderSieve) {
        if (!this.meshStack.func_190926_b()) {
            this.field_145850_b.func_217376_c((Entity)new ItemEntity(this.field_145850_b, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), this.meshStack.func_77946_l()));
            this.meshStack = ItemStack.field_190927_a;
            this.meshType = EnumMesh.NONE;
            if (rerenderSieve) {
                this.setSieveState();
            }
        }
    }

    private void setSieveState() {
        BlockState state = this.func_195044_w();
        if (state.func_177230_c() instanceof BlockSieve) {
            this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)state.func_206870_a(BlockSieve.MESH, (Comparable)((Object)this.meshType)));
        }
    }

    public void func_145839_a(CompoundNBT compound) {
        if (compound.func_74764_b("mesh")) {
            this.meshStack = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)compound.func_74781_a("mesh")));
            if (this.meshStack.func_77973_b() instanceof MeshItem) {
                this.meshType = ((MeshItem)this.meshStack.func_77973_b()).getMesh();
            }
        } else {
            this.meshStack = ItemStack.field_190927_a;
        }
        this.blockStack = compound.func_74764_b("block") ? ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)compound.func_74781_a("block"))) : ItemStack.field_190927_a;
        this.progress = compound.func_74760_g("progress");
        super.func_145839_a(compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (!this.meshStack.func_190926_b()) {
            CompoundNBT meshNBT = this.meshStack.func_77955_b(new CompoundNBT());
            compound.func_218657_a("mesh", (INBT)meshNBT);
        }
        if (!this.blockStack.func_190926_b()) {
            CompoundNBT blockNBT = this.blockStack.func_77955_b(new CompoundNBT());
            compound.func_218657_a("block", (INBT)blockNBT);
        }
        compound.func_74776_a("progress", this.progress);
        return super.func_189515_b(compound);
    }

    public void func_145843_s() {
        if (!this.field_145850_b.func_201670_d()) {
            this.removeMesh(false);
        }
        super.func_145843_s();
    }

    public void insertSiftableBlock(ItemStack stack) {
        if (!this.meshStack.func_190926_b() && this.blockStack.func_190926_b()) {
            this.blockStack = stack.func_77946_l();
            this.blockStack.func_190920_e(1);
            stack.func_190918_g(1);
        }
    }

    public void activateSieve(boolean isWaterlogged) {
        if (this.isReadyToSieve()) {
            this.progress += 0.1f;
            if (this.progress >= 1.0f) {
                List<SieveDropEntry> drops = ExNihiloRegistries.SIEVE_REGISTRY.getDrops(((BlockItem)this.blockStack.func_77973_b()).func_179223_d(), this.meshType, isWaterlogged);
                Random random = new Random();
                drops.forEach(entry -> {
                    if (random.nextFloat() <= entry.getRarity()) {
                        Item item = (Item)ForgeRegistries.ITEMS.getValue(entry.getResult());
                        this.field_145850_b.func_217376_c((Entity)new ItemEntity(this.field_145850_b, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), new ItemStack((IItemProvider)item)));
                    }
                });
                this.resetSieve();
            }
        }
    }

    private void resetSieve() {
        this.blockStack = ItemStack.field_190927_a;
        this.progress = 0.0f;
    }

    public boolean isReadyToSieve() {
        return !this.meshStack.func_190926_b() && !this.blockStack.func_190926_b();
    }

    public ResourceLocation getTexture() {
        if (!this.blockStack.func_190926_b()) {
            return this.blockStack.func_77973_b().getRegistryName();
        }
        return null;
    }

    public ItemStack getBlockStack() {
        return this.blockStack;
    }

    public float getProgress() {
        return this.progress;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        if (!this.meshStack.func_190926_b()) {
            CompoundNBT meshNBT = this.meshStack.func_77955_b(new CompoundNBT());
            nbt.func_218657_a("mesh", (INBT)meshNBT);
        }
        if (!this.blockStack.func_190926_b()) {
            CompoundNBT blockNbt = this.blockStack.func_77955_b(new CompoundNBT());
            nbt.func_218657_a("block", (INBT)blockNbt);
        }
        nbt.func_74776_a("progress", this.progress);
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        CompoundNBT nbt = packet.func_148857_g();
        if (nbt.func_74764_b("mesh")) {
            this.meshStack = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)nbt.func_74781_a("mesh")));
            if (this.meshStack.func_77973_b() instanceof MeshItem) {
                this.meshType = ((MeshItem)this.meshStack.func_77973_b()).getMesh();
            }
        } else {
            this.meshStack = ItemStack.field_190927_a;
        }
        this.blockStack = nbt.func_74764_b("block") ? ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)nbt.func_74781_a("block"))) : ItemStack.field_190927_a;
        this.progress = nbt.func_74760_g("progress");
    }

    public EnumMesh getMesh() {
        return this.meshType;
    }
}

