/*
 * Decompiled with CFR 0.152.
 */
package com.novamachina.exnihilosequentia.common.utility;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class TagUtils {
    public static Collection<ResourceLocation> getTags(Item item) {
        Collection tags = ItemTags.func_199903_a().func_199913_a((Object)item);
        return tags;
    }

    public static Collection<ResourceLocation> getTags(Block block) {
        Collection tags = BlockTags.func_199896_a().func_199913_a((Object)block);
        return tags;
    }

    public static Collection<ResourceLocation> getTags(IItemProvider item) {
        Collection<ResourceLocation> tags = null;
        try {
            tags = TagUtils.getTags((Item)item);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        try {
            if (tags != null) {
                tags.addAll(TagUtils.getTags((Block)item));
            } else {
                tags = TagUtils.getTags((Block)item);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return tags;
    }

    public static Collection<ResourceLocation> getTags(ResourceLocation id) {
        Collection<ResourceLocation> tags = null;
        if (ForgeRegistries.BLOCKS.containsKey(id)) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(id);
            tags = TagUtils.getTags(block);
        }
        if (ForgeRegistries.ITEMS.containsKey(id)) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
            if (tags != null) {
                tags.addAll(TagUtils.getTags(item));
            } else {
                tags = TagUtils.getTags(item);
            }
        }
        return tags;
    }

    public static List<ResourceLocation> getTagsOwnedBy(ResourceLocation owningTag) {
        Tag blockTag = BlockTags.func_199896_a().func_199910_a(owningTag);
        Tag itemTag = ItemTags.func_199903_a().func_199910_a(owningTag);
        Collection blockCollection = null;
        Collection itemCollection = null;
        if (blockTag != null) {
            blockCollection = blockTag.func_199885_a();
        }
        if (itemTag != null) {
            itemCollection = itemTag.func_199885_a();
        }
        ArrayList<ResourceLocation> idList = new ArrayList<ResourceLocation>();
        if (blockCollection != null) {
            for (Block block : blockCollection) {
                idList.add(block.getRegistryName());
            }
        }
        if (itemCollection != null) {
            for (Item item : itemCollection) {
                if (idList.contains(item.getRegistryName())) continue;
                idList.add(item.getRegistryName());
            }
        }
        return idList;
    }

    public static boolean isTag(ResourceLocation tag) {
        return ItemTags.func_199903_a().func_199910_a(tag) != null || BlockTags.func_199896_a().func_199910_a(tag) != null;
    }
}

