/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.api;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import novamachina.exnihilosequentia.common.item.ore.EnumOre;

public class ExNihiloTags {
    public static final ITag.INamedTag<Item> CLAY = ExNihiloTags.createItemWrapper(ExNihiloTags.forgeLoc("clay"));
    public static final ITag.INamedTag<Item> HAMMER = ExNihiloTags.createItemWrapper(ExNihiloTags.modLoc("hammer"));
    public static final ITag.INamedTag<Item> CROOK = ExNihiloTags.createItemWrapper(ExNihiloTags.modLoc("crook"));
    public static final ITag.INamedTag<Item> MEAT_COOKED = ExNihiloTags.createItemWrapper(ExNihiloTags.forgeLoc("meat_cooked"));
    public static final ITag.INamedTag<Item> MEAT_UNCOOKED = ExNihiloTags.createItemWrapper(ExNihiloTags.forgeLoc("meat_uncooked"));
    public static final ITag.INamedTag<Item> CRUCIBLE = ExNihiloTags.createItemWrapper(ExNihiloTags.modLoc("crucibles"));
    public static final ITag.INamedTag<Item> BARREL = ExNihiloTags.createItemWrapper(ExNihiloTags.modLoc("barrels"));
    public static final ITag.INamedTag<Item> SIEVE = ExNihiloTags.createItemWrapper(ExNihiloTags.modLoc("sieves"));
    private static final Map<EnumOre, OreTag> ores = new EnumMap<EnumOre, OreTag>(EnumOre.class);

    private ExNihiloTags() {
    }

    public static ITag.INamedTag<Item> createItemWrapper(ResourceLocation name) {
        return ExNihiloTags.createWrapperTag(ItemTags.func_242177_b(), name, ItemTags::func_199901_a);
    }

    public static ResourceLocation getIngot(String ingot) {
        return ExNihiloTags.forgeLoc("ingots/" + ingot);
    }

    public static ResourceLocation getOre(String ore) {
        return ExNihiloTags.forgeLoc("ores/" + ore);
    }

    public static OreTag getOreTags(EnumOre ore) {
        return ores.get((Object)ore);
    }

    private static <T> ITag.INamedTag<T> createWrapperTag(List<? extends ITag.INamedTag<T>> allExisting, ResourceLocation name, Function<String, ITag.INamedTag<T>> createNew) {
        Optional<ITag.INamedTag> existing = allExisting.stream().filter(tag -> tag.func_230234_a_().equals((Object)name)).findAny();
        if (existing.isPresent()) {
            return existing.get();
        }
        return createNew.apply(name.toString());
    }

    private static ResourceLocation forgeLoc(String path) {
        return new ResourceLocation("forge", path);
    }

    private static ResourceLocation modLoc(String path) {
        return new ResourceLocation("exnihilosequentia", path);
    }

    static {
        for (EnumOre ore : EnumOre.values()) {
            ores.put(ore, new OreTag(ore));
        }
    }

    public static class OreTag {
        private final ITag.INamedTag<Item> ingot;
        private final ITag.INamedTag<Item> ore;

        public OreTag(EnumOre ore) {
            this.ingot = ExNihiloTags.createItemWrapper(ExNihiloTags.getIngot(ore.getOreName()));
            this.ore = ExNihiloTags.createItemWrapper(ExNihiloTags.getOre(ore.getOreName()));
        }

        public ITag.INamedTag<Item> getIngotTag() {
            return this.ingot;
        }

        public ITag.INamedTag<Item> getOreTag() {
            return this.ore;
        }
    }
}

