/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.api.crafting.sieve;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import novamachina.exnihilosequentia.api.crafting.RecipeSerializer;
import novamachina.exnihilosequentia.api.crafting.SerializableRecipe;
import novamachina.exnihilosequentia.api.crafting.sieve.MeshWithChance;
import novamachina.exnihilosequentia.common.item.mesh.EnumMesh;

public class SieveRecipe
extends SerializableRecipe {
    public static final IRecipeType<SieveRecipe> RECIPE_TYPE = IRecipeType.func_222147_a((String)"exnihilosequentia:sieve");
    private static RegistryObject<RecipeSerializer<SieveRecipe>> serializer;
    private ItemStack drop;
    private Ingredient input;
    private boolean isWaterlogged;
    private final ResourceLocation recipeId;
    private final List<MeshWithChance> rolls;

    public SieveRecipe(ResourceLocation id, Ingredient input, ItemStack drop, List<MeshWithChance> rolls, boolean isWaterlogged) {
        super(drop, RECIPE_TYPE, id);
        this.recipeId = id;
        this.input = input;
        this.drop = drop;
        this.rolls = rolls;
        this.isWaterlogged = isWaterlogged;
    }

    public static RegistryObject<RecipeSerializer<SieveRecipe>> getStaticSerializer() {
        return serializer;
    }

    public static void setSerializer(RegistryObject<RecipeSerializer<SieveRecipe>> serializer) {
        SieveRecipe.serializer = serializer;
    }

    public void addRoll(String meshString, float chance) {
        EnumMesh mesh = EnumMesh.getMeshFromName(meshString);
        this.addRoll(mesh, chance);
    }

    public void addRoll(EnumMesh mesh, float chance) {
        this.rolls.add(new MeshWithChance(mesh, chance));
    }

    public SieveRecipe filterByMesh(EnumMesh meshType, boolean flattenRecipes) {
        ArrayList<MeshWithChance> possibleMeshes = new ArrayList<MeshWithChance>();
        for (MeshWithChance mesh : this.rolls) {
            if (flattenRecipes) {
                if (mesh.getMesh().getId() > meshType.getId()) continue;
                possibleMeshes.add(mesh);
                continue;
            }
            if (mesh.getMesh().getId() != meshType.getId()) continue;
            possibleMeshes.add(mesh);
        }
        return new SieveRecipe(this.recipeId, this.input, this.drop, possibleMeshes, this.isWaterlogged);
    }

    public ItemStack getDrop() {
        return this.drop.func_77946_l();
    }

    public void setDrop(ItemStack drop) {
        this.drop = drop;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public void setInput(Ingredient input) {
        this.input = input;
    }

    public ResourceLocation getRecipeId() {
        return this.recipeId;
    }

    public ItemStack func_77571_b() {
        return this.drop.func_77946_l();
    }

    public List<MeshWithChance> getRolls() {
        return this.rolls;
    }

    public boolean isWaterlogged() {
        return this.isWaterlogged;
    }

    public void setWaterlogged() {
        this.isWaterlogged = true;
    }

    public String toString() {
        return "SieveRecipe{input=" + this.input + ", drop=" + this.drop + ", rolls=" + this.rolls + ", isWaterlogged=" + this.isWaterlogged + ", recipeId=" + this.recipeId + '}';
    }

    protected RecipeSerializer<SieveRecipe> getENSerializer() {
        return (RecipeSerializer)serializer.get();
    }
}

