/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.api.datagen;

import net.minecraft.block.Block;
import net.minecraft.block.CakeBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.fluid.Fluid;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import novamachina.exnihilosequentia.common.block.BlockSieve;
import novamachina.exnihilosequentia.common.item.mesh.EnumMesh;

public abstract class AbstractBlockStateGenerator
extends BlockStateProvider {
    protected static final String PARTICLE_TAG = "particle";

    protected AbstractBlockStateGenerator(DataGenerator gen, String modId, ExistingFileHelper exFileHelper) {
        super(gen, modId, exFileHelper);
    }

    protected ResourceLocation exnihiloLoc(String string) {
        return new ResourceLocation("exnihilosequentia", string);
    }

    protected void basicBlock(Block block) {
        this.simpleItemBlock(block, this.cubeAll(block));
    }

    protected void registerFluid(Fluid fluid) {
        ResourceLocation stillTexture = fluid.getAttributes().getStillTexture();
        ModelBuilder model = ((BlockModelBuilder)this.models().getBuilder("block/" + fluid.getRegistryName().func_110623_a())).texture(PARTICLE_TAG, stillTexture);
        this.getVariantBuilder(fluid.func_207188_f().func_206883_i().func_177230_c()).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
    }

    protected void simpleItemBlock(Block block, ModelFile modelFile) {
        this.simpleBlock(block, modelFile);
        this.simpleBlockItem(block, modelFile);
    }

    protected String getRegistryName(Block b) {
        return b.getRegistryName().toString();
    }

    protected void createBarrel(Block block, ResourceLocation texture) {
        ConfiguredModel model = new ConfiguredModel((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getRegistryName(block), this.exnihiloLoc("block/barrel"))).texture("texture", texture)).texture(PARTICLE_TAG, texture));
        this.simpleItemBlock(block, model.model);
    }

    protected void createCake(Block block) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        for (int i = 1; i < 7; ++i) {
            VariantBlockStateBuilder.PartialBlockstate partialBlockstate = builder.partialState();
            ConfiguredModel model = new ConfiguredModel((ModelFile)this.models().getExistingFile(this.exnihiloLoc("block/cake_slice" + i)));
            partialBlockstate.with((Property)CakeBlock.field_176589_a, (Comparable)Integer.valueOf(i)).addModels(new ConfiguredModel[]{model});
        }
        VariantBlockStateBuilder.PartialBlockstate partialBlockstate = builder.partialState();
        ConfiguredModel model = new ConfiguredModel((ModelFile)this.models().getExistingFile(this.exnihiloLoc("block/cake_uneaten")));
        partialBlockstate.with((Property)CakeBlock.field_176589_a, (Comparable)Integer.valueOf(0)).addModels(new ConfiguredModel[]{model});
    }

    protected void createCrucible(Block block, ResourceLocation texture) {
        ConfiguredModel model = new ConfiguredModel((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getRegistryName(block), this.exnihiloLoc("block/crucible"))).texture(PARTICLE_TAG, texture)).texture("top", texture)).texture("bottom", texture)).texture("side", texture)).texture("inside", texture));
        this.simpleItemBlock(block, model.model);
    }

    protected void createSieve(Block block, ResourceLocation texture) {
        ConfiguredModel model = new ConfiguredModel((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getRegistryName(block), this.exnihiloLoc("block/sieve_base"))).texture("texture", texture)).texture(PARTICLE_TAG, texture));
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(block);
        MultiPartBlockStateBuilder.PartBuilder partBuilder = (MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(model.model).addModel();
        partBuilder.end();
        for (EnumMesh mesh : EnumMesh.values()) {
            if (mesh == EnumMesh.NONE) continue;
            partBuilder = (MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)new ModelFile.ExistingModelFile(this.exnihiloLoc("block/" + mesh.getMeshName()), this.models().existingFileHelper)).addModel();
            partBuilder.condition(BlockSieve.MESH, (Comparable[])new EnumMesh[]{mesh});
            partBuilder.end();
        }
        this.simpleBlockItem(block, model.model);
    }
}

