/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.api.datagen;

import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.conditions.SurvivesExplosion;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import org.apache.logging.log4j.LogManager;

public abstract class AbstractLootTableGenerator
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogManager.getLogger());
    protected final Map<ResourceLocation, LootTable> lootTables = new HashMap<ResourceLocation, LootTable>();
    private final DataGenerator generator;
    private final String modId;

    protected AbstractLootTableGenerator(DataGenerator generator, String modId) {
        this.generator = generator;
        this.modId = modId;
    }

    public void func_200398_a(DirectoryCache cache) {
        this.lootTables.clear();
        Path outFolder = this.generator.func_200391_b();
        this.createLootTables();
        ValidationTracker validator = new ValidationTracker(LootParameterSets.field_216266_g, function -> null, this.lootTables::get);
        this.lootTables.forEach((name, table) -> LootTableManager.func_227508_a_((ValidationTracker)validator, (ResourceLocation)name, (LootTable)table));
        Multimap problems = validator.func_227527_a_();
        if (!problems.isEmpty()) {
            problems.forEach((name, table) -> logger.warn("Found validation problem in " + name + ": " + table));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        this.lootTables.forEach((name, table) -> {
            Path out = this.getPath(outFolder, (ResourceLocation)name);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)table), (Path)out);
            }
            catch (IOException e) {
                logger.error("Couldn't save loot table " + out);
                logger.error(Arrays.toString(e.getStackTrace()));
            }
        });
    }

    public String func_200397_b() {
        return "Loot Tables: " + this.modId;
    }

    protected LootPool.Builder createLootPoolBuilder() {
        return LootPool.func_216096_a().func_212840_b_(SurvivesExplosion.func_215968_b());
    }

    protected abstract void createLootTables();

    protected void register(Block block, LootPool.Builder ... pools) {
        LootTable.Builder builder = LootTable.func_216119_b();
        for (LootPool.Builder pool : pools) {
            builder.func_216040_a(pool);
        }
        this.register(block, builder);
    }

    protected void registerSelfDrop(Block block) {
        this.register(block, this.singleItem((IItemProvider)block));
    }

    private Path getPath(Path outFolder, ResourceLocation name) {
        return outFolder.resolve("data/" + name.func_110624_b() + "/loot_tables/" + name.func_110623_a() + ".json");
    }

    private void register(Block block, LootTable.Builder table) {
        this.register(block.getRegistryName(), table);
    }

    private void register(ResourceLocation registryName, LootTable.Builder table) {
        if (this.lootTables.put(this.toTableLoc(registryName), table.func_216039_a(LootParameterSets.field_216267_h).func_216038_b()) != null) {
            throw new IllegalStateException("Duplicate loot table: " + table);
        }
    }

    private LootPool.Builder singleItem(IItemProvider in) {
        return this.createLootPoolBuilder().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)in));
    }

    private ResourceLocation toTableLoc(ResourceLocation registryName) {
        return new ResourceLocation(registryName.func_110624_b(), "blocks/" + registryName.func_110623_a());
    }
}

