/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.api.datagen;

import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.ComposterBlock;
import net.minecraft.data.CookingRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.CookingRecipeSerializer;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.RegistryObject;
import novamachina.exnihilosequentia.api.crafting.compost.CompostRecipeBuilder;
import novamachina.exnihilosequentia.api.crafting.crook.CrookRecipeBuilder;
import novamachina.exnihilosequentia.api.crafting.crucible.CrucibleRecipeBuilder;
import novamachina.exnihilosequentia.api.crafting.fluiditem.FluidItemRecipeBuilder;
import novamachina.exnihilosequentia.api.crafting.fluidontop.FluidOnTopRecipeBuilder;
import novamachina.exnihilosequentia.api.crafting.fluidtransform.FluidTransformRecipeBuilder;
import novamachina.exnihilosequentia.api.crafting.hammer.HammerRecipeBuilder;
import novamachina.exnihilosequentia.api.crafting.heat.HeatRecipeBuilder;
import novamachina.exnihilosequentia.common.block.BaseBlock;
import novamachina.exnihilosequentia.common.block.BlockSieve;
import novamachina.exnihilosequentia.common.item.ore.EnumOre;
import novamachina.exnihilosequentia.common.tileentity.crucible.CrucilbeTypeEnum;

public abstract class AbstractRecipeGenerator
extends RecipeProvider {
    protected static final String CHUNK_CONDITION = "has_chunk";
    public static final String PEBBLE_CONDITION = "has_pebble";
    private static final String MATERIAL_CONDITION = "has_material";
    private final String modId;

    protected AbstractRecipeGenerator(DataGenerator generator, String modId) {
        super(generator);
        this.modId = modId;
    }

    @Nonnull
    public String func_200397_b() {
        return "Recipes: " + this.modId;
    }

    protected ResourceLocation compostLoc(String id) {
        return new ResourceLocation(this.modId, "compost/" + this.prependRecipePrefix(id));
    }

    protected ResourceLocation crookLoc(String id) {
        return new ResourceLocation(this.modId, "crook/" + this.prependRecipePrefix(id));
    }

    protected ResourceLocation crucibleLoc(String id) {
        return new ResourceLocation(this.modId, "crucible/" + this.prependRecipePrefix(id));
    }

    protected ResourceLocation fluidItemLoc(String id) {
        return new ResourceLocation(this.modId, "fluid_item/" + this.prependRecipePrefix(id));
    }

    protected ResourceLocation fluidOnTopLoc(String id) {
        return new ResourceLocation(this.modId, "fluid_on_top/" + this.prependRecipePrefix(id));
    }

    protected ResourceLocation fluidTransformLoc(String id) {
        return new ResourceLocation(this.modId, "fluid_transform/" + this.prependRecipePrefix(id));
    }

    protected ResourceLocation hammerLoc(String id) {
        return new ResourceLocation(this.modId, "hammer/" + this.prependRecipePrefix(id));
    }

    protected ResourceLocation heatLoc(String id) {
        return new ResourceLocation(this.modId, "heat/" + this.prependRecipePrefix(id));
    }

    protected ResourceLocation sieveLoc(String id) {
        return new ResourceLocation(this.modId, "sieve/" + this.prependRecipePrefix(id));
    }

    protected void registerOre(EnumOre ore, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)ore.getChunkItem().get())).func_200472_a("xx").func_200472_a("xx").func_200462_a(Character.valueOf('x'), (IItemProvider)ore.getPieceItem().get()).func_200473_b(this.modId).func_200465_a("has_piece", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ore.getPieceItem().get()})).func_200467_a(consumer, new ResourceLocation(this.modId, this.prependRecipePrefix(ore.getChunkName())));
    }

    protected void registerSmelting(EnumOre ore, Consumer<IFinishedRecipe> consumer) {
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ore.getChunkItem().get()}), (IItemProvider)(ore.getIngotItem() != null ? ore.getIngotItem() : (IItemProvider)ore.getIngotRegistryItem().get()), (float)0.7f, (int)200).func_218628_a(CHUNK_CONDITION, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ore.getChunkItem().get()})).func_218635_a(consumer, new ResourceLocation(this.modId, this.prependRecipePrefix(ore.getIngotName())));
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ore.getChunkItem().get()}), (IItemProvider)(ore.getIngotItem() != null ? ore.getIngotItem() : (IItemProvider)ore.getIngotRegistryItem().get()), (float)0.7f, (int)100).func_218628_a(CHUNK_CONDITION, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ore.getChunkItem().get()})).func_218635_a(consumer, new ResourceLocation(this.modId, this.prependRecipePrefix("blast_" + ore.getIngotName())));
    }

    protected String prependRecipePrefix(String id) {
        return "ens_" + id;
    }

    protected ResourceLocation createSaveLocation(ResourceLocation location) {
        return new ResourceLocation(location.func_110624_b(), this.prependRecipePrefix(location.func_110623_a()));
    }

    public static void createMCCompost(IItemProvider item, float chance) {
        ComposterBlock.field_220299_b.put((Object)item, chance);
    }

    protected void createCompostRecipe(Consumer<IFinishedRecipe> consumer, Item item, int amount, String string) {
        CompostRecipeBuilder.builder().input((IItemProvider)item).amount(amount).build(consumer, this.compostLoc(string));
    }

    protected void createCompostRecipe(Consumer<IFinishedRecipe> consumer, Block block, int amount, String string) {
        CompostRecipeBuilder.builder().input((IItemProvider)block).amount(amount).build(consumer, this.compostLoc(string));
    }

    protected void createCompostRecipe(Consumer<IFinishedRecipe> consumer, ITag.INamedTag<Item> item, int amount, String string) {
        CompostRecipeBuilder.builder().input(item).amount(amount).build(consumer, this.compostLoc(string));
    }

    protected void createCrookRecipes(Consumer<IFinishedRecipe> consumer, ITag.INamedTag<Item> itemInput, IItemProvider itemDrop, float chance, String id) {
        CrookRecipeBuilder.builder().input(itemInput).addDrop(itemDrop, chance).build(consumer, this.crookLoc(id));
    }

    protected void createCrookRecipes(Consumer<IFinishedRecipe> consumer, Block itemInput, IItemProvider itemDrop, float chance, String id) {
        CrookRecipeBuilder.builder().input(itemInput).addDrop(itemDrop, chance).build(consumer, this.crookLoc(id));
    }

    protected void createFiredCrucibleRecipes(Consumer<IFinishedRecipe> consumer, Block block, int amount, String id) {
        CrucibleRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{block})).amount(amount).fluidResult((Fluid)Fluids.field_204547_b).crucibleType(CrucilbeTypeEnum.FIRED).build(consumer, this.crucibleLoc(id));
    }

    protected void createFiredCrucibleRecipes(Consumer<IFinishedRecipe> consumer, ITag.INamedTag<Item> item, int amount, String id) {
        CrucibleRecipeBuilder.builder().input(Ingredient.func_199805_a(item)).amount(amount).fluidResult((Fluid)Fluids.field_204547_b).crucibleType(CrucilbeTypeEnum.FIRED).build(consumer, this.crucibleLoc(id));
    }

    protected void createWaterCrucibleRecipes(Consumer<IFinishedRecipe> consumer, ITag.INamedTag<Item> item, int amount, String id) {
        CrucibleRecipeBuilder.builder().input(Ingredient.func_199805_a(item)).amount(amount).fluidResult((Fluid)Fluids.field_204546_a).crucibleType(CrucilbeTypeEnum.WOOD).build(consumer, this.crucibleLoc(id));
    }

    protected void createWaterCrucibleRecipes(Consumer<IFinishedRecipe> consumer, Item item, int amount, String id) {
        CrucibleRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item})).amount(amount).fluidResult((Fluid)Fluids.field_204546_a).crucibleType(CrucilbeTypeEnum.WOOD).build(consumer, this.crucibleLoc(id));
    }

    protected void createFluidItemRecipes(Consumer<IFinishedRecipe> consumer, Fluid fluidInput, Item itemInput, Block blockOutput, String id) {
        FluidItemRecipeBuilder.builder().fluidInBarrel(fluidInput).input((IItemProvider)itemInput).result((IItemProvider)blockOutput).build(consumer, this.fluidItemLoc(id));
    }

    protected void createFluidItemRecipes(Consumer<IFinishedRecipe> consumer, Fluid fluidInput, Tags.IOptionalNamedTag<Item> itemInput, Block blockOutput, String id) {
        FluidItemRecipeBuilder.builder().fluidInBarrel(fluidInput).input(itemInput).result((IItemProvider)blockOutput).build(consumer, this.fluidItemLoc(id));
    }

    protected void createFluidOnTopRecipes(Consumer<IFinishedRecipe> consumer, Fluid fluidInTank, Fluid fluidOnTop, Block blockOutput, String id) {
        FluidOnTopRecipeBuilder.builder().fluidInTank(fluidInTank).fluidOnTop(fluidOnTop).result((IItemProvider)blockOutput).build(consumer, this.fluidOnTopLoc(id));
    }

    protected void createFluidTransformRecipes(Consumer<IFinishedRecipe> consumer, Fluid fluidInTank, ITag.INamedTag<Item> catalyst, Fluid fluidResult, String id) {
        FluidTransformRecipeBuilder.builder().fluidInTank(fluidInTank).catalyst(Ingredient.func_199805_a(catalyst)).result(fluidResult).build(consumer, this.fluidTransformLoc(id));
    }

    protected void createFluidTransformRecipes(Consumer<IFinishedRecipe> consumer, Fluid fluidInTank, Item catalyst, Fluid fluidResult, String id) {
        FluidTransformRecipeBuilder.builder().fluidInTank(fluidInTank).catalyst(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{catalyst})).result(fluidResult).build(consumer, this.fluidTransformLoc(id));
    }

    protected void createHammerRecipes(Consumer<IFinishedRecipe> consumer, Block blockInput, Block blockOutput, String id) {
        HammerRecipeBuilder.builder().input((IItemProvider)blockInput).addDrop((IItemProvider)blockOutput).build(consumer, this.hammerLoc(id));
    }

    protected void createHeatRecipes(Consumer<IFinishedRecipe> consumer, Block block, int amount, String id) {
        HeatRecipeBuilder.builder().input(block).amount(amount).build(consumer, this.heatLoc(id));
    }

    protected void createHeatRecipes(Consumer<IFinishedRecipe> consumer, Block block, int amount, StatePropertiesPredicate properties, String id) {
        HeatRecipeBuilder.builder().input(block).amount(amount).properties(properties).build(consumer, this.heatLoc(id));
    }

    protected void createSmeltingRecipe(Consumer<IFinishedRecipe> consumer, Item input, Item output, float xpSmelt, int durationSmelt, float xpBlast, int durationBlast, String condition, ResourceLocation rl) {
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input}), (IItemProvider)output, (float)xpSmelt, (int)durationSmelt).func_218628_a(condition, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{input})).func_218635_a(consumer, this.createSaveLocation(rl));
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input}), (IItemProvider)output, (float)xpBlast, (int)durationBlast).func_218628_a(condition, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{input})).func_218635_a(consumer, this.createSaveLocation(new ResourceLocation(rl.toString() + "_blast")));
    }

    protected void createCookingRecipe(Consumer<IFinishedRecipe> consumer, Item input, Item output, float xpCampfire, int durationCampfire, float xpSmoker, int durationSmoker, String condition, ResourceLocation rl) {
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input}), (IItemProvider)output, (float)xpCampfire, (int)durationCampfire, (CookingRecipeSerializer)IRecipeSerializer.field_222174_r).func_218628_a(condition, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{input})).func_218635_a(consumer, this.createSaveLocation(new ResourceLocation(rl.toString() + "_from_campfire")));
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input}), (IItemProvider)output, (float)xpSmoker, (int)durationSmoker, (CookingRecipeSerializer)IRecipeSerializer.field_222173_q).func_218628_a(condition, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{input})).func_218635_a(consumer, this.createSaveLocation(new ResourceLocation(rl.toString() + "_from_smoker")));
    }

    protected void createBarrel(Consumer<IFinishedRecipe> consumer, RegistryObject<BaseBlock> barrel, Tags.IOptionalNamedTag<Item> block, Item slab) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)barrel.get())).func_200472_a("x x").func_200472_a("x x").func_200472_a("x-x").func_200469_a(Character.valueOf('x'), block).func_200462_a(Character.valueOf('-'), (IItemProvider)slab).func_200473_b("exnihilosequentia").func_200465_a("has_walls", (ICriterionInstance)AbstractRecipeGenerator.func_200409_a(block)).func_200465_a("has_base", (ICriterionInstance)AbstractRecipeGenerator.func_200403_a((IItemProvider)slab)).func_200467_a(consumer, this.createSaveLocation(barrel.getId()));
    }

    protected void createBarrel(Consumer<IFinishedRecipe> consumer, RegistryObject<BaseBlock> barrel, Item block, Item slab) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)barrel.get())).func_200472_a("x x").func_200472_a("x x").func_200472_a("x-x").func_200462_a(Character.valueOf('x'), (IItemProvider)block).func_200462_a(Character.valueOf('-'), (IItemProvider)slab).func_200473_b("exnihilosequentia").func_200465_a("has_walls", (ICriterionInstance)AbstractRecipeGenerator.func_200403_a((IItemProvider)block)).func_200465_a("has_base", (ICriterionInstance)AbstractRecipeGenerator.func_200403_a((IItemProvider)slab)).func_200467_a(consumer, this.createSaveLocation(barrel.getId()));
    }

    protected void createCrucible(Consumer<IFinishedRecipe> consumer, RegistryObject<BaseBlock> crucible, Item block, Item slab) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)crucible.get())).func_200472_a("c c").func_200472_a("clc").func_200472_a("s s").func_200462_a(Character.valueOf('c'), (IItemProvider)block).func_200462_a(Character.valueOf('l'), (IItemProvider)slab).func_200469_a(Character.valueOf('s'), (ITag)Tags.Items.RODS_WOODEN).func_200473_b("exnihilosequentia").func_200465_a("has_logs", (ICriterionInstance)AbstractRecipeGenerator.func_200403_a((IItemProvider)block)).func_200467_a(consumer, this.createSaveLocation(crucible.getId()));
    }

    protected void createCrucible(Consumer<IFinishedRecipe> consumer, RegistryObject<BaseBlock> crucible, ITag.INamedTag<Item> block, ITag.INamedTag<Item> slab) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)crucible.get())).func_200472_a("c c").func_200472_a("clc").func_200472_a("s s").func_200469_a(Character.valueOf('c'), block).func_200469_a(Character.valueOf('l'), slab).func_200469_a(Character.valueOf('s'), (ITag)Tags.Items.RODS_WOODEN).func_200473_b("exnihilosequentia").func_200465_a("has_logs", (ICriterionInstance)AbstractRecipeGenerator.func_200409_a(block)).func_200467_a(consumer, this.createSaveLocation(crucible.getId()));
    }

    protected void createSieve(Consumer<IFinishedRecipe> consumer, RegistryObject<?> sieve, Item block, Item slab) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((BlockSieve)sieve.get())).func_200472_a("p p").func_200472_a("plp").func_200472_a("s s").func_200462_a(Character.valueOf('p'), (IItemProvider)block).func_200462_a(Character.valueOf('l'), (IItemProvider)slab).func_200469_a(Character.valueOf('s'), (ITag)Tags.Items.RODS_WOODEN).func_200465_a("has_plank", (ICriterionInstance)AbstractRecipeGenerator.func_200403_a((IItemProvider)block)).func_200467_a(consumer, this.createSaveLocation(sieve.getId()));
    }

    protected void createCrook(Item result, Item input, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)result).func_200472_a("xx").func_200472_a(" x").func_200472_a(" x").func_200462_a(Character.valueOf('x'), (IItemProvider)input).func_200473_b("exnihilosequentia").func_200465_a(PEBBLE_CONDITION, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{input})).func_200467_a(consumer, this.createSaveLocation(Objects.requireNonNull(result.getRegistryName())));
    }

    protected void createCrook(Item result, ITag.INamedTag<Item> input, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)result).func_200472_a("xx").func_200472_a(" x").func_200472_a(" x").func_200469_a(Character.valueOf('x'), input).func_200473_b("exnihilosequentia").func_200465_a(PEBBLE_CONDITION, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.func_200309_a().func_200307_a(input).func_200310_b()})).func_200467_a(consumer, this.createSaveLocation(Objects.requireNonNull(result.getRegistryName())));
    }

    protected void createHammer(Item output, ITag.INamedTag<Item> input, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)output).func_200472_a(" x ").func_200472_a(" -x").func_200472_a("-  ").func_200469_a(Character.valueOf('x'), input).func_200469_a(Character.valueOf('-'), (ITag)Tags.Items.RODS).func_200465_a("has_stick", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.func_200309_a().func_200307_a((ITag)Tags.Items.RODS).func_200310_b()})).func_200465_a(MATERIAL_CONDITION, (ICriterionInstance)AbstractRecipeGenerator.func_200409_a(input)).func_200467_a(consumer, this.createSaveLocation(Objects.requireNonNull(output.getRegistryName())));
    }

    protected void createPebbleBlock(Block result, Item input, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)result).func_200472_a("xx").func_200472_a("xx").func_200462_a(Character.valueOf('x'), (IItemProvider)input).func_200473_b("exnihilosequentia").func_200465_a(PEBBLE_CONDITION, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{input})).func_200467_a(consumer, this.createSaveLocation(result.getRegistryName()));
    }

    protected void createMesh(Item output, Item inputMesh, Tags.IOptionalNamedTag<Item> inputItem, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)output).func_200472_a("i i").func_200472_a("imi").func_200472_a("i i").func_200469_a(Character.valueOf('i'), inputItem).func_200462_a(Character.valueOf('m'), (IItemProvider)inputMesh).func_200465_a("has_mesh", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{inputMesh})).func_200467_a(consumer, this.createSaveLocation(Objects.requireNonNull(output.getRegistryName())));
    }

    protected void createMesh(Item output, Item inputMesh, Item inputItem, Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)output).func_200472_a("i i").func_200472_a("imi").func_200472_a("i i").func_200462_a(Character.valueOf('i'), (IItemProvider)inputItem).func_200462_a(Character.valueOf('m'), (IItemProvider)inputMesh).func_200465_a("has_mesh", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{inputMesh})).func_200467_a(consumer, this.createSaveLocation(Objects.requireNonNull(output.getRegistryName())));
    }
}

