/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import novamachina.exnihilosequentia.client.render.AbstractModBlockRenderer;
import novamachina.exnihilosequentia.client.render.UVLocation;
import novamachina.exnihilosequentia.client.render.VertexLocation;
import novamachina.exnihilosequentia.common.tileentity.crucible.BaseCrucibleTile;
import novamachina.exnihilosequentia.common.utility.Color;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import org.apache.logging.log4j.LogManager;

public class CrucibleRender
extends AbstractModBlockRenderer<BaseCrucibleTile> {
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogManager.getLogger());

    public CrucibleRender(TileEntityRendererDispatcher rendererDispatcher) {
        super(rendererDispatcher);
    }

    public static void register(TileEntityType<? extends BaseCrucibleTile> tileTileEntityType) {
        logger.debug("Register crucible renderer, Type" + tileTileEntityType);
        ClientRegistry.bindTileEntityRenderer(tileTileEntityType, CrucibleRender::new);
    }

    public void render(BaseCrucibleTile tileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        float fillAmount;
        TextureAtlasSprite sprite;
        IVertexBuilder builder;
        ResourceLocation solidTexture = tileEntity.getSolidTexture();
        Fluid fluid = tileEntity.getFluid();
        ResourceLocation fluidTexture = fluid != null ? fluid.getAttributes().getStillTexture() : null;
        Color fluidColor = fluid != null ? new Color(fluid.getAttributes().getColor()) : Color.INVALID_COLOR;
        Color blockColor = this.getBlockColor(solidTexture, tileEntity);
        if (fluidTexture != null) {
            builder = buffer.getBuffer(RenderType.func_228645_f_());
            sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(fluidTexture);
            fillAmount = 0.75f * tileEntity.getFluidProportion() - 0.005f;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.5, 0.5, 0.5);
            matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
            this.add(builder, matrixStack, new VertexLocation(0.0f, 0.25f + fillAmount, 1.0f), new UVLocation(sprite.func_94209_e(), sprite.func_94210_h()), fluidColor, combinedLightIn);
            this.add(builder, matrixStack, new VertexLocation(1.0f, 0.25f + fillAmount, 1.0f), new UVLocation(sprite.func_94212_f(), sprite.func_94210_h()), fluidColor, combinedLightIn);
            this.add(builder, matrixStack, new VertexLocation(1.0f, 0.25f + fillAmount, 0.0f), new UVLocation(sprite.func_94212_f(), sprite.func_94206_g()), fluidColor, combinedLightIn);
            this.add(builder, matrixStack, new VertexLocation(0.0f, 0.25f + fillAmount, 0.0f), new UVLocation(sprite.func_94209_e(), sprite.func_94206_g()), fluidColor, combinedLightIn);
            matrixStack.func_227865_b_();
        }
        if (solidTexture != null) {
            builder = buffer.getBuffer(RenderType.func_228639_c_());
            sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(new ResourceLocation(solidTexture.func_110624_b(), "block/" + this.resolveTexture(solidTexture.func_110623_a())));
            fillAmount = 0.75f * Math.min(tileEntity.getSolidProportion(), 1.0f) - 0.005f;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.5, 0.5, 0.5);
            matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
            this.add(builder, matrixStack, new VertexLocation(0.0f, 0.25f + fillAmount, 1.0f), new UVLocation(sprite.func_94209_e(), sprite.func_94210_h()), blockColor, combinedLightIn);
            this.add(builder, matrixStack, new VertexLocation(1.0f, 0.25f + fillAmount, 1.0f), new UVLocation(sprite.func_94212_f(), sprite.func_94210_h()), blockColor, combinedLightIn);
            this.add(builder, matrixStack, new VertexLocation(1.0f, 0.25f + fillAmount, 0.0f), new UVLocation(sprite.func_94212_f(), sprite.func_94206_g()), blockColor, combinedLightIn);
            this.add(builder, matrixStack, new VertexLocation(0.0f, 0.25f + fillAmount, 0.0f), new UVLocation(sprite.func_94209_e(), sprite.func_94206_g()), blockColor, combinedLightIn);
            matrixStack.func_227865_b_();
        }
    }

    private Color getBlockColor(ResourceLocation solidTexture, BaseCrucibleTile tileEntity) {
        if (solidTexture != null && solidTexture.toString().contains("leaves")) {
            return new Color(tileEntity.func_145831_w().func_226691_t_(tileEntity.func_174877_v()).func_225527_a_());
        }
        return Color.WHITE;
    }
}

