/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.client.setup;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import novamachina.exnihilosequentia.client.render.BarrelRender;
import novamachina.exnihilosequentia.client.render.CrucibleRender;
import novamachina.exnihilosequentia.client.render.SieveRender;
import novamachina.exnihilosequentia.common.init.ExNihiloBlocks;
import novamachina.exnihilosequentia.common.init.ExNihiloTiles;
import novamachina.exnihilosequentia.common.item.ore.EnumOre;
import novamachina.exnihilosequentia.common.item.ore.OreColor;
import novamachina.exnihilosequentia.common.tileentity.crucible.BaseCrucibleTile;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import org.apache.logging.log4j.LogManager;

@Mod.EventBusSubscriber(modid="exnihilosequentia", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientSetup {
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogManager.getLogger());

    private ClientSetup() {
    }

    public static void init(FMLClientSetupEvent event) {
        logger.debug("Initializing client renderers");
        ClientSetup.registerSieveRenderLayer();
        ClientSetup.registerCrucibleRenderLayer();
        ClientSetup.registerBarrelRenderLayer();
        RenderTypeLookup.setRenderLayer((Block)((Block)ExNihiloBlocks.INFESTED_LEAVES.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ExNihiloBlocks.INFESTING_LEAVES.get()), (RenderType)RenderType.func_228643_e_());
        SieveRender.register();
        BarrelRender.register();
        CrucibleRender.register((TileEntityType<? extends BaseCrucibleTile>)((TileEntityType)ExNihiloTiles.CRUCIBLE_FIRED.get()));
        CrucibleRender.register((TileEntityType<? extends BaseCrucibleTile>)((TileEntityType)ExNihiloTiles.CRUCIBLE_WOOD.get()));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onColorHandlerEvent(ColorHandlerEvent.Item event) {
        logger.debug("Fired ColorHandlerEvent.Item event");
        for (EnumOre ore : EnumOre.values()) {
            if (ore.getChunkItem().isPresent()) {
                event.getItemColors().func_199877_a((IItemColor)new OreColor(), new IItemProvider[]{(IItemProvider)ore.getChunkItem().get()});
            } else {
                logger.warn("Missing ore chunk");
            }
            if (ore.getPieceItem().isPresent()) {
                event.getItemColors().func_199877_a((IItemColor)new OreColor(), new IItemProvider[]{(IItemProvider)ore.getPieceItem().get()});
            } else {
                logger.warn("Missing ore piece");
            }
            if (!ore.shouldGenerateIngot()) continue;
            if (ore.getIngotRegistryItem().isPresent()) {
                event.getItemColors().func_199877_a((IItemColor)new OreColor(), new IItemProvider[]{(IItemProvider)ore.getIngotRegistryItem().get()});
                continue;
            }
            logger.warn("Missing ore ingot");
        }
    }

    private static void registerBarrelRenderLayer() {
        RenderTypeLookup.setRenderLayer((Block)((Block)ExNihiloBlocks.BARREL_ACACIA.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ExNihiloBlocks.BARREL_BIRCH.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ExNihiloBlocks.BARREL_DARK_OAK.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ExNihiloBlocks.BARREL_JUNGLE.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ExNihiloBlocks.BARREL_OAK.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ExNihiloBlocks.BARREL_SPRUCE.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ExNihiloBlocks.BARREL_CRIMSON.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ExNihiloBlocks.BARREL_WARPED.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ExNihiloBlocks.BARREL_STONE.get()), (RenderType)RenderType.func_228641_d_());
    }

    private static void registerCrucibleRenderLayer() {
        RenderTypeLookup.setRenderLayer((Block)((Block)ExNihiloBlocks.CRUCIBLE_ACACIA.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ExNihiloBlocks.CRUCIBLE_BIRCH.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ExNihiloBlocks.CRUCIBLE_DARK_OAK.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ExNihiloBlocks.CRUCIBLE_JUNGLE.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ExNihiloBlocks.CRUCIBLE_OAK.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ExNihiloBlocks.CRUCIBLE_SPRUCE.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ExNihiloBlocks.CRUCIBLE_CRIMSON.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ExNihiloBlocks.CRUCIBLE_WARPED.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ExNihiloBlocks.CRUCIBLE_UNFIRED.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ExNihiloBlocks.CRUCIBLE_FIRED.get()), (RenderType)RenderType.func_228641_d_());
    }

    private static void registerSieveRenderLayer() {
        RenderTypeLookup.setRenderLayer((Block)((Block)ExNihiloBlocks.SIEVE_ACACIA.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ExNihiloBlocks.SIEVE_BIRCH.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ExNihiloBlocks.SIEVE_DARK_OAK.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ExNihiloBlocks.SIEVE_JUNGLE.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ExNihiloBlocks.SIEVE_OAK.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ExNihiloBlocks.SIEVE_SPRUCE.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ExNihiloBlocks.SIEVE_CRIMSON.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ExNihiloBlocks.SIEVE_WARPED.get()), (RenderType)RenderType.func_228641_d_());
    }
}

