/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.block;

import java.util.Random;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import novamachina.exnihilosequentia.common.block.BaseBlock;
import novamachina.exnihilosequentia.common.builder.BlockBuilder;
import novamachina.exnihilosequentia.common.compat.top.ITOPInfoProvider;
import novamachina.exnihilosequentia.common.init.ExNihiloBlocks;
import novamachina.exnihilosequentia.common.tileentity.InfestingLeavesTile;
import novamachina.exnihilosequentia.common.utility.Config;
import novamachina.exnihilosequentia.common.utility.StringUtils;

public class InfestingLeavesBlock
extends BaseBlock
implements ITOPInfoProvider {
    private static final Random random = new Random();

    public InfestingLeavesBlock() {
        super(new BlockBuilder().properties(AbstractBlock.Properties.func_200945_a((Material)Material.field_151584_j).func_200943_b(0.2f).func_200947_a(SoundType.field_185850_c).func_226896_b_().func_235827_a_(BaseBlock::never)).tileEntitySupplier(InfestingLeavesTile::new));
    }

    public static void finishInfestingBlock(World world, BlockPos pos) {
        world.func_175656_a(pos, ((BaseBlock)ExNihiloBlocks.INFESTED_LEAVES.get()).func_176223_P());
    }

    public static void normalToInfesting(World world, BlockPos pos) {
        world.func_175656_a(pos, ((BaseBlock)ExNihiloBlocks.INFESTING_LEAVES.get()).func_176223_P());
    }

    public static void spread(World world, BlockPos pos) {
        if (!world.func_201670_d()) {
            NonNullList<BlockPos> nearbyLeaves = InfestingLeavesBlock.getNearbyLeaves(world, pos);
            nearbyLeaves.forEach(leafPos -> {
                if (random.nextDouble() <= Config.getSpreadChance()) {
                    InfestingLeavesBlock.normalToInfesting(world, leafPos);
                }
            });
        }
    }

    private static NonNullList<BlockPos> getNearbyLeaves(World world, BlockPos pos) {
        NonNullList nearbyLeaves = NonNullList.func_191196_a();
        BlockPos.func_218281_b((BlockPos)new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o() - 1, pos.func_177952_p() - 1), (BlockPos)new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o() + 1, pos.func_177952_p() + 1)).forEach(item -> {
            if (world.func_180495_p(item).func_177230_c() instanceof LeavesBlock) {
                nearbyLeaves.add((Object)new BlockPos((Vector3i)item));
            }
        });
        return nearbyLeaves;
    }

    @Override
    public void addProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, PlayerEntity playerEntity, World world, BlockState blockState, IProbeHitData iProbeHitData) {
        if (probeMode == ProbeMode.EXTENDED) {
            InfestingLeavesTile infestingLeavesTile = (InfestingLeavesTile)world.func_175625_s(iProbeHitData.getPos());
            iProbeInfo.text((ITextComponent)new TranslationTextComponent("waila.progress", new Object[]{StringUtils.formatPercent(Float.valueOf((float)infestingLeavesTile.getProgress() / 100.0f))}));
        }
    }
}

