/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.compat.jei;

import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import novamachina.exnihilosequentia.api.ExNihiloRegistries;
import novamachina.exnihilosequentia.api.compat.jei.JEISieveRecipe;
import novamachina.exnihilosequentia.api.crafting.compost.CompostRecipe;
import novamachina.exnihilosequentia.api.crafting.crook.CrookRecipe;
import novamachina.exnihilosequentia.api.crafting.crucible.CrucibleRecipe;
import novamachina.exnihilosequentia.api.crafting.fluiditem.FluidItemRecipe;
import novamachina.exnihilosequentia.api.crafting.fluidontop.FluidOnTopRecipe;
import novamachina.exnihilosequentia.api.crafting.fluidtransform.FluidTransformRecipe;
import novamachina.exnihilosequentia.api.crafting.hammer.HammerRecipe;
import novamachina.exnihilosequentia.api.crafting.heat.HeatRecipe;
import novamachina.exnihilosequentia.common.compat.jei.compost.CompostRecipeCategory;
import novamachina.exnihilosequentia.common.compat.jei.crook.CrookRecipeCategory;
import novamachina.exnihilosequentia.common.compat.jei.crucible.CrucibleRecipeCategory;
import novamachina.exnihilosequentia.common.compat.jei.fluiditem.FluidBlockRecipeCategory;
import novamachina.exnihilosequentia.common.compat.jei.fluidontop.FluidOnTopRecipeCategory;
import novamachina.exnihilosequentia.common.compat.jei.fluidtransform.FluidTransformCategory;
import novamachina.exnihilosequentia.common.compat.jei.hammer.HammerRecipeCategory;
import novamachina.exnihilosequentia.common.compat.jei.heat.HeatRecipeCategory;
import novamachina.exnihilosequentia.common.compat.jei.sieve.dry.DrySieveRecipeCategory;
import novamachina.exnihilosequentia.common.compat.jei.sieve.wet.WetSieveRecipeCategory;
import novamachina.exnihilosequentia.common.init.ExNihiloBlocks;
import novamachina.exnihilosequentia.common.item.tools.crook.EnumCrook;
import novamachina.exnihilosequentia.common.item.tools.hammer.EnumHammer;
import novamachina.exnihilosequentia.common.tileentity.crucible.CrucilbeTypeEnum;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import org.apache.logging.log4j.LogManager;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogManager.getLogger());
    private static final ResourceLocation CRUCIBLES = new ResourceLocation("exnihilosequentia", "crucibles");
    private static final ResourceLocation FIRED_CRUCIBLES = new ResourceLocation("exnihilosequentia", "crucible_fired");

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("jei", "exnihilosequentia");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new CrookRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new DrySieveRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new WetSieveRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new HammerRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FluidOnTopRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FluidTransformCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FluidBlockRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CompostRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CrucibleRecipeCategory(guiHelper, "crucibles")});
        registration.addRecipeCategories(new IRecipeCategory[]{new CrucibleRecipeCategory(guiHelper, "crucible_fired")});
        registration.addRecipeCategories(new IRecipeCategory[]{new HeatRecipeCategory(guiHelper)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        for (EnumCrook enumCrook : EnumCrook.values()) {
            registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)enumCrook.getRegistryObject().get()), new ResourceLocation[]{CrookRecipeCategory.UID});
        }
        for (Enum enum_ : EnumHammer.values()) {
            registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)((EnumHammer)enum_).getRegistryObject().get()), new ResourceLocation[]{HammerRecipeCategory.UID});
        }
        this.registerCrucibles(registration);
        this.registerBarrels(registration);
        this.registerSieves(registration);
    }

    private void registerCrucibles(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ExNihiloBlocks.CRUCIBLE_ACACIA.get()), new ResourceLocation[]{CRUCIBLES, HeatRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ExNihiloBlocks.CRUCIBLE_BIRCH.get()), new ResourceLocation[]{CRUCIBLES, HeatRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ExNihiloBlocks.CRUCIBLE_DARK_OAK.get()), new ResourceLocation[]{CRUCIBLES, HeatRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ExNihiloBlocks.CRUCIBLE_JUNGLE.get()), new ResourceLocation[]{CRUCIBLES, HeatRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ExNihiloBlocks.CRUCIBLE_OAK.get()), new ResourceLocation[]{CRUCIBLES, HeatRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ExNihiloBlocks.CRUCIBLE_SPRUCE.get()), new ResourceLocation[]{CRUCIBLES, HeatRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ExNihiloBlocks.CRUCIBLE_FIRED.get()), new ResourceLocation[]{FIRED_CRUCIBLES, HeatRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ExNihiloBlocks.CRUCIBLE_CRIMSON.get()), new ResourceLocation[]{FIRED_CRUCIBLES, HeatRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ExNihiloBlocks.CRUCIBLE_WARPED.get()), new ResourceLocation[]{FIRED_CRUCIBLES, HeatRecipeCategory.UID});
    }

    private void registerBarrels(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ExNihiloBlocks.BARREL_ACACIA.get()), new ResourceLocation[]{FluidOnTopRecipeCategory.UID, FluidTransformCategory.UID, FluidBlockRecipeCategory.UID, CompostRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ExNihiloBlocks.BARREL_BIRCH.get()), new ResourceLocation[]{FluidOnTopRecipeCategory.UID, FluidTransformCategory.UID, FluidBlockRecipeCategory.UID, CompostRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ExNihiloBlocks.BARREL_DARK_OAK.get()), new ResourceLocation[]{FluidOnTopRecipeCategory.UID, FluidTransformCategory.UID, FluidBlockRecipeCategory.UID, CompostRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ExNihiloBlocks.BARREL_JUNGLE.get()), new ResourceLocation[]{FluidOnTopRecipeCategory.UID, FluidTransformCategory.UID, FluidBlockRecipeCategory.UID, CompostRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ExNihiloBlocks.BARREL_OAK.get()), new ResourceLocation[]{FluidOnTopRecipeCategory.UID, FluidTransformCategory.UID, FluidBlockRecipeCategory.UID, CompostRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ExNihiloBlocks.BARREL_SPRUCE.get()), new ResourceLocation[]{FluidOnTopRecipeCategory.UID, FluidTransformCategory.UID, FluidBlockRecipeCategory.UID, CompostRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ExNihiloBlocks.BARREL_STONE.get()), new ResourceLocation[]{FluidOnTopRecipeCategory.UID, FluidTransformCategory.UID, FluidBlockRecipeCategory.UID, CompostRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ExNihiloBlocks.BARREL_CRIMSON.get()), new ResourceLocation[]{FluidOnTopRecipeCategory.UID, FluidTransformCategory.UID, FluidBlockRecipeCategory.UID, CompostRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ExNihiloBlocks.BARREL_WARPED.get()), new ResourceLocation[]{FluidOnTopRecipeCategory.UID, FluidTransformCategory.UID, FluidBlockRecipeCategory.UID, CompostRecipeCategory.UID});
    }

    private void registerSieves(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ExNihiloBlocks.SIEVE_ACACIA.get()), new ResourceLocation[]{DrySieveRecipeCategory.UID, WetSieveRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ExNihiloBlocks.SIEVE_BIRCH.get()), new ResourceLocation[]{DrySieveRecipeCategory.UID, WetSieveRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ExNihiloBlocks.SIEVE_DARK_OAK.get()), new ResourceLocation[]{DrySieveRecipeCategory.UID, WetSieveRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ExNihiloBlocks.SIEVE_JUNGLE.get()), new ResourceLocation[]{DrySieveRecipeCategory.UID, WetSieveRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ExNihiloBlocks.SIEVE_OAK.get()), new ResourceLocation[]{DrySieveRecipeCategory.UID, WetSieveRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ExNihiloBlocks.SIEVE_SPRUCE.get()), new ResourceLocation[]{DrySieveRecipeCategory.UID, WetSieveRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ExNihiloBlocks.SIEVE_CRIMSON.get()), new ResourceLocation[]{DrySieveRecipeCategory.UID, WetSieveRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ExNihiloBlocks.SIEVE_WARPED.get()), new ResourceLocation[]{DrySieveRecipeCategory.UID, WetSieveRecipeCategory.UID});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.registerCrook(registration);
        this.registerSieve(registration);
        this.registerHammer(registration);
        this.registerFluidOnTop(registration);
        this.registerFluidTransform(registration);
        this.registerFluidBlock(registration);
        this.registerCompost(registration);
        this.registerFiredCrucible(registration);
        this.registerWoodCrucible(registration);
        this.registerHeat(registration);
    }

    private void registerCompost(IRecipeRegistration registration) {
        List<CompostRecipe> recipes = ExNihiloRegistries.COMPOST_REGISTRY.getRecipeList();
        registration.addRecipes(recipes, CompostRecipeCategory.UID);
        logger.info("Compost Recipes Loaded: " + recipes.size());
    }

    private void registerCrook(IRecipeRegistration registration) {
        List<CrookRecipe> crookRecipes = ExNihiloRegistries.CROOK_REGISTRY.getRecipeList();
        registration.addRecipes(crookRecipes, CrookRecipeCategory.UID);
        logger.info("Crook Recipes Loaded: " + crookRecipes.size());
    }

    private void registerFiredCrucible(IRecipeRegistration registration) {
        List<CrucibleRecipe> recipes = ExNihiloRegistries.CRUCIBLE_REGISTRY.getRecipeList();
        registration.addRecipes(recipes, FIRED_CRUCIBLES);
        logger.info("Fired Crucible Recipes Loaded: " + recipes.size());
    }

    private void registerFluidBlock(IRecipeRegistration registration) {
        List<FluidItemRecipe> recipes = ExNihiloRegistries.FLUID_BLOCK_REGISTRY.getRecipeList();
        registration.addRecipes(recipes, FluidBlockRecipeCategory.UID);
        logger.info("Fluid Item Recipes Loaded: " + recipes.size());
    }

    private void registerFluidOnTop(IRecipeRegistration registration) {
        List<FluidOnTopRecipe> recipes = ExNihiloRegistries.FLUID_ON_TOP_REGISTRY.getRecipeList();
        registration.addRecipes(recipes, FluidOnTopRecipeCategory.UID);
        logger.info("Fluid On Top Recipes Loaded: " + recipes.size());
    }

    private void registerFluidTransform(IRecipeRegistration registration) {
        List<FluidTransformRecipe> recipes = ExNihiloRegistries.FLUID_TRANSFORM_REGISTRY.getRecipeList();
        registration.addRecipes(recipes, FluidTransformCategory.UID);
        logger.info("Fluid Transform Recipes Loaded: " + recipes.size());
    }

    private void registerHammer(IRecipeRegistration registration) {
        List<HammerRecipe> recipes = ExNihiloRegistries.HAMMER_REGISTRY.getRecipeList();
        registration.addRecipes(recipes, HammerRecipeCategory.UID);
        logger.info("Hammer Recipes Loaded: " + recipes.size());
    }

    private void registerHeat(IRecipeRegistration registration) {
        List<HeatRecipe> recipes = ExNihiloRegistries.HEAT_REGISTRY.getRecipeList();
        registration.addRecipes(recipes, HeatRecipeCategory.UID);
        logger.info("Heat Recipes Loaded: " + recipes.size());
    }

    private void registerSieve(IRecipeRegistration registration) {
        List<JEISieveRecipe> drySieveRecipes = ExNihiloRegistries.SIEVE_REGISTRY.getDryRecipeList();
        List<JEISieveRecipe> wetSieveRecipes = ExNihiloRegistries.SIEVE_REGISTRY.getWetRecipeList();
        registration.addRecipes(drySieveRecipes, DrySieveRecipeCategory.UID);
        registration.addRecipes(wetSieveRecipes, WetSieveRecipeCategory.UID);
        logger.info("Sieve Recipes Loaded: " + (drySieveRecipes.size() + wetSieveRecipes.size()));
    }

    private void registerWoodCrucible(IRecipeRegistration registration) {
        List recipes = ExNihiloRegistries.CRUCIBLE_REGISTRY.getRecipeList().stream().filter(recipe -> recipe.getCrucibleType() == CrucilbeTypeEnum.WOOD).collect(Collectors.toList());
        registration.addRecipes(recipes, CRUCIBLES);
        logger.info("Wooden Crucible Recipes Loaded: " + recipes.size());
    }
}

