/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.compat.jei.heat;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import novamachina.exnihilosequentia.api.crafting.heat.HeatRecipe;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import org.apache.logging.log4j.LogManager;

public class HeatRecipeCategory
implements IRecipeCategory<HeatRecipe> {
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogManager.getLogger());
    public static final ResourceLocation UID = new ResourceLocation("exnihilosequentia", "heat");
    private final IDrawableStatic background;

    public HeatRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(new ResourceLocation("jei", "textures/gui/gui_vanilla.png"), 0, 134, 18, 34).addPadding(0, 0, 0, 80).build();
    }

    public void draw(HeatRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.field_71466_p.func_238421_b_(matrixStack, recipe.getAmount() + "X", 24.0f, 12.0f, Color.gray.getRGB());
        Block block = recipe.getInput();
        if (block == Blocks.field_196591_bQ) {
            minecraft.field_71466_p.func_238421_b_(matrixStack, "Wall Torch", 24.0f, 0.0f, Color.DARK_GRAY.getRGB());
        } else if (block == Blocks.field_196677_cy) {
            minecraft.field_71466_p.func_238421_b_(matrixStack, "Redstone Wall Torch", 24.0f, 0.0f, Color.DARK_GRAY.getRGB());
        } else {
            minecraft.field_71466_p.func_243248_b(matrixStack, (ITextComponent)block.func_235333_g_(), 24.0f, 0.0f, Color.DARK_GRAY.getRGB());
        }
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public Class<? extends HeatRecipe> getRecipeClass() {
        return HeatRecipe.class;
    }

    public String getTitle() {
        return "Crucible Heat Sources";
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public void setIngredients(HeatRecipe recipe, IIngredients ingredients) {
        if (ForgeRegistries.FLUIDS.containsKey(recipe.getInput().getRegistryName())) {
            ingredients.setInput(VanillaTypes.FLUID, (Object)new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(recipe.getInput().getRegistryName()), 1000));
        } else {
            ingredients.setInputs(VanillaTypes.ITEM, Arrays.asList(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{recipe.getInput()}).func_193365_a()));
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, HeatRecipe recipe, IIngredients ingredients) {
        if (ForgeRegistries.FLUIDS.containsKey(recipe.getInput().getRegistryName())) {
            recipeLayout.getFluidStacks().init(0, true, 1, 17);
            recipeLayout.getFluidStacks().set(0, new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(recipe.getInput().getRegistryName()), 1000));
        } else {
            Block input = recipe.getInput();
            if (input == Blocks.field_150480_ab || input == Blocks.field_235335_bO_) {
                input = Items.field_151033_d;
            }
            if (input instanceof FlowingFluidBlock) {
                input = ((FlowingFluidBlock)input).getFluid().func_204524_b();
            }
            recipeLayout.getItemStacks().init(0, true, 0, 16);
            recipeLayout.getItemStacks().set(0, Arrays.asList(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input}).func_193365_a()));
        }
    }
}

