/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.crafting.serializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import novamachina.exnihilosequentia.api.crafting.RecipeSerializer;
import novamachina.exnihilosequentia.api.crafting.heat.HeatRecipe;
import novamachina.exnihilosequentia.common.init.ExNihiloBlocks;

public class HeatRecipeSerializer
extends RecipeSerializer<HeatRecipe> {
    private static final JsonParser PARSER = new JsonParser();

    @Override
    public ItemStack getIcon() {
        return new ItemStack((IItemProvider)ExNihiloBlocks.CRUCIBLE_FIRED.get());
    }

    public HeatRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
        Block input = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(buffer.func_218666_n()));
        int amount = buffer.readInt();
        boolean hasProperties = buffer.readBoolean();
        if (hasProperties) {
            StatePropertiesPredicate properties = StatePropertiesPredicate.func_227186_a_((JsonElement)PARSER.parse(buffer.func_218666_n()));
            return new HeatRecipe(recipeId, input, amount, properties);
        }
        return new HeatRecipe(recipeId, input, amount);
    }

    public void toNetwork(PacketBuffer buffer, HeatRecipe recipe) {
        buffer.func_180714_a(recipe.getInput().getRegistryName().toString());
        buffer.writeInt(recipe.getAmount());
        StatePropertiesPredicate properties = recipe.getProperties();
        boolean hasProperties = properties != null;
        buffer.writeBoolean(hasProperties);
        if (hasProperties) {
            buffer.func_180714_a(properties.func_227180_a_().toString());
        }
    }

    @Override
    protected HeatRecipe readFromJson(ResourceLocation recipeId, JsonObject json) {
        Block input = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(json.get("block").getAsString()));
        int amount = json.get("amount").getAsInt();
        if (json.has("state")) {
            return new HeatRecipe(recipeId, input, amount, StatePropertiesPredicate.func_227186_a_((JsonElement)json.get("state")));
        }
        return new HeatRecipe(recipeId, input, amount);
    }
}

