/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.crafting.serializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import novamachina.exnihilosequentia.api.crafting.RecipeSerializer;
import novamachina.exnihilosequentia.api.crafting.sieve.MeshWithChance;
import novamachina.exnihilosequentia.api.crafting.sieve.SieveRecipe;
import novamachina.exnihilosequentia.common.init.ExNihiloBlocks;

public class SieveRecipeSerializer
extends RecipeSerializer<SieveRecipe> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack((IItemProvider)ExNihiloBlocks.SIEVE_OAK.get());
    }

    public SieveRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
        Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
        ItemStack drop = buffer.func_150791_c();
        ArrayList<MeshWithChance> rolls = new ArrayList<MeshWithChance>();
        int count = buffer.readInt();
        for (int i = 0; i < count; ++i) {
            rolls.add(MeshWithChance.read(buffer));
        }
        boolean isWaterlogged = buffer.readBoolean();
        return new SieveRecipe(recipeId, input, drop, rolls, isWaterlogged);
    }

    public void toNetwork(PacketBuffer buffer, SieveRecipe recipe) {
        recipe.getInput().func_199564_a(buffer);
        buffer.func_150788_a(recipe.getDrop());
        buffer.writeInt(recipe.getRolls().size());
        for (MeshWithChance meshWithChance : recipe.getRolls()) {
            meshWithChance.write(buffer);
        }
        buffer.writeBoolean(recipe.isWaterlogged());
    }

    @Override
    protected SieveRecipe readFromJson(ResourceLocation recipeId, JsonObject json) {
        Ingredient input = Ingredient.func_199802_a((JsonElement)json.get("input"));
        ItemStack drop = this.readOutput(json.get("result"));
        ArrayList<MeshWithChance> rolls = new ArrayList<MeshWithChance>();
        for (JsonElement element : json.get("rolls").getAsJsonArray()) {
            rolls.add(MeshWithChance.deserialize(element));
        }
        if (json.has("waterlogged")) {
            return new SieveRecipe(recipeId, input, drop, rolls, json.get("waterlogged").getAsBoolean());
        }
        return new SieveRecipe(recipeId, input, drop, rolls, false);
    }
}

