/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.datagen;

import net.minecraft.data.DataGenerator;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;
import novamachina.exnihilosequentia.api.datagen.AbstractItemGenerator;
import novamachina.exnihilosequentia.common.init.ExNihiloItems;
import novamachina.exnihilosequentia.common.item.dolls.EnumDoll;
import novamachina.exnihilosequentia.common.item.mesh.EnumMesh;
import novamachina.exnihilosequentia.common.item.pebbles.EnumPebbleType;
import novamachina.exnihilosequentia.common.item.resources.EnumResource;
import novamachina.exnihilosequentia.common.item.seeds.EnumSeed;
import novamachina.exnihilosequentia.common.item.tools.crook.EnumCrook;
import novamachina.exnihilosequentia.common.item.tools.hammer.EnumHammer;

public class ExNihiloItemGenerator
extends AbstractItemGenerator {
    private static final String ITEMS_TAG = "items/";
    private static final String ITEM_HANDHELD_TAG = "item/handheld";
    private static final String LAYER_0_TAG = "layer0";

    public ExNihiloItemGenerator(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "exnihilosequentia", existingFileHelper);
    }

    protected void registerModels() {
        this.singleTexture(((Item)ExNihiloItems.COOKED_SILKWORM.get()).getRegistryName().func_110623_a(), new ResourceLocation(ITEM_HANDHELD_TAG), LAYER_0_TAG, new ResourceLocation(this.modid, "items/cooked_silkworm"));
        this.singleTexture(((BucketItem)ExNihiloItems.WITCH_WATER_BUCKET.get()).getRegistryName().func_110623_a(), new ResourceLocation(ITEM_HANDHELD_TAG), LAYER_0_TAG, new ResourceLocation(this.modid, "items/bucket_witchwater"));
        this.singleTexture(((BucketItem)ExNihiloItems.SEA_WATER_BUCKET.get()).getRegistryName().func_110623_a(), new ResourceLocation(ITEM_HANDHELD_TAG), LAYER_0_TAG, new ResourceLocation(this.modid, "items/bucket_sea_water"));
        this.registerCrooks();
        this.registerHammers();
        this.registerSeeds();
        this.registerResources();
        this.registerPebbles();
        this.registerMeshes();
        this.registerDolls();
    }

    private void registerCrooks() {
        for (EnumCrook crook : EnumCrook.values()) {
            this.singleTexture(((Item)crook.getRegistryObject().get()).getRegistryName().func_110623_a(), new ResourceLocation(ITEM_HANDHELD_TAG), LAYER_0_TAG, new ResourceLocation(this.modid, "items/tools/crook/" + crook.crookName));
        }
    }

    private void registerDolls() {
        for (EnumDoll doll : EnumDoll.values()) {
            this.singleTexture(((Item)doll.getRegistryObject().get()).getRegistryName().func_110623_a(), new ResourceLocation(ITEM_HANDHELD_TAG), LAYER_0_TAG, new ResourceLocation(this.modid, ITEMS_TAG + doll.getDollName()));
        }
    }

    private void registerHammers() {
        for (EnumHammer hammer : EnumHammer.values()) {
            this.singleTexture(((Item)hammer.getRegistryObject().get()).getRegistryName().func_110623_a(), new ResourceLocation(ITEM_HANDHELD_TAG), LAYER_0_TAG, new ResourceLocation(this.modid, "items/tools/hammer/" + hammer.hammerName));
        }
    }

    private void registerMeshes() {
        for (EnumMesh mesh : EnumMesh.values()) {
            if (mesh == EnumMesh.NONE) continue;
            this.withExistingParent(((Item)mesh.getRegistryObject().get()).getRegistryName().func_110623_a(), new ResourceLocation(this.modid, "block/" + mesh.getMeshName()));
        }
    }

    private void registerPebbles() {
        for (EnumPebbleType pebble : EnumPebbleType.values()) {
            this.singleTexture(((Item)pebble.getRegistryObject().get()).getRegistryName().func_110623_a(), new ResourceLocation(ITEM_HANDHELD_TAG), LAYER_0_TAG, new ResourceLocation(this.modid, ITEMS_TAG + pebble.getType()));
        }
    }

    private void registerResources() {
        for (EnumResource resource : EnumResource.values()) {
            this.singleTexture(((Item)resource.getRegistryObject().get()).getRegistryName().func_110623_a(), new ResourceLocation(ITEM_HANDHELD_TAG), LAYER_0_TAG, new ResourceLocation(this.modid, ITEMS_TAG + resource.getResourceName()));
        }
    }

    private void registerSeeds() {
        for (EnumSeed seed : EnumSeed.values()) {
            this.singleTexture(((Item)seed.getRegistryObject().get()).getRegistryName().func_110623_a(), new ResourceLocation(ITEM_HANDHELD_TAG), LAYER_0_TAG, new ResourceLocation(this.modid, ITEMS_TAG + seed.getSeedName()));
        }
    }
}

