/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.datagen;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.data.SmithingRecipeBuilder;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import novamachina.exnihilosequentia.api.ExNihiloTags;
import novamachina.exnihilosequentia.api.crafting.sieve.MeshWithChance;
import novamachina.exnihilosequentia.api.crafting.sieve.SieveRecipeBuilder;
import novamachina.exnihilosequentia.api.datagen.AbstractRecipeGenerator;
import novamachina.exnihilosequentia.common.block.BaseBlock;
import novamachina.exnihilosequentia.common.block.BaseFallingBlock;
import novamachina.exnihilosequentia.common.init.ExNihiloBlocks;
import novamachina.exnihilosequentia.common.init.ExNihiloFluids;
import novamachina.exnihilosequentia.common.init.ExNihiloItems;
import novamachina.exnihilosequentia.common.item.dolls.EnumDoll;
import novamachina.exnihilosequentia.common.item.mesh.EnumMesh;
import novamachina.exnihilosequentia.common.item.ore.EnumOre;
import novamachina.exnihilosequentia.common.item.pebbles.EnumPebbleType;
import novamachina.exnihilosequentia.common.item.resources.EnumResource;
import novamachina.exnihilosequentia.common.item.seeds.EnumSeed;
import novamachina.exnihilosequentia.common.item.tools.crook.EnumCrook;
import novamachina.exnihilosequentia.common.item.tools.hammer.EnumHammer;

public class ExNihiloRecipeGenerator
extends AbstractRecipeGenerator {
    private static final String COBBLESTONE = "cobblestone";
    private static final String DOLL_CONDITION = "has_doll";
    private static final String GRAVEL_SUFFIX = "_gravel";
    private static final String LEAVES = "leaves";
    private static final String MATERIAL_CONDITION = "has_material";
    private static final String NETHERRACK = "netherrack";
    private static final String PORCELAIN_CLAY_CONDITION = "has_porcelain_clay";
    private static final Fluid water = Fluids.field_204546_a;
    private static final Fluid lava = Fluids.field_204547_b;
    private static final Fluid witchwater = (Fluid)ExNihiloFluids.WITCH_WATER.get();
    private static final Fluid seawater = (Fluid)ExNihiloFluids.SEA_WATER.get();

    public ExNihiloRecipeGenerator(DataGenerator generator) {
        super(generator, "exnihilosequentia");
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        this.registerCrooks(consumer);
        this.registerPebbleBlocks(consumer);
        this.registerBarrels(consumer);
        this.registerCrucibles(consumer);
        this.registerSieves(consumer);
        this.registerOres(consumer);
        this.registerHammers(consumer);
        this.registerDolls(consumer);
        this.registerMeshes(consumer);
        this.registerMisc(consumer);
        this.registerCustomRecipes(consumer);
    }

    private Map<Block, Item> getLeavesSaplings() {
        HashMap<Block, Item> saplingMap = new HashMap<Block, Item>();
        saplingMap.put(Blocks.field_196572_aa, Items.field_221596_x);
        saplingMap.put(Blocks.field_196647_Y, Items.field_221594_v);
        saplingMap.put(Blocks.field_196574_ab, Items.field_221597_y);
        saplingMap.put(Blocks.field_196648_Z, Items.field_221595_w);
        saplingMap.put(Blocks.field_196642_W, Items.field_221592_t);
        saplingMap.put(Blocks.field_196645_X, Items.field_221593_u);
        return saplingMap;
    }

    private void registerBarrels(Consumer<IFinishedRecipe> consumer) {
        this.createBarrel(consumer, ExNihiloBlocks.BARREL_STONE, (Tags.IOptionalNamedTag<Item>)Tags.Items.STONE, Items.field_221712_br);
        this.createBarrel(consumer, ExNihiloBlocks.BARREL_ACACIA, Items.field_221590_r, Items.field_221708_bp);
        this.createBarrel(consumer, ExNihiloBlocks.BARREL_BIRCH, Items.field_221588_p, Items.field_221704_bn);
        this.createBarrel(consumer, ExNihiloBlocks.BARREL_DARK_OAK, Items.field_221591_s, Items.field_221710_bq);
        this.createBarrel(consumer, ExNihiloBlocks.BARREL_JUNGLE, Items.field_221589_q, Items.field_221706_bo);
        this.createBarrel(consumer, ExNihiloBlocks.BARREL_OAK, Items.field_221586_n, Items.field_221700_bl);
        this.createBarrel(consumer, ExNihiloBlocks.BARREL_SPRUCE, Items.field_221587_o, Items.field_221702_bm);
        this.createBarrel(consumer, ExNihiloBlocks.BARREL_CRIMSON, Items.field_234798_v_, Items.field_234720_bO_);
        this.createBarrel(consumer, ExNihiloBlocks.BARREL_WARPED, Items.field_234799_w_, Items.field_234721_bP_);
    }

    private void registerCompostRecipes(Consumer<IFinishedRecipe> consumer) {
        this.createCompostRecipe(consumer, (ITag.INamedTag<Item>)ItemTags.field_200037_g, 125, "saplings");
        this.createCompostRecipe(consumer, (ITag.INamedTag<Item>)ItemTags.field_206963_E, 125, LEAVES);
        this.createCompostRecipe(consumer, (ITag.INamedTag<Item>)ItemTags.field_226159_I_, 100, "flowers");
        this.createCompostRecipe(consumer, (ITag.INamedTag<Item>)ItemTags.field_206964_G, 150, "fishes");
        this.createCompostRecipe(consumer, ExNihiloTags.MEAT_COOKED, 200, "meat_cooked");
        this.createCompostRecipe(consumer, ExNihiloTags.MEAT_UNCOOKED, 200, "meat_uncooked");
        this.createCompostRecipe(consumer, (ITag.INamedTag<Item>)Tags.Items.SEEDS, 80, "seeds");
        this.createCompostRecipe(consumer, (ITag.INamedTag<Item>)Tags.Items.CROPS_WHEAT, 80, "wheat");
        this.createCompostRecipe(consumer, (ITag.INamedTag<Item>)Tags.Items.CROPS_CARROT, 100, "carrot");
        this.createCompostRecipe(consumer, (ITag.INamedTag<Item>)Tags.Items.CROPS_BEETROOT, 100, "beetroot");
        this.createCompostRecipe(consumer, (ITag.INamedTag<Item>)Tags.Items.CROPS_POTATO, 100, "potato");
        this.createCompostRecipe(consumer, (ITag.INamedTag<Item>)Tags.Items.CROPS_NETHER_WART, 100, "nether_wart");
        this.createCompostRecipe(consumer, (ITag.INamedTag<Item>)Tags.Items.EGGS, 80, "eggs");
        this.createCompostRecipe(consumer, (ITag.INamedTag<Item>)Tags.Items.STRING, 40, "string");
        this.createCompostRecipe(consumer, Items.field_151078_bh, 100, "rotten_flesh");
        this.createCompostRecipe(consumer, Items.field_151070_bp, 80, "spider_eye");
        this.createCompostRecipe(consumer, Items.field_151025_P, 160, "bread");
        this.createCompostRecipe(consumer, Blocks.field_150338_P, 100, "brown_mushroom");
        this.createCompostRecipe(consumer, Blocks.field_150337_Q, 100, "red_mushroom");
        this.createCompostRecipe(consumer, Items.field_234722_bw_, 100, "crimson_fungus");
        this.createCompostRecipe(consumer, Items.field_234723_bx_, 100, "warped_fungus");
        this.createCompostRecipe(consumer, Items.field_151158_bO, 160, "pumpkin_pie");
        this.createCompostRecipe(consumer, (Item)ExNihiloItems.SILKWORM.get(), 40, "silkworm");
        this.createCompostRecipe(consumer, (Item)ExNihiloItems.COOKED_SILKWORM.get(), 40, "cooked_silkworm");
        this.createCompostRecipe(consumer, Items.field_151034_e, 100, "apple");
        this.createCompostRecipe(consumer, Items.field_151127_ba, 40, "melon_slice");
        this.createCompostRecipe(consumer, Items.field_221794_dg, 166, "melon");
        this.createCompostRecipe(consumer, Items.field_221687_cF, 166, "pumpkin");
        this.createCompostRecipe(consumer, Items.field_221689_cG, 166, "carved_pumpkin");
        this.createCompostRecipe(consumer, Items.field_221697_cK, 166, "jack_o_lantern");
        this.createCompostRecipe(consumer, Items.field_221774_cw, 100, "cactus");
        this.createCompostRecipe(consumer, Items.field_151168_bH, 150, "baked_potato");
        this.createCompostRecipe(consumer, Items.field_151170_bI, 200, "poisonous_potato");
        this.createCompostRecipe(consumer, Items.field_221816_dr, 100, "lily_pad");
        this.createCompostRecipe(consumer, Items.field_221796_dh, 100, "vine");
        this.createCompostRecipe(consumer, Items.field_234718_bB_, 100, "weeping_vine");
        this.createCompostRecipe(consumer, Items.field_234719_bC_, 100, "twisting_vine");
        this.createCompostRecipe(consumer, Items.field_221916_fp, 100, "tall_grass");
        this.createCompostRecipe(consumer, Items.field_222065_kN, 80, "sugar_cane");
        this.createCompostRecipe(consumer, (Item)EnumResource.GRASS_SEED.getRegistryObject().get(), 100, "grass_seed");
        this.createCompostRecipe(consumer, (Item)EnumResource.ANCIENT_SPORE.getRegistryObject().get(), 100, "ancient_spore");
        this.createCompostRecipe(consumer, Items.field_222112_pR, 100, "sweet_berries");
    }

    private void registerCrookRecipes(Consumer<IFinishedRecipe> consumer) {
        this.createCrookRecipes(consumer, (ITag.INamedTag<Item>)ItemTags.field_206963_E, (IItemProvider)ExNihiloItems.SILKWORM.get(), 0.1f, LEAVES);
        this.createCrookRecipes(consumer, (Block)ExNihiloBlocks.INFESTED_LEAVES.get(), (IItemProvider)ExNihiloItems.SILKWORM.get(), 0.2f, "silkworm");
        this.createCrookRecipes(consumer, (Block)ExNihiloBlocks.INFESTED_LEAVES.get(), (IItemProvider)Items.field_151007_F, 0.5f, "string");
    }

    private void registerCrooks(Consumer<IFinishedRecipe> consumer) {
        this.createCrook((Item)EnumCrook.ANDESITE.getRegistryObject().get(), (Item)EnumPebbleType.ANDESITE.getRegistryObject().get(), consumer);
        this.createCrook((Item)EnumCrook.BONE.getRegistryObject().get(), (ITag.INamedTag<Item>)Tags.Items.BONES, consumer);
        this.createCrook((Item)EnumCrook.DIAMOND.getRegistryObject().get(), (ITag.INamedTag<Item>)Tags.Items.GEMS_DIAMOND, consumer);
        this.createCrook((Item)EnumCrook.DIORITE.getRegistryObject().get(), (Item)EnumPebbleType.DIORITE.getRegistryObject().get(), consumer);
        this.createCrook((Item)EnumCrook.GOLD.getRegistryObject().get(), (ITag.INamedTag<Item>)Tags.Items.NUGGETS_GOLD, consumer);
        this.createCrook((Item)EnumCrook.GRANITE.getRegistryObject().get(), (Item)EnumPebbleType.GRANITE.getRegistryObject().get(), consumer);
        this.createCrook((Item)EnumCrook.IRON.getRegistryObject().get(), (ITag.INamedTag<Item>)Tags.Items.NUGGETS_IRON, consumer);
        this.createCrook((Item)EnumCrook.STONE.getRegistryObject().get(), (Item)EnumPebbleType.STONE.getRegistryObject().get(), consumer);
        this.createCrook((Item)EnumCrook.WOOD.getRegistryObject().get(), (ITag.INamedTag<Item>)Tags.Items.RODS_WOODEN, consumer);
    }

    private void registerCrucibles(Consumer<IFinishedRecipe> consumer) {
        this.createCrucible(consumer, ExNihiloBlocks.CRUCIBLE_ACACIA, Items.field_221558_K, Items.field_221708_bp);
        this.createCrucible(consumer, ExNihiloBlocks.CRUCIBLE_BIRCH, Items.field_221556_I, Items.field_221704_bn);
        this.createCrucible(consumer, ExNihiloBlocks.CRUCIBLE_DARK_OAK, Items.field_221559_L, Items.field_221710_bq);
        this.createCrucible(consumer, ExNihiloBlocks.CRUCIBLE_JUNGLE, Items.field_221557_J, Items.field_221706_bo);
        this.createCrucible(consumer, ExNihiloBlocks.CRUCIBLE_OAK, Items.field_221554_G, Items.field_221700_bl);
        this.createCrucible(consumer, ExNihiloBlocks.CRUCIBLE_SPRUCE, Items.field_221555_H, Items.field_221702_bm);
        this.createCrucible(consumer, ExNihiloBlocks.CRUCIBLE_CRIMSON, Items.field_234709_R_, Items.field_234720_bO_);
        this.createCrucible(consumer, ExNihiloBlocks.CRUCIBLE_WARPED, Items.field_234710_S_, Items.field_234721_bP_);
    }

    private void registerCrucibleRecipes(Consumer<IFinishedRecipe> consumer) {
        this.createFiredCrucibleRecipes(consumer, Blocks.field_150347_e, 250, COBBLESTONE);
        this.createFiredCrucibleRecipes(consumer, Blocks.field_196654_e, 250, "diorite");
        this.createFiredCrucibleRecipes(consumer, Blocks.field_196656_g, 250, "andesite");
        this.createFiredCrucibleRecipes(consumer, Blocks.field_196650_c, 250, "granite");
        this.createFiredCrucibleRecipes(consumer, Blocks.field_150348_b, 250, "stone");
        this.createFiredCrucibleRecipes(consumer, Blocks.field_150351_n, 200, "gravel");
        this.createFiredCrucibleRecipes(consumer, (Block)ExNihiloBlocks.CRUSHED_ANDESITE.get(), 200, "crushed_andesite");
        this.createFiredCrucibleRecipes(consumer, (Block)ExNihiloBlocks.CRUSHED_DIORITE.get(), 200, "crushed_diorite");
        this.createFiredCrucibleRecipes(consumer, (Block)ExNihiloBlocks.CRUSHED_END_STONE.get(), 200, "crushed_end_stone");
        this.createFiredCrucibleRecipes(consumer, (Block)ExNihiloBlocks.CRUSHED_GRANITE.get(), 200, "crushed_granite");
        this.createFiredCrucibleRecipes(consumer, (Block)ExNihiloBlocks.CRUSHED_NETHERRACK.get(), 200, "crushed_netherrack");
        this.createFiredCrucibleRecipes(consumer, Blocks.field_150354_m, 100, "sand");
        this.createFiredCrucibleRecipes(consumer, (Block)ExNihiloBlocks.DUST.get(), 50, "dust");
        this.createFiredCrucibleRecipes(consumer, Blocks.field_150424_aL, 1000, NETHERRACK);
        this.createFiredCrucibleRecipes(consumer, Blocks.field_150343_Z, 1000, "obsidian");
        this.createWaterCrucibleRecipes(consumer, (ITag.INamedTag<Item>)ItemTags.field_200037_g, 250, "saplings");
        this.createWaterCrucibleRecipes(consumer, (ITag.INamedTag<Item>)ItemTags.field_206963_E, 250, LEAVES);
    }

    private void registerCustomRecipes(Consumer<IFinishedRecipe> consumer) {
        this.registerHammerRecipes(consumer);
        this.registerCrookRecipes(consumer);
        this.registerCompostRecipes(consumer);
        this.registerFluidItemRecipes(consumer);
        this.registerFluidOnTopRecipes(consumer);
        this.registerFluidTransformRecipes(consumer);
        this.registerCrucibleRecipes(consumer);
        this.registerHeatRecipes(consumer);
        this.registerSieveRecipes(consumer);
    }

    private void registerDefaultOres(Consumer<IFinishedRecipe> consumer, EnumOre ore) {
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150351_n})).addResult((IItemProvider)ore.getPieceItem().get())).addRoll(new MeshWithChance(EnumMesh.FLINT, 0.05f)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.075f)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.1f)).build(consumer, this.sieveLoc(ore.getPieceName() + GRAVEL_SUFFIX));
    }

    private void registerDolls(Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)EnumDoll.SHULKER.getRegistryObject().get())).func_200472_a("ctc").func_200472_a("sms").func_200472_a("cbc").func_200469_a(Character.valueOf('c'), (ITag)Tags.Items.DYES_PURPLE).func_200469_a(Character.valueOf('s'), (ITag)Tags.Items.DUSTS_GLOWSTONE).func_200469_a(Character.valueOf('t'), (ITag)Tags.Items.END_STONES).func_200469_a(Character.valueOf('b'), (ITag)Tags.Items.ENDER_PEARLS).func_200462_a(Character.valueOf('m'), (IItemProvider)EnumResource.CRAFTING_DOLL.getRegistryObject().get()).func_200465_a(DOLL_CONDITION, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumResource.CRAFTING_DOLL.getRegistryObject().get()})).func_200467_a(consumer, this.createSaveLocation(EnumDoll.SHULKER.getRegistryObject().getId()));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)EnumDoll.GUARDIAN.getRegistryObject().get())).func_200472_a("ctc").func_200472_a("sms").func_200472_a("cbc").func_200469_a(Character.valueOf('c'), (ITag)Tags.Items.GEMS_PRISMARINE).func_200469_a(Character.valueOf('s'), (ITag)Tags.Items.DUSTS_GLOWSTONE).func_200469_a(Character.valueOf('t'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('b'), (ITag)ItemTags.field_206964_G).func_200462_a(Character.valueOf('m'), (IItemProvider)EnumResource.CRAFTING_DOLL.getRegistryObject().get()).func_200465_a(DOLL_CONDITION, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumResource.CRAFTING_DOLL.getRegistryObject().get()})).func_200467_a(consumer, this.createSaveLocation(EnumDoll.GUARDIAN.getRegistryObject().getId()));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)EnumDoll.BEE.getRegistryObject().get())).func_200472_a("ctc").func_200472_a("sms").func_200472_a("cbc").func_200469_a(Character.valueOf('c'), (ITag)Tags.Items.DYES_YELLOW).func_200469_a(Character.valueOf('s'), (ITag)Tags.Items.DUSTS_GLOWSTONE).func_200469_a(Character.valueOf('t'), (ITag)ItemTags.field_226159_I_).func_200462_a(Character.valueOf('b'), (IItemProvider)EnumResource.BEEHIVE_FRAME.getRegistryObject().get()).func_200462_a(Character.valueOf('m'), (IItemProvider)EnumResource.CRAFTING_DOLL.getRegistryObject().get()).func_200465_a(DOLL_CONDITION, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumResource.CRAFTING_DOLL.getRegistryObject().get()})).func_200467_a(consumer, this.createSaveLocation(EnumDoll.BEE.getRegistryObject().getId()));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)EnumDoll.BLAZE.getRegistryObject().get())).func_200472_a("ctc").func_200472_a("sms").func_200472_a("cbc").func_200462_a(Character.valueOf('c'), (IItemProvider)Items.field_151065_br).func_200469_a(Character.valueOf('s'), (ITag)Tags.Items.DUSTS_GLOWSTONE).func_200469_a(Character.valueOf('t'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('b'), (ITag)Tags.Items.CROPS_NETHER_WART).func_200462_a(Character.valueOf('m'), (IItemProvider)EnumResource.CRAFTING_DOLL.getRegistryObject().get()).func_200465_a(DOLL_CONDITION, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumResource.CRAFTING_DOLL.getRegistryObject().get()})).func_200467_a(consumer, this.createSaveLocation(EnumDoll.BLAZE.getRegistryObject().getId()));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)EnumDoll.ENDERMAN.getRegistryObject().get())).func_200472_a("ctc").func_200472_a("sms").func_200472_a("cbc").func_200469_a(Character.valueOf('c'), (ITag)Tags.Items.DYES_BLACK).func_200469_a(Character.valueOf('s'), (ITag)Tags.Items.DUSTS_GLOWSTONE).func_200469_a(Character.valueOf('t'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('b'), (ITag)Tags.Items.CROPS_NETHER_WART).func_200462_a(Character.valueOf('m'), (IItemProvider)EnumResource.CRAFTING_DOLL.getRegistryObject().get()).func_200465_a(DOLL_CONDITION, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumResource.CRAFTING_DOLL.getRegistryObject().get()})).func_200467_a(consumer, this.createSaveLocation(EnumDoll.ENDERMAN.getRegistryObject().getId()));
    }

    private void registerFluidItemRecipes(Consumer<IFinishedRecipe> consumer) {
        this.createFluidItemRecipes(consumer, water, ((BaseFallingBlock)ExNihiloBlocks.DUST.get()).func_199767_j(), Blocks.field_150435_aG, "clay");
        this.createFluidItemRecipes(consumer, lava, (Tags.IOptionalNamedTag<Item>)Tags.Items.DUSTS_REDSTONE, Blocks.field_150424_aL, NETHERRACK);
        this.createFluidItemRecipes(consumer, lava, (Tags.IOptionalNamedTag<Item>)Tags.Items.DUSTS_GLOWSTONE, Blocks.field_150377_bs, "end_stone");
        this.createFluidItemRecipes(consumer, witchwater, (Tags.IOptionalNamedTag<Item>)Tags.Items.SAND, Blocks.field_150425_aM, "soul_sand");
        this.createFluidItemRecipes(consumer, witchwater, Items.field_221583_k, Blocks.field_235336_cN_, "soul_soil");
        this.createFluidItemRecipes(consumer, witchwater, (Tags.IOptionalNamedTag<Item>)Tags.Items.MUSHROOMS, Blocks.field_180399_cE, "slime");
        this.createFluidItemRecipes(consumer, seawater, (Item)EnumResource.BLUE_CORAL_SEED.getRegistryObject().get(), Blocks.field_203963_jE, "tube_coral");
        this.createFluidItemRecipes(consumer, seawater, (Item)EnumResource.RED_CORAL_SEED.getRegistryObject().get(), Blocks.field_203966_jH, "fire_coral");
        this.createFluidItemRecipes(consumer, seawater, (Item)EnumResource.PINK_CORAL_SEED.getRegistryObject().get(), Blocks.field_203964_jF, "brain_coral");
        this.createFluidItemRecipes(consumer, seawater, (Item)EnumResource.PURPLE_CORAL_SEED.getRegistryObject().get(), Blocks.field_203965_jG, "bubble_coral");
        this.createFluidItemRecipes(consumer, seawater, (Item)EnumResource.YELLOW_CORAL_SEED.getRegistryObject().get(), Blocks.field_203967_jI, "horn_coral");
        this.createFluidItemRecipes(consumer, witchwater, (Item)EnumResource.ANCIENT_SPORE.getRegistryObject().get(), Blocks.field_150420_aW, "brown_mushroom");
        this.createFluidItemRecipes(consumer, witchwater, Blocks.field_150420_aW.func_199767_j(), Blocks.field_150419_aX, "red_mushroom");
    }

    private void registerFluidOnTopRecipes(Consumer<IFinishedRecipe> consumer) {
        this.createFluidOnTopRecipes(consumer, lava, water, Blocks.field_150343_Z, "obsidian");
        this.createFluidOnTopRecipes(consumer, water, lava, Blocks.field_150347_e, COBBLESTONE);
    }

    private void registerFluidTransformRecipes(Consumer<IFinishedRecipe> consumer) {
        this.createFluidTransformRecipes(consumer, water, Blocks.field_150391_bh.func_199767_j(), witchwater, "witch_water");
        this.createFluidTransformRecipes(consumer, water, (ITag.INamedTag<Item>)Tags.Items.SAND, seawater, "sea_water");
    }

    private void registerGoldOres(Consumer<IFinishedRecipe> consumer, EnumOre ore) {
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ExNihiloBlocks.CRUSHED_NETHERRACK.get()})).addResult((IItemProvider)ore.getPieceItem().get())).addRoll(new MeshWithChance(EnumMesh.FLINT, 0.25f)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.25f)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.4f)).build(consumer, this.sieveLoc(ore.getPieceName() + "_crushed_netherrack"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150351_n})).addResult((IItemProvider)ore.getPieceItem().get())).addRoll(new MeshWithChance(EnumMesh.FLINT, 0.05f)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.075f)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.15f)).build(consumer, this.sieveLoc(ore.getPieceName() + GRAVEL_SUFFIX));
    }

    private void registerHammerRecipes(Consumer<IFinishedRecipe> consumer) {
        this.createHammerRecipes(consumer, Blocks.field_150348_b, Blocks.field_150347_e, COBBLESTONE);
        this.createHammerRecipes(consumer, Blocks.field_150347_e, Blocks.field_150351_n, "gravel");
        this.createHammerRecipes(consumer, Blocks.field_150351_n, Blocks.field_150354_m, "sand");
        this.createHammerRecipes(consumer, Blocks.field_150354_m, (Block)ExNihiloBlocks.DUST.get(), "dust");
        this.createHammerRecipes(consumer, Blocks.field_150424_aL, (Block)ExNihiloBlocks.CRUSHED_NETHERRACK.get(), NETHERRACK);
        this.createHammerRecipes(consumer, Blocks.field_196656_g, (Block)ExNihiloBlocks.CRUSHED_ANDESITE.get(), "andesite");
        this.createHammerRecipes(consumer, Blocks.field_196654_e, (Block)ExNihiloBlocks.CRUSHED_DIORITE.get(), "diorite");
        this.createHammerRecipes(consumer, Blocks.field_196650_c, (Block)ExNihiloBlocks.CRUSHED_GRANITE.get(), "granite");
        this.createHammerRecipes(consumer, Blocks.field_150377_bs, (Block)ExNihiloBlocks.CRUSHED_END_STONE.get(), "end_stone");
        this.createHammerRecipes(consumer, Blocks.field_203963_jE, Blocks.field_204278_jJ, "tube_coral");
        this.createHammerRecipes(consumer, Blocks.field_203964_jF, Blocks.field_204279_jK, "brain_coral");
        this.createHammerRecipes(consumer, Blocks.field_203965_jG, Blocks.field_204280_jL, "bubble_coral");
        this.createHammerRecipes(consumer, Blocks.field_203966_jH, Blocks.field_204281_jM, "fire_coral");
        this.createHammerRecipes(consumer, Blocks.field_203967_jI, Blocks.field_204282_jN, "horn_coral");
        this.createHammerRecipes(consumer, Blocks.field_204278_jJ, Blocks.field_204743_jR, "tube_coral_fan");
        this.createHammerRecipes(consumer, Blocks.field_204279_jK, Blocks.field_204744_jS, "brain_coral_fan");
        this.createHammerRecipes(consumer, Blocks.field_204280_jL, Blocks.field_204745_jT, "bubble_coral_fan");
        this.createHammerRecipes(consumer, Blocks.field_204281_jM, Blocks.field_204746_jU, "fire_coral_fan");
        this.createHammerRecipes(consumer, Blocks.field_204282_jN, Blocks.field_204747_jV, "horn_coral_fan");
    }

    private void registerHammers(Consumer<IFinishedRecipe> consumer) {
        SmithingRecipeBuilder.func_240502_a_((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumHammer.DIAMOND.getRegistryObject().get()}), (Ingredient)Ingredient.func_199805_a((ITag)Tags.Items.INGOTS_NETHERITE), (Item)((Item)EnumHammer.NETHERITE.getRegistryObject().get())).func_240503_a_("has_diamond_hammer", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumHammer.DIAMOND.getRegistryObject().get()})).func_240503_a_(MATERIAL_CONDITION, (ICriterionInstance)ExNihiloRecipeGenerator.func_200409_a((ITag)Tags.Items.INGOTS_NETHERITE)).func_240505_a_(consumer, this.createSaveLocation(new ResourceLocation("exnihilosequentia", EnumHammer.NETHERITE.hammerName)));
        this.createHammer((Item)EnumHammer.DIAMOND.getRegistryObject().get(), (ITag.INamedTag<Item>)Tags.Items.GEMS_DIAMOND, consumer);
        this.createHammer((Item)EnumHammer.GOLD.getRegistryObject().get(), (ITag.INamedTag<Item>)Tags.Items.INGOTS_GOLD, consumer);
        this.createHammer((Item)EnumHammer.IRON.getRegistryObject().get(), (ITag.INamedTag<Item>)Tags.Items.INGOTS_IRON, consumer);
        this.createHammer((Item)EnumHammer.STONE.getRegistryObject().get(), (ITag.INamedTag<Item>)Tags.Items.COBBLESTONE, consumer);
        this.createHammer((Item)EnumHammer.WOOD.getRegistryObject().get(), (ITag.INamedTag<Item>)ItemTags.field_199905_b, consumer);
    }

    private void registerHeatRecipes(Consumer<IFinishedRecipe> consumer) {
        this.createHeatRecipes(consumer, Blocks.field_150353_l, 3, "lava");
        this.createHeatRecipes(consumer, Blocks.field_150480_ab, 4, "fire");
        this.createHeatRecipes(consumer, Blocks.field_150478_aa, 1, "torch");
        this.createHeatRecipes(consumer, Blocks.field_196591_bQ, 1, "wall_torch");
        this.createHeatRecipes(consumer, Blocks.field_196814_hQ, 2, "magma_block");
        this.createHeatRecipes(consumer, Blocks.field_150426_aN, 2, "glowstone");
        this.createHeatRecipes(consumer, Blocks.field_235383_mw_, 2, "shroomlight");
        this.createHeatRecipes(consumer, Blocks.field_235335_bO_, 4, "soul_fire");
        StatePropertiesPredicate lit = StatePropertiesPredicate.Builder.func_227191_a_().func_227195_a_((Property)BlockStateProperties.field_208190_q, true).func_227196_b_();
        this.createHeatRecipes(consumer, Blocks.field_222433_lV, 4, lit, "campfire");
        this.createHeatRecipes(consumer, Blocks.field_235367_mf_, 4, lit, "soul_campfire");
        this.createHeatRecipes(consumer, Blocks.field_150460_al, 3, lit, "furnace");
        this.createHeatRecipes(consumer, Blocks.field_150429_aA, 1, lit, "redstone_torch");
        this.createHeatRecipes(consumer, Blocks.field_196677_cy, 1, lit, "redstone_wall_torch");
    }

    private void registerIronOres(Consumer<IFinishedRecipe> consumer, EnumOre ore) {
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150351_n})).addResult((IItemProvider)ore.getPieceItem().get())).addRoll(new MeshWithChance(EnumMesh.FLINT, 0.1f)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.15f)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.25f)).build(consumer, this.sieveLoc(ore.getPieceName() + GRAVEL_SUFFIX));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150354_m})).addResult((IItemProvider)ore.getPieceItem().get())).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.5f)).build(consumer, this.sieveLoc(ore.getPieceName() + "_sand"));
    }

    private void registerMeshes(Consumer<IFinishedRecipe> consumer) {
        this.createMesh((Item)EnumMesh.FLINT.getRegistryObject().get(), (Item)EnumMesh.STRING.getRegistryObject().get(), Items.field_151145_ak, consumer);
        this.createMesh((Item)EnumMesh.IRON.getRegistryObject().get(), (Item)EnumMesh.FLINT.getRegistryObject().get(), (Tags.IOptionalNamedTag<Item>)Tags.Items.INGOTS_IRON, consumer);
        this.createMesh((Item)EnumMesh.DIAMOND.getRegistryObject().get(), (Item)EnumMesh.IRON.getRegistryObject().get(), (Tags.IOptionalNamedTag<Item>)Tags.Items.GEMS_DIAMOND, consumer);
        this.createMesh((Item)EnumMesh.EMERALD.getRegistryObject().get(), (Item)EnumMesh.DIAMOND.getRegistryObject().get(), (Tags.IOptionalNamedTag<Item>)Tags.Items.GEMS_EMERALD, consumer);
        SmithingRecipeBuilder.func_240502_a_((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumMesh.EMERALD.getRegistryObject().get()}), (Ingredient)Ingredient.func_199805_a((ITag)Tags.Items.INGOTS_NETHERITE), (Item)((Item)EnumMesh.NETHERITE.getRegistryObject().get())).func_240503_a_("has_emerald_mesh", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumMesh.EMERALD.getRegistryObject().get()})).func_240503_a_(MATERIAL_CONDITION, (ICriterionInstance)ExNihiloRecipeGenerator.func_200409_a((ITag)Tags.Items.INGOTS_NETHERITE)).func_240505_a_(consumer, this.createSaveLocation(new ResourceLocation("exnihilosequentia", EnumMesh.NETHERITE.getMeshName())));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)EnumMesh.STRING.getRegistryObject().get())).func_200472_a("iii").func_200472_a("iii").func_200472_a("iii").func_200469_a(Character.valueOf('i'), (ITag)Tags.Items.STRING).func_200465_a("has_sieve", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ExNihiloBlocks.SIEVE_OAK.get(), (IItemProvider)ExNihiloBlocks.SIEVE_ACACIA.get(), (IItemProvider)ExNihiloBlocks.SIEVE_BIRCH.get(), (IItemProvider)ExNihiloBlocks.SIEVE_JUNGLE.get(), (IItemProvider)ExNihiloBlocks.SIEVE_DARK_OAK.get(), (IItemProvider)ExNihiloBlocks.SIEVE_SPRUCE.get(), (IItemProvider)ExNihiloBlocks.SIEVE_CRIMSON.get(), (IItemProvider)ExNihiloBlocks.SIEVE_WARPED.get()})).func_200467_a(consumer, this.createSaveLocation(EnumMesh.STRING.getRegistryObject().getId()));
    }

    private void registerMisc(Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_226906_mb_).func_200472_a("xxx").func_200472_a("fff").func_200472_a("xxx").func_200469_a(Character.valueOf('x'), (ITag)ItemTags.field_199905_b).func_200462_a(Character.valueOf('f'), (IItemProvider)EnumResource.BEEHIVE_FRAME.getRegistryObject().get()).func_200465_a("has_frame", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumResource.BEEHIVE_FRAME.getRegistryObject().get()})).func_200467_a(consumer, this.createSaveLocation(Blocks.field_226906_mb_.getRegistryName()));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)EnumResource.BEEHIVE_FRAME.getRegistryObject().get())).func_200472_a("xxx").func_200472_a("xfx").func_200472_a("xxx").func_200469_a(Character.valueOf('x'), (ITag)Tags.Items.RODS_WOODEN).func_200469_a(Character.valueOf('f'), (ITag)Tags.Items.STRING).func_200465_a("has_stick", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.func_200309_a().func_200307_a((ITag)Tags.Items.RODS_WOODEN).func_200310_b()})).func_200465_a("has_string", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.func_200309_a().func_200307_a((ITag)Tags.Items.STRING).func_200310_b()})).func_200467_a(consumer, this.createSaveLocation(EnumResource.BEEHIVE_FRAME.getRegistryObject().getId()));
        this.createCookingRecipe(consumer, (Item)ExNihiloItems.SILKWORM.get(), (Item)ExNihiloItems.COOKED_SILKWORM.get(), 0.1f, 600, 0.1f, 100, "has_silkworm", ExNihiloItems.COOKED_SILKWORM.getId());
        this.createSmeltingRecipe(consumer, (Item)ExNihiloItems.SILKWORM.get(), (Item)ExNihiloItems.COOKED_SILKWORM.get(), 0.1f, 200, 0.1f, 100, "has_silkworm", ExNihiloItems.COOKED_SILKWORM.getId());
        this.createSmeltingRecipe(consumer, ((BaseBlock)ExNihiloBlocks.CRUCIBLE_UNFIRED.get()).func_199767_j(), ((BaseBlock)ExNihiloBlocks.CRUCIBLE_FIRED.get()).func_199767_j(), 0.7f, 200, 0.7f, 100, "has_uncooked_crucible", ExNihiloBlocks.CRUCIBLE_FIRED.getId());
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)ExNihiloBlocks.CRUCIBLE_UNFIRED.get())).func_200472_a("c c").func_200472_a("c c").func_200472_a("ccc").func_200462_a(Character.valueOf('c'), (IItemProvider)EnumResource.PORCELAIN_CLAY.getRegistryObject().get()).func_200465_a(PORCELAIN_CLAY_CONDITION, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumResource.PORCELAIN_CLAY.getRegistryObject().get()})).func_200467_a(consumer, this.createSaveLocation(ExNihiloBlocks.CRUCIBLE_UNFIRED.getId()));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)EnumResource.CRAFTING_DOLL.getRegistryObject().get()), (int)4).func_200472_a("xex").func_200472_a(" x ").func_200472_a("x x").func_200462_a(Character.valueOf('x'), (IItemProvider)EnumResource.PORCELAIN_CLAY.getRegistryObject().get()).func_200469_a(Character.valueOf('e'), (ITag)Tags.Items.GEMS_DIAMOND).func_200465_a(PORCELAIN_CLAY_CONDITION, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumResource.PORCELAIN_CLAY.getRegistryObject().get()})).func_200465_a("has_diamond", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.func_200309_a().func_200307_a((ITag)Tags.Items.GEMS_DIAMOND).func_200310_b()})).func_200467_a(consumer, this.createSaveLocation(new ResourceLocation("exnihilosequentia", "doll_x4")));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)EnumResource.CRAFTING_DOLL.getRegistryObject().get()), (int)6).func_200472_a("xex").func_200472_a(" x ").func_200472_a("x x").func_200462_a(Character.valueOf('x'), (IItemProvider)EnumResource.PORCELAIN_CLAY.getRegistryObject().get()).func_200469_a(Character.valueOf('e'), (ITag)Tags.Items.GEMS_EMERALD).func_200465_a(PORCELAIN_CLAY_CONDITION, (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumResource.PORCELAIN_CLAY.getRegistryObject().get()})).func_200465_a("has_emerald", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.func_200309_a().func_200307_a((ITag)Tags.Items.GEMS_EMERALD).func_200310_b()})).func_200467_a(consumer, this.createSaveLocation(new ResourceLocation("exnihilosequentia", "doll_x6")));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)ExNihiloBlocks.END_CAKE.get())).func_200472_a("ece").func_200472_a("eke").func_200472_a("ece").func_200462_a(Character.valueOf('e'), (IItemProvider)Items.field_151061_bv).func_200462_a(Character.valueOf('c'), (IItemProvider)Items.field_185158_cP).func_200462_a(Character.valueOf('k'), (IItemProvider)Items.field_222070_lD).func_200465_a("has_ender_pearl", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{Items.field_151079_bi})).func_200467_a(consumer, this.createSaveLocation(ExNihiloBlocks.END_CAKE.getId()));
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)EnumResource.PORCELAIN_CLAY.getRegistryObject().get())).func_203221_a(ExNihiloTags.CLAY).func_200487_b((IItemProvider)Items.field_196106_bc).func_200483_a("has_clay", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.func_200309_a().func_200307_a(ExNihiloTags.CLAY).func_200310_b()})).func_200485_a(consumer, this.createSaveLocation(EnumResource.PORCELAIN_CLAY.getRegistryObject().getId()));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_235387_nA_).func_200472_a("xxx").func_200472_a("xgx").func_200472_a("xxx").func_200462_a(Character.valueOf('x'), (IItemProvider)EnumPebbleType.BLACKSTONE.getRegistryObject().get()).func_200462_a(Character.valueOf('g'), (IItemProvider)EnumOre.GOLD.getChunkItem().get()).func_200465_a("has_gold", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)EnumOre.GOLD.getChunkItem().get()})).func_200467_a(consumer, this.createSaveLocation(Blocks.field_235387_nA_.getRegistryName()));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_235399_ni_).func_200472_a(" o ").func_200472_a("obo").func_200472_a(" o ").func_200462_a(Character.valueOf('b'), (IItemProvider)Items.field_151131_as).func_200462_a(Character.valueOf('o'), (IItemProvider)Blocks.field_150343_Z).func_200465_a("has_obsidian", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{Blocks.field_150343_Z})).func_200467_a(consumer, this.createSaveLocation(Blocks.field_235399_ni_.getRegistryName()));
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_235398_nh_).func_200487_b((IItemProvider)Items.field_234760_kn_).func_200487_b((IItemProvider)Blocks.field_150343_Z).func_200483_a("has_scrap", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{Items.field_234760_kn_})).func_200485_a(consumer, this.createSaveLocation(Blocks.field_235398_nh_.getRegistryName()));
    }

    private void registerOres(Consumer<IFinishedRecipe> consumer) {
        for (EnumOre ore : EnumOre.values()) {
            this.registerOre(ore, consumer);
            if (!ore.isVanilla()) {
                this.createSmeltingRecipe(consumer, (Item)ore.getChunkItem().get(), ore.getIngotItem() != null ? ore.getIngotItem() : (Item)ore.getIngotRegistryItem().get(), 0.7f, 200, 0.7f, 100, "has_chunk", new ResourceLocation("exnihilosequentia", ore.getIngotName()));
            }
            if (!ore.isVanilla()) continue;
            if (ore == EnumOre.IRON) {
                this.createSmeltingRecipe(consumer, (Item)ore.getChunkItem().get(), Items.field_151042_j, 0.7f, 200, 0.7f, 100, "has_chunk", new ResourceLocation("minecraft", "ingot_iron"));
            }
            if (ore != EnumOre.GOLD) continue;
            this.createSmeltingRecipe(consumer, (Item)ore.getChunkItem().get(), Items.field_151043_k, 0.7f, 200, 0.7f, 100, "has_chunk", new ResourceLocation("minecraft", "ingot_gold"));
        }
    }

    private void registerPebbleBlocks(Consumer<IFinishedRecipe> consumer) {
        this.createPebbleBlock(Blocks.field_196656_g, (Item)EnumPebbleType.ANDESITE.getRegistryObject().get(), consumer);
        this.createPebbleBlock(Blocks.field_150347_e, (Item)EnumPebbleType.STONE.getRegistryObject().get(), consumer);
        this.createPebbleBlock(Blocks.field_196654_e, (Item)EnumPebbleType.DIORITE.getRegistryObject().get(), consumer);
        this.createPebbleBlock(Blocks.field_196650_c, (Item)EnumPebbleType.GRANITE.getRegistryObject().get(), consumer);
        this.createPebbleBlock(Blocks.field_235337_cO_, (Item)EnumPebbleType.BASALT.getRegistryObject().get(), consumer);
        this.createPebbleBlock(Blocks.field_235406_np_, (Item)EnumPebbleType.BLACKSTONE.getRegistryObject().get(), consumer);
    }

    private void registerSieves(Consumer<IFinishedRecipe> consumer) {
        this.createSieve(consumer, ExNihiloBlocks.SIEVE_ACACIA, Items.field_221590_r, Items.field_221708_bp);
        this.createSieve(consumer, ExNihiloBlocks.SIEVE_BIRCH, Items.field_221588_p, Items.field_221704_bn);
        this.createSieve(consumer, ExNihiloBlocks.SIEVE_DARK_OAK, Items.field_221591_s, Items.field_221710_bq);
        this.createSieve(consumer, ExNihiloBlocks.SIEVE_JUNGLE, Items.field_221589_q, Items.field_221706_bo);
        this.createSieve(consumer, ExNihiloBlocks.SIEVE_OAK, Items.field_221586_n, Items.field_221700_bl);
        this.createSieve(consumer, ExNihiloBlocks.SIEVE_SPRUCE, Items.field_221587_o, Items.field_221702_bm);
        this.createSieve(consumer, ExNihiloBlocks.SIEVE_CRIMSON, Items.field_234798_v_, Items.field_234720_bO_);
        this.createSieve(consumer, ExNihiloBlocks.SIEVE_WARPED, Items.field_234799_w_, Items.field_234721_bP_);
    }

    private void registerSieveRecipes(Consumer<IFinishedRecipe> consumer) {
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150346_d})).addResult((IItemProvider)EnumPebbleType.STONE.getRegistryObject().get())).addRoll(new MeshWithChance(EnumMesh.STRING, 1.0f)).addRoll(new MeshWithChance(EnumMesh.STRING, 1.0f)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.5f)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.5f)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.1f)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.1f)).build(consumer, this.sieveLoc("pebble_stone"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150346_d})).addResult((IItemProvider)EnumPebbleType.ANDESITE.getRegistryObject().get())).addRoll(new MeshWithChance(EnumMesh.STRING, 0.5f)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.1f)).build(consumer, this.sieveLoc("pebble_andesite"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150346_d})).addResult((IItemProvider)EnumPebbleType.DIORITE.getRegistryObject().get())).addRoll(new MeshWithChance(EnumMesh.STRING, 0.5f)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.1f)).build(consumer, this.sieveLoc("pebble_diorite"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150346_d})).addResult((IItemProvider)EnumPebbleType.GRANITE.getRegistryObject().get())).addRoll(new MeshWithChance(EnumMesh.STRING, 0.5f)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.1f)).build(consumer, this.sieveLoc("pebble_granite"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150346_d})).addResult((IItemProvider)EnumPebbleType.BASALT.getRegistryObject().get())).addRoll(new MeshWithChance(EnumMesh.STRING, 0.5f)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.1f)).build(consumer, this.sieveLoc("pebble_basalt"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150346_d})).addResult((IItemProvider)EnumPebbleType.BLACKSTONE.getRegistryObject().get())).addRoll(new MeshWithChance(EnumMesh.STRING, 0.5f)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.1f)).build(consumer, this.sieveLoc("pebble_blackstone"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150346_d})).addResult((IItemProvider)Items.field_151014_N)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.7f)).build(consumer, this.sieveLoc("seed_wheat"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150346_d})).addResult((IItemProvider)Items.field_151081_bc)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.35f)).build(consumer, this.sieveLoc("seed_melon"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150346_d})).addResult((IItemProvider)Items.field_151080_bb)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.35f)).build(consumer, this.sieveLoc("seed_pumpkin"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150346_d})).addResult((IItemProvider)Items.field_185163_cU)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.35f)).build(consumer, this.sieveLoc("seed_beetroot"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150346_d})).addResult((IItemProvider)EnumResource.ANCIENT_SPORE.getRegistryObject().get())).addRoll(new MeshWithChance(EnumMesh.STRING, 0.05f)).build(consumer, this.sieveLoc("ancient_spore"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150346_d})).addResult((IItemProvider)EnumResource.GRASS_SEED.getRegistryObject().get())).addRoll(new MeshWithChance(EnumMesh.STRING, 0.05f)).build(consumer, this.sieveLoc("seed_grass"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150354_m})).addResult((IItemProvider)Items.field_196130_bo)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.03f)).build(consumer, this.sieveLoc("cocoa_beans"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150354_m})).addResult((IItemProvider)Items.field_179562_cC)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.02f)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.04f)).build(consumer, this.sieveLoc("prismarine_shard"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150354_m})).addResult((IItemProvider)Items.field_179563_cD)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.01f)).build(consumer, this.sieveLoc("prismarine_crystals"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150351_n})).addResult((IItemProvider)Items.field_151145_ak)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.25f)).addRoll(new MeshWithChance(EnumMesh.FLINT, 0.25f)).build(consumer, this.sieveLoc("flint"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150351_n})).addResult((IItemProvider)Items.field_151044_h)).addRoll(new MeshWithChance(EnumMesh.FLINT, 0.125f)).build(consumer, this.sieveLoc("coal"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150351_n})).addResult((IItemProvider)Items.field_196128_bn)).addRoll(new MeshWithChance(EnumMesh.FLINT, 0.05f)).build(consumer, this.sieveLoc("lapis_lazuli"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150351_n})).addResult((IItemProvider)Items.field_151045_i)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.008f)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.016f)).build(consumer, this.sieveLoc("diamond"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ExNihiloBlocks.CRUSHED_NETHERRACK.get()})).addResult((IItemProvider)Items.field_234760_kn_)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.004f)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.008f)).build(consumer, this.sieveLoc("netherite_scrap"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150351_n})).addResult((IItemProvider)Items.field_151166_bC)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.008f)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.016f)).build(consumer, this.sieveLoc("emerald"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150425_aM})).addResult((IItemProvider)Items.field_151128_bU)).addRoll(new MeshWithChance(EnumMesh.FLINT, 1.0f)).addRoll(new MeshWithChance(EnumMesh.FLINT, 0.33f)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 1.0f)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.8f)).build(consumer, this.sieveLoc("quartz"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150425_aM})).addResult((IItemProvider)Items.field_151075_bm)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.1f)).build(consumer, this.sieveLoc("nether_wart"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150425_aM})).addResult((IItemProvider)Items.field_151073_bk)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.02f)).build(consumer, this.sieveLoc("ghast_tear"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ExNihiloBlocks.DUST.get()})).addResult((IItemProvider)Items.field_196106_bc)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.2f)).build(consumer, this.sieveLoc("bone_meal"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ExNihiloBlocks.DUST.get()})).addResult((IItemProvider)Items.field_151016_H)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.07f)).build(consumer, this.sieveLoc("gunpowder"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ExNihiloBlocks.DUST.get()})).addResult((IItemProvider)Items.field_151137_ax)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.125f)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.25f)).build(consumer, this.sieveLoc("redstone"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ExNihiloBlocks.DUST.get()})).addResult((IItemProvider)Items.field_151114_aO)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.0625f)).build(consumer, this.sieveLoc("glowstone"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ExNihiloBlocks.DUST.get()})).addResult((IItemProvider)Items.field_151065_br)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.05f)).build(consumer, this.sieveLoc("blaze_powder"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ExNihiloBlocks.CRUSHED_END_STONE.get()})).addResult((IItemProvider)Items.field_151079_bi)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.005f)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.01f)).addRoll(new MeshWithChance(EnumMesh.EMERALD, 0.015f)).addRoll(new MeshWithChance(EnumMesh.NETHERITE, 0.02f)).build(consumer, this.sieveLoc("ender_pearl"));
        block4: for (EnumOre enumOre : EnumOre.values()) {
            switch (enumOre) {
                case IRON: {
                    this.registerIronOres(consumer, enumOre);
                    continue block4;
                }
                case GOLD: {
                    this.registerGoldOres(consumer, enumOre);
                    continue block4;
                }
                default: {
                    this.registerDefaultOres(consumer, enumOre);
                }
            }
        }
        for (Enum enum_ : EnumSeed.values()) {
            if (enum_ != EnumSeed.SEED_PICKLE && enum_ != EnumSeed.SEED_KELP) {
                ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150346_d})).addResult((IItemProvider)((EnumSeed)enum_).getRegistryObject().get())).addRoll(new MeshWithChance(EnumMesh.STRING, 0.05f)).build(consumer, this.sieveLoc(((EnumSeed)enum_).getSeedName()));
                continue;
            }
            ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150354_m})).addResult((IItemProvider)((EnumSeed)enum_).getRegistryObject().get())).addRoll(new MeshWithChance(EnumMesh.STRING, 0.05f)).isWaterlogged().build(consumer, this.sieveLoc(((EnumSeed)enum_).getSeedName()));
        }
        this.getLeavesSaplings().forEach((input, drop) -> {
            if (Objects.equals(input.getRegistryName(), new ResourceLocation("jungle_leaves"))) {
                ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input})).addResult((IItemProvider)drop)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.025f)).addRoll(new MeshWithChance(EnumMesh.FLINT, 0.05f)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.075f)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.1f)).build(consumer, this.sieveLoc(input.getRegistryName().func_110623_a()));
            } else {
                ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input})).addResult((IItemProvider)drop)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.05f)).addRoll(new MeshWithChance(EnumMesh.FLINT, 0.1f)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.15f)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.2f)).build(consumer, this.sieveLoc(input.getRegistryName().func_110623_a()));
            }
        });
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199805_a((ITag)ItemTags.field_206963_E)).addResult((IItemProvider)Items.field_151034_e)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.05f)).addRoll(new MeshWithChance(EnumMesh.FLINT, 0.1f)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.15f)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.2f)).build(consumer, this.sieveLoc("apple"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199805_a((ITag)ItemTags.field_206963_E)).addResult((IItemProvider)Items.field_151153_ao)).addRoll(new MeshWithChance(EnumMesh.STRING, 0.001f)).addRoll(new MeshWithChance(EnumMesh.FLINT, 0.003f)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.005f)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.01f)).build(consumer, this.sieveLoc("golden_apple"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199805_a((ITag)ItemTags.field_206963_E)).addResult((IItemProvider)ExNihiloItems.SILKWORM.get())).addRoll(new MeshWithChance(EnumMesh.STRING, 0.025f)).addRoll(new MeshWithChance(EnumMesh.FLINT, 0.05f)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.1f)).addRoll(new MeshWithChance(EnumMesh.DIAMOND, 0.2f)).build(consumer, this.sieveLoc("silkworm"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199805_a((ITag)ItemTags.field_203440_u)).addResult((IItemProvider)EnumResource.BLUE_CORAL_SEED.getRegistryObject().get())).addRoll(new MeshWithChance(EnumMesh.IRON, 0.05f)).isWaterlogged().build(consumer, this.sieveLoc("seed_blue_coral"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199805_a((ITag)ItemTags.field_203440_u)).addResult((IItemProvider)EnumResource.PURPLE_CORAL_SEED.getRegistryObject().get())).addRoll(new MeshWithChance(EnumMesh.IRON, 0.05f)).isWaterlogged().build(consumer, this.sieveLoc("seed_purple_coral"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199805_a((ITag)ItemTags.field_203440_u)).addResult((IItemProvider)EnumResource.PINK_CORAL_SEED.getRegistryObject().get())).addRoll(new MeshWithChance(EnumMesh.IRON, 0.05f)).isWaterlogged().build(consumer, this.sieveLoc("seed_pink_coral"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199805_a((ITag)ItemTags.field_203440_u)).addResult((IItemProvider)EnumResource.YELLOW_CORAL_SEED.getRegistryObject().get())).addRoll(new MeshWithChance(EnumMesh.IRON, 0.05f)).isWaterlogged().build(consumer, this.sieveLoc("seed_yellow_coral"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199805_a((ITag)ItemTags.field_203440_u)).addResult((IItemProvider)EnumResource.RED_CORAL_SEED.getRegistryObject().get())).addRoll(new MeshWithChance(EnumMesh.IRON, 0.05f)).isWaterlogged().build(consumer, this.sieveLoc("seed_red_coral"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150354_m})).addResult((IItemProvider)Items.field_221600_aB)).addRoll(new MeshWithChance(EnumMesh.IRON, 0.05f)).isWaterlogged().build(consumer, this.sieveLoc("seagrass"));
    }
}

