/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.item.ore;

import java.util.Arrays;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IExtensibleEnum;
import net.minecraftforge.fml.RegistryObject;
import novamachina.exnihilosequentia.common.item.ore.OreItem;
import novamachina.exnihilosequentia.common.network.HandshakeMessages;
import novamachina.exnihilosequentia.common.utility.Color;

public enum EnumOre implements IExtensibleEnum
{
    COPPER(Type.MODDED, "copper", new Color("FF9933"), false, true),
    LEAD(Type.MODDED, "lead", new Color("330066"), false, true),
    NICKEL(Type.MODDED, "nickel", new Color("FFFFCC"), false, true),
    SILVER(Type.MODDED, "silver", new Color("C2FAFF"), false, true),
    TIN(Type.MODDED, "tin", new Color("F5FEFF"), false, true),
    ALUMINUM(Type.MODDED, "aluminum", new Color("BFBFBF"), false, true),
    PLATINUM(Type.MODDED, "platinum", new Color("00FFF7"), false, true),
    URANIUM(Type.MODDED, "uranium", new Color("4E5B43"), false, true),
    ZINC(Type.MODDED, "zinc", new Color("A59C74"), false, true),
    IRON(Type.VANILLA, "iron", new Color("BF8040"), true, false),
    GOLD(Type.VANILLA, "gold", new Color("FFFF00"), true, false);

    private final Color color;
    private final String oreName;
    private RegistryObject<OreItem> chunkItem;
    private final boolean generateIngot;
    private Item ingotItem;
    private RegistryObject<OreItem> ingotRegistryItem;
    private boolean isEnabled;
    private RegistryObject<OreItem> pieceItem;
    private final Type type;

    private EnumOre(Type type, String oreName, Color color, boolean isEnabled, boolean generateIngot) {
        this.type = type;
        this.oreName = oreName;
        this.color = color;
        this.isEnabled = isEnabled;
        this.generateIngot = generateIngot;
    }

    public static EnumOre create(String enumName, Type type, String oreName, Color color, boolean isEnabled, boolean generateIngot) {
        throw new IllegalStateException("Enum not extended");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean updateEnabledOres(HandshakeMessages.S2COreList message) {
        List<EnumOre> oreList = message.getOreList();
        Arrays.stream(EnumOre.values()).forEach(EnumOre::disable);
        if (oreList != null) {
            for (EnumOre ore : oreList) {
                EnumOre.valueOf(ore.name()).setEnabled(true);
            }
            return true;
        }
        return false;
    }

    public RegistryObject<OreItem> getChunkItem() {
        return this.chunkItem;
    }

    public void setChunkItem(RegistryObject<OreItem> chunkItem) {
        this.chunkItem = chunkItem;
    }

    public String getChunkName() {
        return "chunk_" + this.oreName;
    }

    public Color getColor() {
        return this.color;
    }

    public Item getIngotItem() {
        return this.ingotItem;
    }

    public void setIngotItem(Item ingotItem) {
        this.ingotItem = ingotItem;
    }

    public String getIngotName() {
        return "ingot_" + this.oreName;
    }

    public RegistryObject<OreItem> getIngotRegistryItem() {
        return this.ingotRegistryItem;
    }

    public void setIngotRegistryItem(RegistryObject<OreItem> ingotRegistryItem) {
        this.ingotRegistryItem = ingotRegistryItem;
    }

    public String getOreName() {
        return this.oreName;
    }

    public RegistryObject<OreItem> getPieceItem() {
        return this.pieceItem;
    }

    public void setPieceItem(RegistryObject<OreItem> pieceItem) {
        this.pieceItem = pieceItem;
    }

    public String getPieceName() {
        return "piece_" + this.oreName;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public boolean isVanilla() {
        return this.type == Type.VANILLA;
    }

    public boolean shouldGenerateIngot() {
        return this.generateIngot;
    }

    public String toString() {
        return "EnumOre{name='" + this.oreName + '\'' + ", color=" + this.color + ", isEnabled=" + this.isEnabled + ", type=" + (Object)((Object)this.type) + '}';
    }

    private void disable() {
        this.isEnabled = false;
    }

    public static enum Type {
        VANILLA,
        MODDED;

    }
}

