/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.loot.modifier;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import novamachina.exnihilosequentia.api.ExNihiloRegistries;
import novamachina.exnihilosequentia.api.ExNihiloTags;
import novamachina.exnihilosequentia.api.crafting.ItemStackWithChance;
import novamachina.exnihilosequentia.api.crafting.crook.CrookRecipe;
import novamachina.exnihilosequentia.common.block.InfestedLeavesBlock;
import novamachina.exnihilosequentia.common.init.ExNihiloItems;
import novamachina.exnihilosequentia.common.utility.Config;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import org.apache.logging.log4j.LogManager;

public class UseCrookModifier
extends LootModifier {
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogManager.getLogger());
    private final Random random = new Random();

    public UseCrookModifier(ILootCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        logger.debug("Fired Crook Modifier");
        ItemStack tool = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
        BlockState blockState = (BlockState)context.func_216031_c(LootParameters.field_216287_g);
        BlockPos pos = new BlockPos(((Vector3d)context.func_216031_c(LootParameters.field_237457_g_)).func_82615_a(), ((Vector3d)context.func_216031_c(LootParameters.field_237457_g_)).func_82617_b(), ((Vector3d)context.func_216031_c(LootParameters.field_237457_g_)).func_82616_c());
        ArrayList<ItemStack> newLoot = new ArrayList<ItemStack>();
        if (tool != null && blockState != null && ExNihiloTags.CROOK.func_230235_a_((Object)tool.func_77973_b()) && ExNihiloRegistries.CROOK_REGISTRY.isCrookable((IItemProvider)blockState.func_177230_c())) {
            for (int i = 0; i < Config.getVanillaSimulateDropCount(); ++i) {
                List items = Block.func_220070_a((BlockState)blockState, (ServerWorld)context.func_202879_g().func_73046_m().func_71218_a(context.func_202879_g().func_234923_W_()), (BlockPos)pos, null);
                newLoot.addAll(items.stream().filter(drop -> !drop.func_77973_b().getRegistryName().equals((Object)blockState.func_177230_c().getRegistryName())).collect(Collectors.toList()));
            }
            for (CrookRecipe recipe : ExNihiloRegistries.CROOK_REGISTRY.getDrops((IItemProvider)blockState.func_177230_c())) {
                for (ItemStackWithChance itemStackWithChance : recipe.getOutput()) {
                    if (!(this.random.nextFloat() <= itemStackWithChance.getChance()) || itemStackWithChance.getStack() == ItemStack.field_190927_a) continue;
                    newLoot.add(itemStackWithChance.getStack());
                }
            }
            if (blockState.func_177230_c() instanceof InfestedLeavesBlock) {
                newLoot.add(new ItemStack((IItemProvider)Items.field_151007_F, this.random.nextInt(Config.getMaxBonusStringCount()) + Config.getMinStringCount()));
                if (this.random.nextDouble() <= 0.8) {
                    newLoot.add(new ItemStack((IItemProvider)ExNihiloItems.SILKWORM.get()));
                }
            }
        }
        if (!newLoot.isEmpty()) {
            logger.debug("Adding new loot");
            generatedLoot = newLoot;
        }
        logger.debug("Crook Generated Loot: " + generatedLoot);
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<UseCrookModifier> {
        public UseCrookModifier read(ResourceLocation location, JsonObject object, ILootCondition[] ailootcondition) {
            return new UseCrookModifier(ailootcondition);
        }

        public JsonObject write(UseCrookModifier instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

