/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.network;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import novamachina.exnihilosequentia.common.item.ore.EnumOre;
import novamachina.exnihilosequentia.common.network.HandshakeMessages;
import novamachina.exnihilosequentia.common.network.PacketHandler;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import org.apache.logging.log4j.LogManager;

public class HandshakeHandler {
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogManager.getLogger());

    private HandshakeHandler() {
    }

    public static void handleAcknowledge(HandshakeMessages.C2SAcknowledge message, Supplier<NetworkEvent.Context> ctx) {
        logger.debug("Received acknowledgement from client. " + message);
        ctx.get().setPacketHandled(true);
    }

    public static void handleOreList(HandshakeMessages.S2COreList msg, Supplier<NetworkEvent.Context> ctx) throws InterruptedException {
        logger.debug("Recieved ore data from server");
        AtomicBoolean updatedOreList = new AtomicBoolean(false);
        CountDownLatch block = new CountDownLatch(1);
        ctx.get().enqueueWork(() -> {
            updatedOreList.set(true);
            if (!EnumOre.updateEnabledOres(msg)) {
                updatedOreList.set(false);
            }
            block.countDown();
        });
        try {
            block.await();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            logger.error(e.getMessage());
            throw e;
        }
        ctx.get().setPacketHandled(true);
        if (updatedOreList.get()) {
            logger.debug("Successfully synchronized ore list from server.");
            PacketHandler.getHandshakeChannel().reply((Object)new HandshakeMessages.C2SAcknowledge(), ctx.get());
        } else {
            logger.debug("Failed to synchronize ore list from server.");
            ctx.get().getNetworkManager().func_150718_a((ITextComponent)new StringTextComponent("Connection closed - [Ex Nihilo: Sequentia] Failed to synchronize ore list from server."));
        }
    }
}

