/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.registries;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import novamachina.exnihilosequentia.api.crafting.crook.CrookRecipe;
import novamachina.exnihilosequentia.api.registry.ICrookRegistry;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import org.apache.logging.log4j.LogManager;

public class CrookRegistry
implements ICrookRegistry {
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogManager.getLogger());
    private List<CrookRecipe> recipeList = new ArrayList<CrookRecipe>();

    @Override
    public boolean isCrookable(IItemProvider block) {
        for (CrookRecipe recipe : this.recipeList) {
            if (!recipe.getInput().test(new ItemStack(block))) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<CrookRecipe> getDrops(IItemProvider block) {
        ArrayList<CrookRecipe> returnList = new ArrayList<CrookRecipe>();
        for (CrookRecipe recipe : this.recipeList) {
            if (!recipe.getInput().test(new ItemStack(block))) continue;
            returnList.add(recipe);
        }
        return returnList;
    }

    @Override
    public void setRecipes(List<CrookRecipe> recipes) {
        logger.debug("Crook Registry recipes: " + recipes.size());
        this.recipeList.addAll(recipes);
    }

    @Override
    public List<CrookRecipe> getRecipeList() {
        ArrayList<CrookRecipe> recipes = new ArrayList<CrookRecipe>();
        for (CrookRecipe recipe : this.recipeList) {
            if (recipe.getOutput().size() > 21) {
                List partitions = Lists.partition(recipe.getOutput(), (int)21);
                for (int i = 0; i < partitions.size(); ++i) {
                    ResourceLocation newId = new ResourceLocation(recipe.func_199560_c().func_110624_b(), recipe.func_199560_c().func_110623_a() + i);
                    recipes.add(new CrookRecipe(newId, recipe.getInput(), (List)partitions.get(i)));
                }
                continue;
            }
            recipes.add(recipe);
        }
        return recipes;
    }

    @Override
    public void clearRecipes() {
        this.recipeList.clear();
    }
}

