/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.registries;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import novamachina.exnihilosequentia.api.crafting.crucible.CrucibleRecipe;
import novamachina.exnihilosequentia.api.registry.ICrucibleRegistry;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import org.apache.logging.log4j.LogManager;

public class CrucibleRegistry
implements ICrucibleRegistry {
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogManager.getLogger());
    private final List<CrucibleRecipe> recipeList = new ArrayList<CrucibleRecipe>();

    @Override
    public List<CrucibleRecipe> getRecipeList() {
        return this.recipeList;
    }

    @Override
    public void setRecipes(List<CrucibleRecipe> recipes) {
        logger.debug("Crucible Registry recipes: " + recipes.size());
        this.recipeList.addAll(recipes);
    }

    @Override
    public CrucibleRecipe findRecipe(IItemProvider item) {
        Optional<CrucibleRecipe> optional = this.recipeList.stream().filter(recipe -> recipe.getInput().test(new ItemStack(item))).findFirst();
        return optional.orElse(null);
    }

    @Override
    public boolean isMeltable(IItemProvider item, int level) {
        ItemStack itemStack = new ItemStack(item);
        boolean result = false;
        for (CrucibleRecipe recipe : this.recipeList) {
            if (!recipe.getInput().test(itemStack) || recipe.getCrucibleType().getLevel() > level) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public void clearRecipes() {
        this.recipeList.clear();
    }
}

