/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.registries;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import novamachina.exnihilosequentia.api.crafting.fluiditem.FluidItemRecipe;
import novamachina.exnihilosequentia.api.registry.IFluidItemTransformRegistry;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import org.apache.logging.log4j.LogManager;

public class FluidItemTransformRegistry
implements IFluidItemTransformRegistry {
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogManager.getLogger());
    private final List<FluidItemRecipe> recipeList = new ArrayList<FluidItemRecipe>();

    @Override
    public boolean isValidRecipe(Fluid fluid, Item input) {
        for (FluidItemRecipe recipe : this.recipeList) {
            if (!recipe.validInputs(fluid, input)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IItemProvider getResult(Fluid fluid, Item input) {
        for (FluidItemRecipe recipe : this.recipeList) {
            if (!recipe.validInputs(fluid, input)) continue;
            return recipe.func_77571_b().func_77973_b();
        }
        return ItemStack.field_190927_a.func_77973_b();
    }

    @Override
    public List<FluidItemRecipe> getRecipeList() {
        return this.recipeList;
    }

    @Override
    public void setRecipes(List<FluidItemRecipe> recipes) {
        logger.debug("Fluid Item Transform Registry recipes: " + recipes.size());
        this.recipeList.addAll(recipes);
    }

    @Override
    public void clearRecipes() {
        this.recipeList.clear();
    }
}

