/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.registries;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fluids.FluidStack;
import novamachina.exnihilosequentia.api.crafting.fluidtransform.FluidTransformRecipe;
import novamachina.exnihilosequentia.api.registry.IFluidTransformRegistry;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import org.apache.logging.log4j.LogManager;

public class FluidTransformRegistry
implements IFluidTransformRegistry {
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogManager.getLogger());
    private final List<FluidTransformRecipe> recipeList = new ArrayList<FluidTransformRecipe>();

    @Override
    public boolean isValidRecipe(Fluid fluidInTank, IItemProvider catalyst) {
        for (FluidTransformRecipe recipe : this.recipeList) {
            if (!recipe.getFluidInTank().isFluidEqual(new FluidStack(fluidInTank, 1000)) || !recipe.getCatalyst().test(new ItemStack(catalyst))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Fluid getResult(Fluid fluidInTank, IItemProvider catalyst) {
        for (FluidTransformRecipe recipe : this.recipeList) {
            if (!recipe.getFluidInTank().isFluidEqual(new FluidStack(fluidInTank, 1000)) || !recipe.getCatalyst().test(new ItemStack(catalyst))) continue;
            return recipe.getResult().getFluid();
        }
        return Fluids.field_204541_a;
    }

    @Override
    public List<FluidTransformRecipe> getRecipeList() {
        return this.recipeList;
    }

    @Override
    public void setRecipes(List<FluidTransformRecipe> recipes) {
        logger.debug("Fluid Transform Registry recipes: " + recipes.size());
        this.recipeList.addAll(recipes);
    }

    @Override
    public void clearRecipes() {
        this.recipeList.clear();
    }
}

