/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.registries;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import novamachina.exnihilosequentia.api.compat.jei.JEISieveRecipe;
import novamachina.exnihilosequentia.api.crafting.sieve.MeshWithChance;
import novamachina.exnihilosequentia.api.crafting.sieve.SieveRecipe;
import novamachina.exnihilosequentia.api.registry.ISieveRegistry;
import novamachina.exnihilosequentia.common.item.mesh.EnumMesh;
import novamachina.exnihilosequentia.common.item.ore.OreItem;
import novamachina.exnihilosequentia.common.utility.Config;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import novamachina.exnihilosequentia.common.utility.IngredientUtils;
import org.apache.logging.log4j.LogManager;

public class SieveRegistry
implements ISieveRegistry {
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogManager.getLogger());
    private final boolean flattenRecipes = Config.flattenSieveRecipes();
    private List<SieveRecipe> recipeList = new ArrayList<SieveRecipe>();

    private List<SieveRecipe> getDrops(Ingredient input, EnumMesh meshType, boolean isWaterlogged) {
        return this.recipeList.parallelStream().filter(sieveRecipe -> sieveRecipe.isWaterlogged() == isWaterlogged).filter(sieveRecipe -> IngredientUtils.areIngredientsEqual(sieveRecipe.getInput(), input)).map(recipe -> recipe.filterByMesh(meshType, this.flattenRecipes)).filter(recipe -> {
            OreItem ore;
            return !(recipe.getDrop().func_77973_b() instanceof OreItem) || (ore = (OreItem)recipe.getDrop().func_77973_b()).getOre().isEnabled();
        }).filter(recipe -> !recipe.getRolls().isEmpty()).collect(Collectors.toList());
    }

    @Override
    public List<SieveRecipe> getDrops(IItemProvider input, EnumMesh meshType, boolean isWaterlogged) {
        return this.recipeList.parallelStream().filter(sieveRecipe -> sieveRecipe.isWaterlogged() == isWaterlogged).filter(sieveRecipe -> sieveRecipe.getInput().test(new ItemStack(input))).map(recipe -> recipe.filterByMesh(meshType, this.flattenRecipes)).filter(recipe -> {
            OreItem ore;
            return !(recipe.getDrop().func_77973_b() instanceof OreItem) || (ore = (OreItem)recipe.getDrop().func_77973_b()).getOre().isEnabled();
        }).filter(recipe -> !recipe.getRolls().isEmpty()).collect(Collectors.toList());
    }

    @Override
    public boolean isBlockSiftable(Block block, EnumMesh mesh, boolean isWaterlogged) {
        return this.recipeList.parallelStream().anyMatch(sieveRecipe -> {
            if (sieveRecipe.getInput().test(new ItemStack((IItemProvider)block)) && sieveRecipe.isWaterlogged() == isWaterlogged) {
                for (MeshWithChance meshWithChance : sieveRecipe.getRolls()) {
                    if (!(this.flattenRecipes ? meshWithChance.getMesh().getId() <= mesh.getId() : meshWithChance.getMesh().getId() == mesh.getId())) continue;
                    return true;
                }
            }
            return false;
        });
    }

    @Override
    public List<JEISieveRecipe> getDryRecipeList() {
        ArrayList<JEISieveRecipe> returnList = new ArrayList<JEISieveRecipe>();
        HashSet<Ingredient> inputs = new HashSet<Ingredient>();
        for (SieveRecipe recipe : this.recipeList) {
            boolean insert = true;
            for (Ingredient ingredient : inputs) {
                if (!IngredientUtils.areIngredientsEqual(ingredient, recipe.getInput())) continue;
                insert = false;
                break;
            }
            if (!insert) continue;
            inputs.add(recipe.getInput());
        }
        for (EnumMesh mesh : EnumMesh.values()) {
            if (mesh == EnumMesh.NONE) continue;
            for (Ingredient ingredient : inputs) {
                List<SieveRecipe> drops = this.getDrops(ingredient, mesh, false);
                List dropLists = Lists.partition(drops, (int)21);
                if (drops.isEmpty()) continue;
                ArrayList<List<ItemStack>> inputList = new ArrayList<List<ItemStack>>();
                inputList.add(Collections.singletonList(new ItemStack((IItemProvider)mesh.getRegistryObject().get())));
                inputList.add(Arrays.asList(ingredient.func_193365_a()));
                for (List dropList : dropLists) {
                    returnList.add(new JEISieveRecipe(inputList, dropList));
                }
            }
        }
        return returnList;
    }

    @Override
    public List<JEISieveRecipe> getWetRecipeList() {
        ArrayList<JEISieveRecipe> returnList = new ArrayList<JEISieveRecipe>();
        HashSet<Ingredient> inputs = new HashSet<Ingredient>();
        for (SieveRecipe recipe : this.recipeList) {
            boolean insert = true;
            for (Ingredient ingredient : inputs) {
                if (!IngredientUtils.areIngredientsEqual(ingredient, recipe.getInput())) continue;
                insert = false;
                break;
            }
            if (!insert) continue;
            inputs.add(recipe.getInput());
        }
        for (EnumMesh mesh : EnumMesh.values()) {
            if (mesh == EnumMesh.NONE) continue;
            for (Ingredient ingredient : inputs) {
                List<SieveRecipe> drops = this.getDrops(ingredient, mesh, true);
                List dropLists = Lists.partition(drops, (int)21);
                if (drops.isEmpty()) continue;
                ArrayList<List<ItemStack>> inputList = new ArrayList<List<ItemStack>>();
                inputList.add(Collections.singletonList(new ItemStack((IItemProvider)mesh.getRegistryObject().get())));
                inputList.add(Arrays.asList(ingredient.func_193365_a()));
                for (List dropList : dropLists) {
                    returnList.add(new JEISieveRecipe(inputList, dropList));
                }
            }
        }
        return returnList;
    }

    @Override
    public void setRecipes(List<SieveRecipe> recipes) {
        logger.debug("Sieve Registry recipes: " + recipes.size());
        this.recipeList.addAll(recipes);
    }

    @Override
    public void clearRecipes() {
        this.recipeList.clear();
    }
}

