/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.tileentity;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import novamachina.exnihilosequentia.api.ExNihiloRegistries;
import novamachina.exnihilosequentia.api.crafting.sieve.SieveRecipe;
import novamachina.exnihilosequentia.common.block.BlockSieve;
import novamachina.exnihilosequentia.common.init.ExNihiloTiles;
import novamachina.exnihilosequentia.common.item.mesh.EnumMesh;
import novamachina.exnihilosequentia.common.item.mesh.MeshItem;
import novamachina.exnihilosequentia.common.utility.Config;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import org.apache.logging.log4j.LogManager;

public class SieveTile
extends TileEntity {
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogManager.getLogger());
    private static final String BLOCK_TAG = "block";
    private static final String PROGRESS_TAG = "progress";
    private static final String MESH_TAG = "mesh";
    private final Random random = new Random();
    private ItemStack meshStack = ItemStack.field_190927_a;
    private ItemStack blockStack = ItemStack.field_190927_a;
    private EnumMesh meshType = EnumMesh.NONE;
    private int progress = 0;
    private long lastSieveAction = 0L;
    private UUID lastPlayer;

    public SieveTile() {
        super((TileEntityType)ExNihiloTiles.SIEVE.get());
    }

    public void insertMesh(ItemStack stack, PlayerEntity player) {
        logger.debug("Insert Mesh: " + stack);
        EnumMesh mesh = ((MeshItem)stack.func_77973_b()).getMesh();
        if (this.meshStack.func_190926_b()) {
            this.meshStack = stack.func_77946_l();
            this.meshStack.func_190920_e(1);
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            this.meshType = mesh;
            if (!this.func_145837_r()) {
                this.setSieveState();
            }
            this.func_70296_d();
        }
    }

    public void removeMesh(boolean rerenderSieve) {
        logger.debug("Remove mesh: Rerender Sieve: " + rerenderSieve);
        if (!this.meshStack.func_190926_b()) {
            this.field_145850_b.func_217376_c((Entity)new ItemEntity(this.field_145850_b, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), this.meshStack.func_77946_l()));
            this.meshStack = ItemStack.field_190927_a;
            this.meshType = EnumMesh.NONE;
            if (rerenderSieve) {
                this.setSieveState();
            }
        }
    }

    public void setSieveState() {
        logger.debug("Set Sieve State, Mesh: " + (Object)((Object)this.meshType));
        BlockState state = this.func_195044_w();
        if (state.func_177230_c() instanceof BlockSieve) {
            this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)state.func_206870_a(BlockSieve.MESH, (Comparable)((Object)this.meshType)));
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        if (compound.func_74764_b(MESH_TAG)) {
            this.meshStack = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)compound.func_74781_a(MESH_TAG)));
            if (this.meshStack.func_77973_b() instanceof MeshItem) {
                this.meshType = ((MeshItem)this.meshStack.func_77973_b()).getMesh();
            }
        } else {
            this.meshStack = ItemStack.field_190927_a;
        }
        this.blockStack = compound.func_74764_b(BLOCK_TAG) ? ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)compound.func_74781_a(BLOCK_TAG))) : ItemStack.field_190927_a;
        this.progress = compound.func_74762_e(PROGRESS_TAG);
        super.func_230337_a_(state, compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (!this.meshStack.func_190926_b()) {
            CompoundNBT meshNBT = this.meshStack.func_77955_b(new CompoundNBT());
            compound.func_218657_a(MESH_TAG, (INBT)meshNBT);
        }
        if (!this.blockStack.func_190926_b()) {
            CompoundNBT blockNBT = this.blockStack.func_77955_b(new CompoundNBT());
            compound.func_218657_a(BLOCK_TAG, (INBT)blockNBT);
        }
        compound.func_74768_a(PROGRESS_TAG, this.progress);
        return super.func_189515_b(compound);
    }

    public void func_145843_s() {
        super.func_145843_s();
    }

    public void insertSiftableBlock(ItemStack stack, PlayerEntity player) {
        logger.debug("Insert Siftable Block: " + stack);
        if (!this.meshStack.func_190926_b() && this.blockStack.func_190926_b()) {
            this.blockStack = stack.func_77946_l();
            this.blockStack.func_190920_e(1);
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
        }
    }

    public void activateSieve(PlayerEntity player, boolean isWaterlogged) {
        logger.debug("Activate Sieve, isWaterlogged: " + isWaterlogged);
        if (this.func_145831_w().func_72912_H().func_82573_f() - this.lastSieveAction < 4L) {
            if (player != null && this.func_145831_w().func_72912_H().func_82573_f() - this.lastSieveAction == 0L && this.lastPlayer.equals(player.func_110124_au())) {
                IFormattableTextComponent message = new StringTextComponent("Autoclicker Bad").func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)0xFF0000)).func_240713_a_(Boolean.valueOf(true)));
                player.func_145747_a((ITextComponent)message, null);
            }
            return;
        }
        this.lastSieveAction = this.func_145831_w().func_72912_H().func_82573_f();
        if (player != null) {
            this.lastPlayer = player.func_110124_au();
        }
        if (this.isReadyToSieve()) {
            ++this.progress;
            if (this.progress >= Config.getMaxSieveClicks()) {
                logger.debug("Sieve progress complete");
                List<SieveRecipe> drops = ExNihiloRegistries.SIEVE_REGISTRY.getDrops((IItemProvider)((BlockItem)this.blockStack.func_77973_b()).func_179223_d(), this.meshType, isWaterlogged);
                drops.forEach(entry -> entry.getRolls().forEach(meshWithChance -> {
                    if (this.random.nextFloat() <= meshWithChance.getChance()) {
                        logger.debug("Spawning Item: " + entry.getDrop());
                        this.field_145850_b.func_217376_c((Entity)new ItemEntity(this.field_145850_b, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 1.1f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), entry.getDrop()));
                    }
                }));
                this.resetSieve();
            }
        }
    }

    private void resetSieve() {
        logger.debug("Resetting sieve");
        if (Config.enableMeshDurability()) {
            logger.debug("Damaging mesh");
            this.meshStack.func_222118_a(1, (LivingEntity)new FakePlayer((ServerWorld)this.field_145850_b, new GameProfile(UUID.randomUUID(), "Fake Player")), player -> logger.debug("Broken"));
        }
        this.blockStack = ItemStack.field_190927_a;
        this.progress = 0;
        if (this.meshStack.func_190926_b()) {
            logger.debug("Setting mesh to none, potential broken mesh");
            this.meshType = EnumMesh.NONE;
            this.setSieveState();
        }
    }

    public boolean isReadyToSieve() {
        return !this.meshStack.func_190926_b() && !this.blockStack.func_190926_b();
    }

    public ResourceLocation getTexture() {
        if (!this.blockStack.func_190926_b()) {
            return this.blockStack.func_77973_b().getRegistryName();
        }
        return null;
    }

    public ItemStack getBlockStack() {
        return this.blockStack;
    }

    public float getProgress() {
        return (float)this.progress / (float)Config.getMaxSieveClicks();
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        if (!this.meshStack.func_190926_b()) {
            CompoundNBT meshNBT = this.meshStack.func_77955_b(new CompoundNBT());
            nbt.func_218657_a(MESH_TAG, (INBT)meshNBT);
        }
        if (!this.blockStack.func_190926_b()) {
            CompoundNBT blockNbt = this.blockStack.func_77955_b(new CompoundNBT());
            nbt.func_218657_a(BLOCK_TAG, (INBT)blockNbt);
        }
        nbt.func_74768_a(PROGRESS_TAG, this.progress);
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        CompoundNBT nbt = packet.func_148857_g();
        if (nbt.func_74764_b(MESH_TAG)) {
            this.meshStack = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)nbt.func_74781_a(MESH_TAG)));
            if (this.meshStack.func_77973_b() instanceof MeshItem) {
                this.meshType = ((MeshItem)this.meshStack.func_77973_b()).getMesh();
            }
        } else {
            this.meshStack = ItemStack.field_190927_a;
        }
        this.blockStack = nbt.func_74764_b(BLOCK_TAG) ? ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)nbt.func_74781_a(BLOCK_TAG))) : ItemStack.field_190927_a;
        this.progress = nbt.func_74762_e(PROGRESS_TAG);
    }

    public EnumMesh getMesh() {
        return this.meshType;
    }
}

