/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.tileentity.barrel.mode;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import novamachina.exnihilosequentia.api.ExNihiloRegistries;
import novamachina.exnihilosequentia.common.item.dolls.DollItem;
import novamachina.exnihilosequentia.common.tileentity.barrel.AbstractBarrelTile;
import novamachina.exnihilosequentia.common.tileentity.barrel.mode.AbstractBarrelMode;
import novamachina.exnihilosequentia.common.tileentity.barrel.mode.BarrelModeRegistry;
import novamachina.exnihilosequentia.common.tileentity.barrel.mode.FluidTransformBarrelMode;
import novamachina.exnihilosequentia.common.tileentity.barrel.mode.MobSpawnBarrelMode;
import novamachina.exnihilosequentia.common.utility.TankUtil;

public class FluidsBarrelMode
extends AbstractBarrelMode {
    public FluidsBarrelMode(String name) {
        super(name);
    }

    @Override
    public void tick(AbstractBarrelTile barrelTile) {
        if (barrelTile.getFluidAmount() <= 0) {
            barrelTile.setMode(BarrelModeRegistry.getModeFromName("empty"));
        }
        if (barrelTile.getFluidAmount() >= AbstractBarrelTile.MAX_FLUID_AMOUNT) {
            if (this.fluidOnTop(barrelTile)) {
                return;
            }
            Block blockBelow = barrelTile.func_145831_w().func_180495_p(barrelTile.func_174877_v().func_177982_a(0, -1, 0)).func_177230_c();
            this.fluidTransform(barrelTile, (IItemProvider)blockBelow);
        }
    }

    private boolean doMobSpawn(AbstractBarrelTile barrelTile, PlayerEntity player, Hand handIn) {
        if (barrelTile.getFluidAmount() < AbstractBarrelTile.MAX_FLUID_AMOUNT) {
            return false;
        }
        Item item = player.func_184586_b(handIn).func_77973_b();
        if (item instanceof DollItem) {
            DollItem doll = (DollItem)item;
            if (barrelTile.getFluid().func_207187_a(doll.getSpawnFluid())) {
                barrelTile.setMode("mob");
                ((MobSpawnBarrelMode)barrelTile.getMode()).setDoll(doll);
                player.func_184586_b(handIn).func_190918_g(1);
                return true;
            }
        }
        return false;
    }

    private boolean fluidTransform(AbstractBarrelTile barrelTile, IItemProvider catalyst) {
        Fluid fluidInTank = barrelTile.getTank().getFluid().getFluid();
        if (ExNihiloRegistries.FLUID_TRANSFORM_REGISTRY.isValidRecipe(fluidInTank, catalyst)) {
            barrelTile.setMode("transform");
            ((FluidTransformBarrelMode)barrelTile.getMode()).setCatalyst(catalyst);
            return true;
        }
        return false;
    }

    private boolean fluidOnTop(AbstractBarrelTile barrelTile) {
        if (barrelTile.getFluidAmount() < AbstractBarrelTile.MAX_FLUID_AMOUNT) {
            return false;
        }
        Fluid fluidOnTop = barrelTile.func_145831_w().func_204610_c(barrelTile.func_174877_v().func_177982_a(0, 1, 0)).func_206886_c();
        Fluid fluidInTank = barrelTile.getTank().getFluid().getFluid();
        if (ExNihiloRegistries.FLUID_ON_TOP_REGISTRY.isValidRecipe(fluidInTank, fluidOnTop)) {
            barrelTile.getTank().setFluid(FluidStack.EMPTY);
            barrelTile.getInventory().setStackInSlot(0, ExNihiloRegistries.FLUID_ON_TOP_REGISTRY.getResult(fluidInTank, fluidOnTop));
            barrelTile.setMode("block");
            return true;
        }
        return false;
    }

    @Override
    public ActionResultType onBlockActivated(AbstractBarrelTile barrelTile, PlayerEntity player, Hand handIn, IFluidHandler fluidHandler, IItemHandler itemHandler) {
        ItemStack stack = player.func_184586_b(handIn);
        if (stack.func_190926_b()) {
            return ActionResultType.SUCCESS;
        }
        if (TankUtil.drainWaterIntoBottle(barrelTile, player, fluidHandler)) {
            return ActionResultType.SUCCESS;
        }
        if (TankUtil.drainWaterFromBottle(barrelTile, player, fluidHandler)) {
            return ActionResultType.SUCCESS;
        }
        boolean result = FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)handIn, (IFluidHandler)fluidHandler);
        if (result) {
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            barrelTile.func_145831_w().func_184138_a(barrelTile.func_174877_v(), barrelTile.func_195044_w(), barrelTile.func_195044_w(), 2);
            barrelTile.func_70296_d();
            return ActionResultType.SUCCESS;
        }
        if (this.fluidBlockTransform(barrelTile, player, handIn)) {
            return ActionResultType.SUCCESS;
        }
        Item catalyst = player.func_184586_b(handIn).func_77973_b();
        if (this.fluidTransform(barrelTile, (IItemProvider)catalyst)) {
            player.func_184586_b(handIn).func_190918_g(1);
        }
        this.doMobSpawn(barrelTile, player, handIn);
        return ActionResultType.SUCCESS;
    }

    private boolean fluidBlockTransform(AbstractBarrelTile barrelTile, PlayerEntity player, Hand handIn) {
        Item input;
        if (barrelTile.getFluidAmount() < AbstractBarrelTile.MAX_FLUID_AMOUNT) {
            return false;
        }
        Fluid fluid = barrelTile.getTank().getFluid().getFluid();
        if (ExNihiloRegistries.FLUID_BLOCK_REGISTRY.isValidRecipe(fluid, input = player.func_184586_b(handIn).func_77973_b())) {
            barrelTile.getTank().drain(1000, IFluidHandler.FluidAction.EXECUTE);
            barrelTile.getInventory().setStackInSlot(0, new ItemStack(ExNihiloRegistries.FLUID_BLOCK_REGISTRY.getResult(fluid, input)));
            if (!player.func_184812_l_()) {
                player.func_184586_b(handIn).func_190918_g(1);
            }
            barrelTile.setMode("block");
            return true;
        }
        return false;
    }

    @Override
    public boolean canFillWithFluid(AbstractBarrelTile barrel) {
        return true;
    }

    @Override
    public boolean isEmptyMode() {
        return false;
    }

    @Override
    protected boolean isTriggerItem(ItemStack stack) {
        return stack.func_77973_b() instanceof BucketItem || ItemStack.func_179545_c((ItemStack)stack, (ItemStack)PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185230_b));
    }

    @Override
    public void read(CompoundNBT nbt) {
    }

    @Override
    public CompoundNBT write() {
        return new CompoundNBT();
    }

    @Override
    protected void spawnParticle(AbstractBarrelTile barrelTile) {
    }

    @Override
    public List<ITextComponent> getWailaInfo(AbstractBarrelTile barrelTile) {
        ArrayList<ITextComponent> info = new ArrayList<ITextComponent>();
        String key = barrelTile.getFluid() == null ? Fluids.field_204541_a.func_207188_f().func_206883_i().func_177230_c().func_149739_a() : barrelTile.getFluid().func_207188_f().func_206883_i().func_177230_c().func_149739_a();
        info.add((ITextComponent)new TranslationTextComponent("waila.barrel.fluidAmount", new Object[]{new TranslationTextComponent(key), barrelTile.getFluidAmount()}));
        return info;
    }

    @Override
    public ItemStack handleInsert(AbstractBarrelTile barrelTile, ItemStack stack, boolean simulate) {
        Item input;
        if (barrelTile.getFluidAmount() < AbstractBarrelTile.MAX_FLUID_AMOUNT) {
            return stack.func_77946_l();
        }
        ItemStack returnStack = stack.func_77946_l();
        Fluid fluid = barrelTile.getTank().getFluid().getFluid();
        if (ExNihiloRegistries.FLUID_BLOCK_REGISTRY.isValidRecipe(fluid, input = stack.func_77973_b())) {
            if (!simulate) {
                barrelTile.getTank().drain(1000, IFluidHandler.FluidAction.EXECUTE);
                barrelTile.getInventory().setStackInSlot(0, new ItemStack(ExNihiloRegistries.FLUID_BLOCK_REGISTRY.getResult(fluid, input)));
                barrelTile.setMode("block");
            }
            returnStack.func_190918_g(1);
            return returnStack;
        }
        if (input instanceof DollItem) {
            DollItem doll = (DollItem)input;
            if (barrelTile.getFluid().func_207187_a(doll.getSpawnFluid())) {
                if (!simulate) {
                    barrelTile.setMode("mob");
                    ((MobSpawnBarrelMode)barrelTile.getMode()).setDoll(doll);
                }
                returnStack.func_190918_g(1);
            }
        }
        return returnStack;
    }
}

