/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.tileentity.crucible;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import novamachina.exnihilosequentia.api.ExNihiloRegistries;
import novamachina.exnihilosequentia.api.crafting.crucible.CrucibleRecipe;
import novamachina.exnihilosequentia.common.tileentity.crucible.CrucibleFluidHandler;
import novamachina.exnihilosequentia.common.tileentity.crucible.CrucilbeTypeEnum;
import novamachina.exnihilosequentia.common.tileentity.crucible.MeltableItemHandler;
import novamachina.exnihilosequentia.common.utility.Config;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import novamachina.exnihilosequentia.common.utility.TankUtil;
import org.apache.logging.log4j.LogManager;

public abstract class BaseCrucibleTile
extends TileEntity
implements ITickableTileEntity {
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogManager.getLogger());
    private static final String INVENTORY_TAG = "inventory";
    private static final String SOLID_AMOUNT_TAG = "solidAmount";
    private static final String CURRENT_ITEM_TAG = "currentItem";
    private static final String BLOCK_TAG = "block";
    private static final String FLUID_TAG = "fluid";
    protected static final int MAX_FLUID_AMOUNT = Config.getCrucibleNumberOfBuckets() * 1000;
    protected MeltableItemHandler inventory;
    private final LazyOptional<IItemHandler> inventoryHolder = LazyOptional.of(() -> this.inventory);
    protected CrucibleFluidHandler tank;
    private final LazyOptional<IFluidHandler> tankHolder = LazyOptional.of(() -> this.tank);
    protected int ticksSinceLast = 0;
    protected int solidAmount = 0;
    protected ItemStack currentItem;

    protected BaseCrucibleTile(TileEntityType<? extends BaseCrucibleTile> tileEntityType) {
        super(tileEntityType);
        this.inventory = new MeltableItemHandler(this.getCrucibleType());
        this.tank = new CrucibleFluidHandler(this);
        this.currentItem = ItemStack.field_190927_a;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.inventory.deserializeNBT(compound.func_74775_l(INVENTORY_TAG));
        this.tank.readFromNBT(compound.func_74775_l("tank"));
        this.ticksSinceLast = compound.func_74762_e("ticksSinceLast");
        this.solidAmount = compound.func_74762_e(SOLID_AMOUNT_TAG);
        this.currentItem = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l(CURRENT_ITEM_TAG));
        super.func_230337_a_(state, compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a(INVENTORY_TAG, (INBT)this.inventory.serializeNBT());
        compound.func_218657_a("tank", (INBT)this.tank.writeToNBT(new CompoundNBT()));
        compound.func_74768_a("ticksSinceLast", this.ticksSinceLast);
        compound.func_74768_a(SOLID_AMOUNT_TAG, this.solidAmount);
        compound.func_218657_a(CURRENT_ITEM_TAG, (INBT)this.currentItem.func_77955_b(new CompoundNBT()));
        return super.func_189515_b(compound);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryHolder.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.tankHolder.cast();
        }
        return super.getCapability(cap, side);
    }

    public int getHeat() {
        BlockState source = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
        int blockHeat = ExNihiloRegistries.HEAT_REGISTRY.getHeatAmount(source);
        if (source.func_177230_c() instanceof FlowingFluidBlock) {
            int level = 8 - (Integer)source.func_177229_b((Property)BlockStateProperties.field_208132_ag);
            double partial = (double)blockHeat / 8.0;
            int returnVal = (int)Math.ceil(partial * (double)level);
            return returnVal;
        }
        return blockHeat;
    }

    public ActionResultType onBlockActivated(PlayerEntity player, Hand handIn, IFluidHandler handler) {
        logger.debug("Crucible activated");
        ItemStack stack = player.func_184586_b(handIn);
        if (stack.func_190926_b()) {
            return ActionResultType.SUCCESS;
        }
        if (TankUtil.drainWaterIntoBottle(this, player, handler)) {
            return ActionResultType.SUCCESS;
        }
        if (TankUtil.drainWaterFromBottle(this, player, handler)) {
            return ActionResultType.SUCCESS;
        }
        boolean result = FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)handIn, (IFluidHandler)handler);
        if (result) {
            logger.debug("Fluid handler interaction successful");
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
            this.func_70296_d();
            return ActionResultType.SUCCESS;
        }
        CrucibleRecipe recipe = this.getMeltable();
        if (recipe != null && !this.tank.isEmpty() && !this.tank.getFluid().getFluid().func_207187_a(recipe.getResultFluid().getFluid())) {
            return ActionResultType.SUCCESS;
        }
        logger.debug("Inserting item");
        ItemStack addStack = stack.func_77946_l();
        addStack.func_190920_e(1);
        ItemStack insertStack = this.inventory.insertItem(0, addStack, true);
        if (!ItemStack.func_77989_b((ItemStack)addStack, (ItemStack)insertStack)) {
            this.inventory.insertItem(0, addStack, false);
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            this.func_70296_d();
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.SUCCESS;
    }

    public ResourceLocation getSolidTexture() {
        if (!this.inventory.getStackInSlot(0).func_190926_b()) {
            return this.inventory.getStackInSlot(0).func_77973_b().getRegistryName();
        }
        if (!this.currentItem.func_190926_b()) {
            return this.currentItem.func_77973_b().getRegistryName();
        }
        return null;
    }

    public Fluid getFluid() {
        if (!this.tank.isEmpty()) {
            return this.tank.getFluid().getFluid();
        }
        return null;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        if (!this.inventory.getStackInSlot(0).func_190926_b()) {
            CompoundNBT blockNbt = this.inventory.getStackInSlot(0).func_77955_b(new CompoundNBT());
            nbt.func_218657_a(BLOCK_TAG, (INBT)blockNbt);
        }
        if (!this.currentItem.func_190926_b()) {
            CompoundNBT currentItemTag = this.currentItem.func_77955_b(new CompoundNBT());
            nbt.func_218657_a(CURRENT_ITEM_TAG, (INBT)currentItemTag);
        }
        if (!this.tank.isEmpty()) {
            CompoundNBT fluidNbt = this.tank.writeToNBT(new CompoundNBT());
            nbt.func_218657_a(FLUID_TAG, (INBT)fluidNbt);
        }
        nbt.func_74768_a(SOLID_AMOUNT_TAG, this.solidAmount);
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        CompoundNBT nbt = packet.func_148857_g();
        this.currentItem = nbt.func_74764_b(CURRENT_ITEM_TAG) ? ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)nbt.func_74781_a(CURRENT_ITEM_TAG))) : ItemStack.field_190927_a;
        if (nbt.func_74764_b(BLOCK_TAG)) {
            this.inventory.setStackInSlot(0, ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)nbt.func_74781_a(BLOCK_TAG))));
        } else {
            this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
        }
        if (nbt.func_74764_b(FLUID_TAG)) {
            this.tank.readFromNBT(nbt.func_74775_l(FLUID_TAG));
        } else {
            this.tank.setFluid(FluidStack.EMPTY);
        }
        this.solidAmount = nbt.func_74762_e(SOLID_AMOUNT_TAG);
    }

    public float getFluidProportion() {
        return (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity();
    }

    public float getSolidProportion() {
        try {
            int itemCount = this.inventory.getStackInSlot(0).func_190926_b() ? 0 : this.inventory.getStackInSlot(0).func_190916_E();
            float solidProportion = (float)itemCount / 4.0f;
            if (this.solidAmount > 0) {
                CrucibleRecipe meltable = this.getMeltable();
                solidProportion += (float)this.solidAmount / (float)(4 * meltable.getAmount());
            }
            return solidProportion;
        }
        catch (NullPointerException e) {
            logger.error(e.getMessage());
            return 0.0f;
        }
    }

    public abstract CrucilbeTypeEnum getCrucibleType();

    private CrucibleRecipe getMeltable() {
        return ExNihiloRegistries.CRUCIBLE_REGISTRY.findRecipe((IItemProvider)this.currentItem.func_77973_b());
    }

    public int getFluidAmount() {
        return this.tank.getFluidAmount();
    }

    public ItemStack getCurrentItem() {
        return this.currentItem;
    }

    public abstract int getSolidAmount();

    public abstract boolean canAcceptFluidTemperature(FluidStack var1);
}

