/*
 * Decompiled with CFR 0.152.
 */
package com.estebes.gravisuitereloaded.item;

import com.estebes.gravisuitereloaded.reference.Reference;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.ICustomDamageItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IMetalArmor;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.ISpecialArmor;

public class ItemElectricArmor
extends ItemArmor
implements IElectricItem,
IMetalArmor,
ISpecialArmor,
ICustomDamageItem {
    private String name;
    protected int energyTier;
    protected double maxCharge;
    protected double transferLimit;
    protected boolean providesEnergy;
    protected int energyPerDamage;
    protected double damageAbsorptionRatio;
    protected double baseAbsorptionRatio;

    public ItemElectricArmor(String name, int energyTier, double maxCharge, double transferLimit, boolean providesEnergy, int energyPerDamage, double damageAbsorptionRatio, double baseAbsorptionRatio, ItemArmor.ArmorMaterial armorMaterial) {
        super(armorMaterial, 0, 1);
        this.name = name;
        this.energyTier = energyTier;
        this.maxCharge = maxCharge;
        this.transferLimit = transferLimit;
        this.providesEnergy = providesEnergy;
        this.energyPerDamage = energyPerDamage;
        this.damageAbsorptionRatio = damageAbsorptionRatio;
        this.baseAbsorptionRatio = baseAbsorptionRatio;
        this.func_77655_b(this.name);
        this.func_77656_e(27);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_82789_a(ItemStack itemStack1, ItemStack itemStack2) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List itemList) {
        ItemStack chargedItem = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(chargedItem, Double.POSITIVE_INFINITY, Integer.MAX_VALUE, true, false);
        itemList.add(chargedItem);
        ItemStack depletedItem = new ItemStack((Item)this, 1, this.func_77612_l());
        itemList.add(depletedItem);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a(Reference.LOWERCASE_MOD_ID + ":" + this.name);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack itemStack, int pass) {
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return Reference.LOWERCASE_MOD_ID + ":textures/armor/" + this.name + ".png";
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.rare;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean var) {
        list.add(StatCollector.func_74838_a((String)"tooltip.tool.PowerTier") + " " + this.energyTier);
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return this.providesEnergy;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack itemStack) {
        return this.energyTier;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.func_76363_c()) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        double absorptionRatio = this.baseAbsorptionRatio * this.damageAbsorptionRatio;
        int damageLimit = Integer.MAX_VALUE;
        if (this.energyPerDamage > 0) {
            damageLimit = (int)Math.min((double)damageLimit, 25.0 * ElectricItem.manager.getCharge(armor) / (double)this.energyPerDamage);
        }
        return new ISpecialArmor.ArmorProperties(0, absorptionRatio, damageLimit);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        if (ElectricItem.manager.getCharge(armor) >= 0.0) {
            return (int)Math.round(20.0 * this.baseAbsorptionRatio * this.damageAbsorptionRatio);
        }
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack itemStack, DamageSource source, int damage, int slot) {
        ElectricItem.manager.discharge(itemStack, (double)(damage * this.energyPerDamage), Integer.MAX_VALUE, true, false, false);
    }

    public boolean isMetalArmor(ItemStack itemstack, EntityPlayer player) {
        return true;
    }

    public int getCustomDamage(ItemStack stack) {
        return stack.func_77960_j();
    }

    public int getMaxCustomDamage(ItemStack stack) {
        return stack.func_77958_k();
    }

    public void setCustomDamage(ItemStack stack, int damage) {
        stack.func_77964_b(damage);
    }

    public boolean applyCustomDamage(ItemStack stack, int damage, EntityLivingBase src) {
        if (src != null) {
            stack.func_77972_a(damage, src);
            return true;
        }
        return stack.func_96631_a(damage, new Random());
    }
}

