/*
 * Decompiled with CFR 0.152.
 */
package com.estebes.gravisuitereloaded.item;

import com.estebes.gravisuitereloaded.item.ItemElectricArmor;
import com.estebes.gravisuitereloaded.util.Util;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import ic2.api.item.ElectricItem;
import ic2.api.util.Keys;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.world.World;

public class ItemElectricArmorJetpack
extends ItemElectricArmor {
    public ItemElectricArmorJetpack(String name, int energyTier, double maxCharge, double transferLimit, boolean providesEnergy, int energyPerDamage, double damageAbsorptionRatio, double baseAbsorptionRatio, ItemArmor.ArmorMaterial armorMaterial) {
        super(name, energyTier, maxCharge, transferLimit, providesEnergy, energyPerDamage, damageAbsorptionRatio, baseAbsorptionRatio, armorMaterial);
    }

    public double getCharge(ItemStack itemStack) {
        return ElectricItem.manager.getCharge(itemStack);
    }

    public void useEnergy(ItemStack itemStack, double energyAmount) {
        ElectricItem.manager.discharge(itemStack, energyAmount, this.energyTier, true, false, false);
    }

    public boolean useJetpack(EntityPlayer entityPlayer, boolean hoverMode) {
        int maxFlightHeight;
        double y;
        ItemStack jetpack = entityPlayer.field_71071_by.field_70460_b[2];
        if (this.getCharge(jetpack) <= 0.0) {
            return false;
        }
        float power = 1.0f;
        float dropPercentage = 0.001f;
        if (this.getCharge(jetpack) / this.getMaxCharge(jetpack) <= (double)dropPercentage) {
            power = (float)((double)power * (this.getCharge(jetpack) / (this.getMaxCharge(jetpack) * (double)dropPercentage)));
        }
        if (Keys.instance.isForwardKeyDown(entityPlayer)) {
            float retruster = 0.3f;
            if (hoverMode) {
                retruster = 0.65f;
            }
            float forwardpower = power * retruster * 2.0f;
            float boostSpeed = 0.0f;
            if (Keys.instance.isBoostKeyDown(entityPlayer) && this.getCharge(jetpack) > 60.0) {
                boostSpeed = 0.09f;
                if (hoverMode) {
                    boostSpeed = 0.07f;
                }
            }
            if (forwardpower > 0.0f) {
                entityPlayer.func_70060_a(0.0f, 0.4f * forwardpower, 0.02f + boostSpeed);
                if (boostSpeed > 0.0f && !entityPlayer.field_70170_p.field_72995_K) {
                    this.useEnergy(jetpack, 60.0);
                }
            }
        }
        if ((y = entityPlayer.field_70163_u) > (double)(maxFlightHeight = Util.getWorldHeight(entityPlayer.field_70170_p))) {
            if (y > (double)maxFlightHeight) {
                y = maxFlightHeight;
            }
            power = (float)((double)power * (((double)maxFlightHeight - y) / 25.0));
        }
        double prevmotion = entityPlayer.field_70181_x;
        entityPlayer.field_70181_x = Math.min(entityPlayer.field_70181_x + (double)(power * 0.2f), (double)0.6f);
        if (hoverMode) {
            float maxHoverY = 0.0f;
            if (Keys.instance.isJumpKeyDown(entityPlayer)) {
                maxHoverY = 0.2f;
            }
            if (Keys.instance.isSneakKeyDown(entityPlayer)) {
                maxHoverY = -0.2f;
            }
            if (this.getCharge(jetpack) > 60.0 && Keys.instance.isBoostKeyDown(entityPlayer) && (Keys.instance.isSneakKeyDown(entityPlayer) || Keys.instance.isJumpKeyDown(entityPlayer))) {
                maxHoverY = (float)((double)maxHoverY * 2.0);
                this.useEnergy(jetpack, 60.0);
            }
            if (entityPlayer.field_70181_x > (double)maxHoverY) {
                entityPlayer.field_70181_x = maxHoverY;
                if (prevmotion > entityPlayer.field_70181_x) {
                    entityPlayer.field_70181_x = prevmotion;
                }
            }
        }
        if (!entityPlayer.field_70122_E) {
            this.useEnergy(jetpack, 12.0);
        }
        entityPlayer.field_70143_R = 0.0f;
        entityPlayer.field_70140_Q = 0.0f;
        this.resetPlayerInAirTime(entityPlayer);
        return true;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (player.field_71071_by.field_70460_b[2] != itemStack) {
            return;
        }
        NBTTagCompound nbtData = Util.getOrCreateNbtData(itemStack);
        boolean hoverMode = nbtData.func_74767_n("hoverMode");
        byte toggleTimer = nbtData.func_74771_c("toggleTimer");
        boolean jetpackUsed = false;
        if (Keys.instance.isJumpKeyDown(player) && Keys.instance.isModeSwitchKeyDown(player) && toggleTimer == 0) {
            toggleTimer = 10;
            boolean bl = hoverMode = !hoverMode;
            if (!world.field_72995_K) {
                nbtData.func_74757_a("hoverMode", hoverMode);
            }
        }
        if (Keys.instance.isJumpKeyDown(player) || hoverMode) {
            jetpackUsed = this.useJetpack(player, hoverMode);
        }
        if (!world.field_72995_K && toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
            nbtData.func_74774_a("toggleTimer", toggleTimer);
        }
        if (jetpackUsed) {
            player.field_71069_bz.func_75142_b();
        }
    }

    public void resetPlayerInAirTime(EntityPlayer player) {
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        ObfuscationReflectionHelper.setPrivateValue(NetHandlerPlayServer.class, (Object)((EntityPlayerMP)player).field_71135_a, (Object)0, (String[])new String[]{"field_147365_f", "floatingTickCount"});
    }
}

