/*
 * Decompiled with CFR 0.152.
 */
package com.estebes.gravisuitereloaded.item.tool;

import com.estebes.gravisuitereloaded.item.ItemElectricTool;
import ic2.api.item.ElectricItem;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;

public class ItemToolBigMiningDrill
extends ItemElectricTool {
    protected double operationCost;

    public ItemToolBigMiningDrill(String name, int energyTier, double maxCharge, double transferLimit, boolean providesEnergy, double operationCost) {
        super(name, energyTier, maxCharge, transferLimit, providesEnergy);
        this.operationCost = operationCost;
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        Block block = player.field_70170_p.func_147439_a(x, y, z);
        if (block == null || !this.canHarvestBlock(block, stack)) {
            return super.onBlockStartBreak(stack, x, y, z, player);
        }
        MovingObjectPosition mop = ItemToolBigMiningDrill.raytraceFromEntity(player.field_70170_p, (Entity)player, false, 4.5);
        if (mop == null) {
            return super.onBlockStartBreak(stack, x, y, z, player);
        }
        int sideHit = mop.field_72310_e;
        int xRange = 1;
        int yRange = 1;
        int zRange = 1;
        switch (sideHit) {
            case 0: 
            case 1: {
                yRange = 0;
                zRange = 1;
                break;
            }
            case 2: 
            case 3: {
                xRange = 1;
                zRange = 0;
                break;
            }
            case 4: 
            case 5: {
                xRange = 0;
                zRange = 1;
            }
        }
        for (int xPos = x - xRange; xPos <= x + xRange; ++xPos) {
            for (int yPos = y - yRange; yPos <= y + yRange; ++yPos) {
                for (int zPos = z - zRange; zPos <= z + zRange; ++zPos) {
                    if (!ElectricItem.manager.canUse(stack, this.operationCost) || xPos == x && yPos == y && zPos == z || super.onBlockStartBreak(stack, xPos, yPos, zPos, player)) continue;
                    this.breakExtraBlock(player.field_70170_p, xPos, yPos, zPos, player, x, y, z, stack);
                    ElectricItem.manager.use(stack, this.operationCost, (EntityLivingBase)player);
                }
            }
        }
        return super.onBlockStartBreak(stack, x, y, z, player);
    }

    public void breakExtraBlock(World world, int x, int y, int z, EntityPlayer entityPlayer, int refX, int refY, int refZ, ItemStack itemStack) {
        if (world.func_147437_c(x, y, z)) {
            return;
        }
        if (!(entityPlayer instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)entityPlayer;
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (!this.canHarvestBlock(block, itemStack) || !(block.func_149712_f(world, x, y, z) > 0.0f)) {
            return;
        }
        BlockEvent.BreakEvent event = ForgeHooks.onBlockBreakEvent((World)world, (WorldSettings.GameType)player.field_71134_c.func_73081_b(), (EntityPlayerMP)player, (int)x, (int)y, (int)z);
        if (event.isCanceled()) {
            return;
        }
        if (player.field_71075_bZ.field_75098_d) {
            block.func_149681_a(world, x, y, z, meta, (EntityPlayer)player);
            if (block.removedByPlayer(world, (EntityPlayer)player, x, y, z, false)) {
                block.func_149664_b(world, x, y, z, meta);
            }
            if (!world.field_72995_K) {
                player.field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(x, y, z, world));
            }
            return;
        }
        if (!world.field_72995_K) {
            block.func_149681_a(world, x, y, z, meta, (EntityPlayer)player);
            if (block.removedByPlayer(world, (EntityPlayer)player, x, y, z, true)) {
                block.func_149664_b(world, x, y, z, meta);
                block.func_149636_a(world, (EntityPlayer)player, x, y, z, meta);
                block.func_149657_c(world, x, y, z, event.getExpToDrop());
            }
            player.field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(x, y, z, world));
        } else {
            world.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)block) + (meta << 12));
            if (block.removedByPlayer(world, (EntityPlayer)player, x, y, z, true)) {
                block.func_149664_b(world, x, y, z, meta);
            }
        }
    }

    public static MovingObjectPosition raytraceFromEntity(World world, Entity player, boolean par3, double range) {
        float f = 1.0f;
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f;
        if (!world.field_72995_K && player instanceof EntityPlayer) {
            d1 += 1.62;
        }
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3 vec3 = Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = range;
        if (player instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        }
        Vec3 vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return world.func_147447_a(vec3, vec31, par3, !par3, par3);
    }

    public float getDigSpeed(ItemStack itemStack, Block block, int meta) {
        if (!ElectricItem.manager.canUse(itemStack, this.operationCost)) {
            return 1.0f;
        }
        if (this.canHarvestBlock(block, itemStack)) {
            return 5.0f;
        }
        return 1.0f;
    }

    public boolean canHarvestBlock(Block block, ItemStack itemStack) {
        return Items.field_151035_b.canHarvestBlock(block, itemStack) || Items.field_151035_b.func_150893_a(itemStack, block) > 1.0f || Items.field_151037_a.canHarvestBlock(block, itemStack) || Items.field_151037_a.func_150893_a(itemStack, block) > 1.0f;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        if (toolClass.equals("pickaxe") || toolClass.equals("shovel")) {
            return this.field_77862_b.func_77996_d();
        }
        return super.getHarvestLevel(stack, toolClass);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xOffset, float yOffset, float zOffset) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            Item item;
            ItemStack torchStack = player.field_71071_by.field_70462_a[i];
            if (torchStack == null || !torchStack.func_77977_a().toLowerCase(Locale.ENGLISH).contains("torch") || !((item = torchStack.func_77973_b()) instanceof ItemBlock)) continue;
            int oldMeta = torchStack.func_77960_j();
            int oldSize = torchStack.field_77994_a;
            boolean result = torchStack.func_77943_a(player, world, x, y, z, side, xOffset, yOffset, zOffset);
            if (player.field_71075_bZ.field_75098_d) {
                torchStack.func_77964_b(oldMeta);
                torchStack.field_77994_a = oldSize;
            } else if (torchStack.field_77994_a <= 0) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)torchStack);
                player.field_71071_by.field_70462_a[i] = null;
            }
            if (!result) continue;
            return true;
        }
        return super.func_77648_a(stack, player, world, x, y, z, side, xOffset, yOffset, zOffset);
    }

    public boolean func_150894_a(ItemStack itemStack, World world, Block block, int x, int y, int z, EntityLivingBase entityLiving) {
        if ((double)block.func_149712_f(world, x, y, z) != 0.0) {
            if (entityLiving != null) {
                ElectricItem.manager.use(itemStack, this.operationCost, entityLiving);
            } else {
                ElectricItem.manager.discharge(itemStack, this.operationCost, this.getTier(itemStack), true, false, false);
            }
        }
        return true;
    }
}

