/*
 * Decompiled with CFR 0.152.
 */
package com.estebes.gravisuitereloaded.item.tool;

import com.estebes.gravisuitereloaded.item.ItemElectricTool;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import ic2.api.item.ElectricItem;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.world.BlockEvent;

public class ItemToolTheChopper
extends ItemElectricTool {
    public ItemToolTheChopper() {
        super("ItemToolTheChopper", 2, 100000.0, 128.0, false);
        this.operationCost = 100.0;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean onBlockStartBreak(ItemStack itemStack, int x, int y, int z, EntityPlayer entityPlayer) {
        if (entityPlayer.func_70093_af() || !ElectricItem.manager.canUse(itemStack, this.operationCost) || entityPlayer.field_70170_p.func_147439_a(x, y, z) == null) {
            return super.onBlockStartBreak(itemStack, x, y, z, entityPlayer);
        }
        if ((entityPlayer.field_70170_p.func_147439_a(x, y, z).isWood((IBlockAccess)entityPlayer.field_70170_p, x, y, z) || entityPlayer.field_70170_p.func_147439_a(x, y, z).func_149688_o() == Material.field_151583_m) && this.detectTree(entityPlayer.field_70170_p, x, y, z, entityPlayer.field_70170_p.func_147439_a(x, y, z))) {
            this.breakTree(entityPlayer.field_70170_p, x, y, z, x, y, z, itemStack, entityPlayer.field_70170_p.func_147439_a(x, y, z), entityPlayer.field_70170_p.func_72805_g(x, y, z), entityPlayer);
            return true;
        }
        return super.onBlockStartBreak(itemStack, x, y, z, entityPlayer);
    }

    private boolean detectTree(World world, int x, int y, int z, Block wood) {
        int height = y;
        boolean foundTop = false;
        do {
            Block block;
            if ((block = world.func_147439_a(x, ++height, z)) == wood) continue;
            --height;
            foundTop = true;
        } while (!foundTop);
        int numLeaves = 0;
        if (height - y < 50) {
            for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
                for (int yPos = height - 1; yPos <= height + 1; ++yPos) {
                    for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                        Block leaves = world.func_147439_a(xPos, yPos, zPos);
                        if (leaves == null || !leaves.isLeaves((IBlockAccess)world, xPos, yPos, zPos)) continue;
                        ++numLeaves;
                    }
                }
            }
        }
        return numLeaves > 3;
    }

    private void breakTree(World world, int x, int y, int z, int xStart, int yStart, int zStart, ItemStack stack, Block bID, int meta, EntityPlayer player) {
        for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
            for (int yPos = y; yPos <= y + 1; ++yPos) {
                for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                    float localHardness;
                    Block localBlock;
                    if (!ElectricItem.manager.canUse(stack, this.operationCost) || bID != (localBlock = world.func_147439_a(xPos, yPos, zPos))) continue;
                    int localMeta = world.func_72805_g(xPos, yPos, zPos);
                    float f = localHardness = localBlock == null ? Float.MAX_VALUE : localBlock.func_149712_f(world, xPos, yPos, zPos);
                    if (localHardness < 0.0f) continue;
                    BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(x, y, z, world, localBlock, localMeta, player);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    int xDist = xPos - xStart;
                    int yDist = yPos - yStart;
                    int zDist = zPos - zStart;
                    if (9 * xDist * xDist + yDist * yDist + 9 * zDist * zDist >= 2500 || localMeta % 4 != meta % 4) continue;
                    if (!player.field_71075_bZ.field_75098_d) {
                        localBlock.func_149636_a(world, player, x, y, z, localMeta);
                        this.func_150894_a(stack, world, localBlock, xPos, yPos, zPos, (EntityLivingBase)player);
                    }
                    world.func_147468_f(xPos, yPos, zPos);
                    if (world.field_72995_K) continue;
                    this.breakTree(world, xPos, yPos, zPos, xStart, yStart, zStart, stack, bID, meta, player);
                }
            }
        }
    }

    public boolean func_150894_a(ItemStack itemStack, World world, Block block, int x, int y, int z, EntityLivingBase entityLiving) {
        if ((double)block.func_149712_f(world, x, y, z) != 0.0) {
            if (entityLiving != null) {
                ElectricItem.manager.use(itemStack, this.operationCost, entityLiving);
            } else {
                ElectricItem.manager.discharge(itemStack, this.operationCost, this.getTier(itemStack), true, false, false);
            }
        }
        return true;
    }

    @SubscribeEvent
    public void onEntityInteract(EntityInteractEvent event) {
        IShearable target;
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        Entity entity = event.target;
        EntityPlayer player = event.entityPlayer;
        ItemStack itemstack = player.field_71071_by.func_70301_a(player.field_71071_by.field_70461_c);
        if (itemstack != null && itemstack.func_77973_b() == this && entity instanceof IShearable && ElectricItem.manager.use(itemstack, this.operationCost, (EntityLivingBase)player) && (target = (IShearable)entity).isShearable(itemstack, (IBlockAccess)entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v)) {
            ArrayList drops = target.onSheared(itemstack, (IBlockAccess)entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)itemstack));
            for (ItemStack stack : drops) {
                EntityItem ent = entity.func_70099_a(stack, 1.0f);
                ent.field_70181_x += (double)(field_77697_d.nextFloat() * 0.05f);
                ent.field_70159_w += (double)((field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.1f);
                ent.field_70179_y += (double)((field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.1f);
            }
        }
    }

    @Override
    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase attacker) {
        ElectricItem.manager.use(itemstack, this.operationCost, attacker);
        return true;
    }

    public float getDigSpeed(ItemStack itemStack, Block block, int meta) {
        if (!ElectricItem.manager.canUse(itemStack, this.operationCost)) {
            return 1.0f;
        }
        if (this.canHarvestBlock(block, itemStack)) {
            return 8.0f;
        }
        return 1.0f;
    }

    public boolean canHarvestBlock(Block block, ItemStack itemStack) {
        return Items.field_151056_x.canHarvestBlock(block, itemStack) || Items.field_151056_x.func_150893_a(itemStack, block) > 1.0f || Items.field_151097_aZ.canHarvestBlock(block, itemStack) || Items.field_151097_aZ.func_150893_a(itemStack, block) > 1.0f;
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        HashMultimap ret;
        if (ElectricItem.manager.canUse(stack, this.operationCost)) {
            ret = HashMultimap.create();
            ret.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", 12.0, 0));
        } else {
            ret = super.getAttributeModifiers(stack);
        }
        return ret;
    }
}

