/*
 * Decompiled with CFR 0.152.
 */
package com.estebes.gravisuitereloaded.item.weapon;

import com.estebes.gravisuitereloaded.reference.Reference;
import com.estebes.gravisuitereloaded.util.Util;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemWeaponQuantumSaber
extends ItemTool
implements IElectricItem {
    private int tier = 4;
    private double maxCharge = 1.0E7;
    private double transferLimit = 12000.0;
    private double operationCost = 3000.0;
    private double idleCost = 200.0;
    private IIcon[] textures;

    public ItemWeaponQuantumSaber() {
        super(0.0f, Item.ToolMaterial.EMERALD, new HashSet());
        this.func_77655_b("ItemWeaponQuantumSaber");
        this.func_77656_e(27);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.textures = new IIcon[2];
        this.textures[0] = iconRegister.func_94245_a(Reference.LOWERCASE_MOD_ID + ":" + "ItemWeaponQuantumSaber" + "Off");
        this.textures[1] = iconRegister.func_94245_a(Reference.LOWERCASE_MOD_ID + ":" + "ItemWeaponQuantumSaber" + "On");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack itemStack, int pass) {
        NBTTagCompound nbtData = Util.getOrCreateNbtData(itemStack);
        if (nbtData.func_74767_n("active")) {
            return this.textures[1];
        }
        return this.textures[0];
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        NBTTagCompound nbtData;
        int damage = 6;
        if (ElectricItem.manager.canUse(stack, this.idleCost) && (nbtData = Util.getOrCreateNbtData(stack)).func_74767_n("active")) {
            damage = 40;
        }
        HashMultimap multimap = HashMultimap.create();
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)damage, 0));
        return multimap;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase source) {
        return true;
    }

    public boolean onLeftClickEntity(ItemStack itemStack, EntityPlayer player, Entity entity) {
        NBTTagCompound nbtData = Util.getOrCreateNbtData(itemStack);
        if (!FMLCommonHandler.instance().getEffectiveSide().isClient() && entity instanceof EntityLivingBase) {
            if (!nbtData.func_74767_n("active")) {
                ((EntityLivingBase)entity).func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 6.0f);
                return true;
            }
            if (!ElectricItem.manager.use(itemStack, this.operationCost, (EntityLivingBase)player)) {
                nbtData.func_74757_a("active", false);
                HashMap enchantmentMap = new HashMap();
                EnchantmentHelper.func_82782_a(enchantmentMap, (ItemStack)itemStack);
                ItemWeaponQuantumSaber.updateAttributes(nbtData);
                entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 6.0f);
                return true;
            }
            entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player).func_76348_h().func_151518_m().func_76359_i(), 40.0f);
            return true;
        }
        return true;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityplayer) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return itemStack;
        }
        NBTTagCompound nbtData = Util.getOrCreateNbtData(itemStack);
        HashMap<Integer, Integer> enchantmentMap = new HashMap<Integer, Integer>();
        if (nbtData.func_74767_n("active")) {
            nbtData.func_74757_a("active", false);
            EnchantmentHelper.func_82782_a(enchantmentMap, (ItemStack)itemStack);
            ItemWeaponQuantumSaber.updateAttributes(nbtData);
        } else if (ElectricItem.manager.canUse(itemStack, this.idleCost)) {
            nbtData.func_74757_a("active", true);
            enchantmentMap.put(Enchantment.field_77335_o.field_77352_x, 3);
            EnchantmentHelper.func_82782_a(enchantmentMap, (ItemStack)itemStack);
            ItemWeaponQuantumSaber.updateAttributes(nbtData);
        }
        return super.func_77659_a(itemStack, world, entityplayer);
    }

    private static void updateAttributes(NBTTagCompound nbtData) {
        boolean active = nbtData.func_74767_n("active");
        int damage = active ? 40 : 6;
        NBTTagCompound entry = new NBTTagCompound();
        entry.func_74778_a("AttributeName", SharedMonsterAttributes.field_111264_e.func_111108_a());
        entry.func_74772_a("UUIDMost", field_111210_e.getMostSignificantBits());
        entry.func_74772_a("UUIDLeast", field_111210_e.getLeastSignificantBits());
        entry.func_74778_a("Name", "Tool modifier");
        entry.func_74780_a("Amount", (double)damage);
        entry.func_74768_a("Operation", 0);
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)entry);
        nbtData.func_74782_a("AttributeModifiers", (NBTBase)list);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List itemList) {
        ItemStack chargedItem = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(chargedItem, Double.POSITIVE_INFINITY, Integer.MAX_VALUE, true, false);
        itemList.add(chargedItem);
        ItemStack depletedItem = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(depletedItem, 0.0, Integer.MAX_VALUE, true, false);
        itemList.add(depletedItem);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemStack) {
        return EnumRarity.epic;
    }

    public boolean isBookEnchantable(ItemStack item, ItemStack book) {
        return false;
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        return block == Blocks.field_150321_G ? 6.0f : 0.0f;
    }

    public boolean canHarvestBlock(Block block, ItemStack itemStack) {
        return block == Blocks.field_150321_G;
    }

    public boolean func_82789_a(ItemStack item1, ItemStack item2) {
        return false;
    }

    public boolean func_150894_a(ItemStack itemStack, World world, Block block, int x, int y, int z, EntityLivingBase entity) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean var) {
        list.add(StatCollector.func_74838_a((String)"tooltip.tool.PowerTier") + " " + this.tier);
        list.add(StatCollector.func_74838_a((String)"tooltip.tool.QuantumSaberDescription"));
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int slot, boolean par5) {
        NBTTagCompound nbtData = Util.getOrCreateNbtData(itemStack);
        if (!nbtData.func_74767_n("active")) {
            return;
        }
        if (entity instanceof EntityPlayerMP && !ElectricItem.manager.use(itemStack, this.idleCost / 20.0, (EntityLivingBase)((EntityPlayer)entity))) {
            nbtData.func_74757_a("active", false);
            HashMap enchantmentMap = new HashMap();
            EnchantmentHelper.func_82782_a(enchantmentMap, (ItemStack)itemStack);
            ItemWeaponQuantumSaber.updateAttributes(nbtData);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack itemStack, int pass) {
        return false;
    }
}

