/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.filoghost.healthbar;

import com.gmail.filoghost.healthbar.Main;
import com.gmail.filoghost.healthbar.Updater;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class Commands
implements CommandExecutor {
    public Main instance;
    private static final String PREFIX = "\u00a72[\u00a7aHealthBar\u00a72] ";

    public Commands(Main main) {
        this.instance = main;
    }

    public boolean onCommand(final CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length == 0) {
            this.sendInfo(sender);
            return true;
        }
        if (args[0].equalsIgnoreCase("help")) {
            this.sendCommandList(sender);
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            this.reloadConfigs(sender);
            return true;
        }
        if (args[0].equalsIgnoreCase("update")) {
            if (!sender.hasPermission("healthbar.update")) {
                this.noPermissionMessage(sender);
                return true;
            }
            Thread updaterThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    Updater.UpdaterHandler.manuallyCheckUpdates(sender);
                }
            });
            updaterThread.start();
            return true;
        }
        sender.sendMessage("\u00a72[\u00a7aHealthBar\u00a72] \u00a7eUnknown command. Type \u00a7a" + label + " \u00a7efor help.");
        return true;
    }

    private void reloadConfigs(CommandSender sender) {
        if (!sender.hasPermission("healthbar.reload")) {
            this.noPermissionMessage(sender);
            return;
        }
        try {
            this.instance.reloadConfigFromDisk();
            sender.sendMessage("\u00a7e>>\u00a76 HealthBar reloaded");
        }
        catch (Exception e) {
            e.printStackTrace();
            sender.sendMessage("\u00a7cFailed to reload configs, take a look at the console!");
        }
    }

    private void sendInfo(CommandSender sender) {
        sender.sendMessage(PREFIX);
        sender.sendMessage("\u00a7aVersion: \u00a77" + this.instance.getDescription().getVersion());
        sender.sendMessage("\u00a7aDeveloper: \u00a77filoghost");
        sender.sendMessage("\u00a7aCommands: \u00a77/hbr help");
    }

    private void sendCommandList(CommandSender sender) {
        if (!sender.hasPermission("healthbar.help")) {
            this.noPermissionMessage(sender);
            return;
        }
        sender.sendMessage("\u00a7e>>\u00a76 HealthBar commands: ");
        sender.sendMessage("\u00a72/hbr \u00a77- \u00a7aDisplays general plugin info");
        sender.sendMessage("\u00a72/hbr reload \u00a77- \u00a7aReloads the configs");
        sender.sendMessage("\u00a72/hbr update \u00a77- \u00a7aChecks for updates");
    }

    private void noPermissionMessage(CommandSender sender) {
        sender.sendMessage("\u00a7cYou don't have permission.");
    }
}

