/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.filoghost.healthbar;

import com.gmail.filoghost.healthbar.BarType;
import com.gmail.filoghost.healthbar.Configuration;
import com.gmail.filoghost.healthbar.Main;
import com.gmail.filoghost.healthbar.PlayerBar;
import com.gmail.filoghost.healthbar.StringBoolean;
import com.gmail.filoghost.healthbar.utils.MobBarsUtils;
import com.gmail.filoghost.healthbar.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.ThaH3lper.com.API.EpicBossAPI;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class DamageListener
implements Listener {
    private static final Plugin plugin = Main.plugin;
    private static BukkitScheduler scheduler = Bukkit.getScheduler();
    public static boolean mobEnabled;
    private static String[] barArray;
    private static boolean mobUseText;
    private static boolean mobUseCustomText;
    private static String mobCustomText;
    private static boolean customTextContains_Name;
    private static boolean mobSemiHidden;
    protected static long mobHideDelay;
    private static boolean mobUseCustomBar;
    private static boolean showOnCustomNames;
    private static BarType barStyle;
    private static boolean playerEnabled;
    private static long playerHideDelay;
    private static boolean playerUseAfter;
    private static boolean hookEpicboss;
    private static Map<String, String> localeMap;
    private static Map<String, Integer> playerTable;
    private static Map<Integer, Integer> mobTable;
    private static Map<Integer, StringBoolean> namesTable;
    private static boolean mobUseDisabledWorlds;
    private static List<String> mobDisabledWorlds;
    private static boolean mobTypeDisabling;
    private static List<EntityType> mobDisabledTypes;

    static {
        localeMap = new HashMap<String, String>();
        playerTable = new HashMap<String, Integer>();
        mobTable = new HashMap<Integer, Integer>();
        namesTable = new HashMap<Integer, StringBoolean>();
        mobDisabledWorlds = new ArrayList<String>();
        mobDisabledTypes = new ArrayList<EntityType>();
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onEntityDeath(EntityDeathEvent event) {
        if (event.getEntity() instanceof LivingEntity) {
            DamageListener.hideBar(event.getEntity());
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onEntityDamageEvent(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        if ((float)living.getNoDamageTicks() > (float)living.getMaximumNoDamageTicks() / 2.0f) {
            return;
        }
        if (entity instanceof Player && playerEnabled) {
            DamageListener.parsePlayerHit((Player)entity, event instanceof EntityDamageByEntityEvent);
            return;
        }
        if (mobEnabled) {
            DamageListener.parseMobHit(living, event instanceof EntityDamageByEntityEvent);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onEntityRegain(EntityRegainHealthEvent event) {
        Entity entity = event.getEntity();
        if (playerEnabled && entity instanceof Player) {
            DamageListener.parsePlayerHit((Player)entity, event.getRegainReason() != EntityRegainHealthEvent.RegainReason.SATIATED && event.getAmount() > 0.0);
            return;
        }
        if (mobEnabled && entity instanceof LivingEntity) {
            DamageListener.parseMobHit((LivingEntity)entity, true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onEntitySpawn(CreatureSpawnEvent event) {
        if (mobHideDelay == 0L && mobEnabled) {
            final LivingEntity mob = event.getEntity();
            scheduler.scheduleSyncDelayedTask(plugin, new Runnable(){

                @Override
                public void run() {
                    DamageListener.parseMobHit(mob, true);
                }
            }, 1L);
        }
    }

    private static void parsePlayerHit(final Player player, boolean damagedByEntity) {
        String pname = player.getName();
        scheduler.scheduleSyncDelayedTask(plugin, new Runnable(){

            @Override
            public void run() {
                PlayerBar.updateHealthBelow(player);
            }
        });
        if (!playerUseAfter) {
            return;
        }
        if (playerHideDelay == 0L) {
            DamageListener.showPlayerHealthBar(player);
            return;
        }
        if (damagedByEntity) {
            Integer eventualTaskID = playerTable.remove(pname);
            if (eventualTaskID != null) {
                scheduler.cancelTask(eventualTaskID.intValue());
            }
            DamageListener.showPlayerHealthBar(player);
            DamageListener.hidePlayerBarLater(player);
            return;
        }
        if (playerTable.containsKey(pname)) {
            DamageListener.showPlayerHealthBar(player);
        }
    }

    protected static void parseMobHit(LivingEntity mob, boolean damagedByEntity) {
        EntityType type = mob.getType();
        if (mobTypeDisabling && mobDisabledTypes.contains(type)) {
            return;
        }
        if (type == EntityType.WITHER || type == EntityType.ENDER_DRAGON) {
            return;
        }
        if (type == EntityType.HORSE && !mob.isEmpty()) {
            return;
        }
        if (mobUseDisabledWorlds && mobDisabledWorlds.contains(mob.getWorld().getName().toLowerCase())) {
            return;
        }
        String customName = mob.getCustomName();
        if (customName != null && !customName.startsWith("\u00a7r")) {
            if (showOnCustomNames) {
                namesTable.put(mob.getEntityId(), new StringBoolean(customName, mob.isCustomNameVisible()));
            } else {
                return;
            }
        }
        if (mobHideDelay == 0L) {
            DamageListener.showMobHealthBar(mob);
            return;
        }
        if (damagedByEntity) {
            Integer eventualTaskID = mobTable.remove(mob.getEntityId());
            if (eventualTaskID != null) {
                scheduler.cancelTask(eventualTaskID.intValue());
            }
            DamageListener.showMobHealthBar(mob);
            DamageListener.hideMobBarLater(mob);
            return;
        }
        if (mobTable.containsKey(mob.getEntityId())) {
            DamageListener.showMobHealthBar(mob);
        }
    }

    private static void showMobHealthBar(final LivingEntity mob) {
        scheduler.scheduleSyncDelayedTask(plugin, new Runnable(){

            @Override
            public void run() {
                double health = mob.getHealth();
                double max = mob.getMaxHealth();
                if (health <= 0.0) {
                    return;
                }
                if (barStyle == BarType.BAR) {
                    mob.setCustomName("\u00a7r" + barArray[Utils.roundUpPositiveWithMax(health / max * 20.0, 20)]);
                } else if (barStyle == BarType.CUSTOM_TEXT) {
                    String displayString = mobCustomText.replace("{h}", String.valueOf(Utils.roundUpPositive(health)));
                    displayString = displayString.replace("{m}", String.valueOf(Utils.roundUpPositive(max)));
                    if (customTextContains_Name) {
                        displayString = displayString.replace("{n}", DamageListener.getName(mob, mob.getType().toString()));
                    }
                    mob.setCustomName("\u00a7r" + displayString);
                } else if (barStyle == BarType.DEFAULT_TEXT) {
                    StringBuilder sb = new StringBuilder("\u00a7rHealth: ");
                    sb.append(Utils.roundUpPositive(health));
                    sb.append("/");
                    sb.append(Utils.roundUpPositive(max));
                    mob.setCustomName(sb.toString());
                }
                if (!mobSemiHidden) {
                    mob.setCustomNameVisible(true);
                }
            }
        });
    }

    private static void hideMobBarLater(final LivingEntity mob) {
        int id = mob.getEntityId();
        mobTable.put(id, scheduler.scheduleSyncDelayedTask(plugin, new Runnable(){

            @Override
            public void run() {
                DamageListener.hideBar(mob);
            }
        }, mobHideDelay));
    }

    public static void hidePlayerBarLater(final Player player) {
        playerTable.put(player.getName(), scheduler.scheduleSyncDelayedTask(plugin, new Runnable(){

            @Override
            public void run() {
                playerTable.remove(player.getName());
                PlayerBar.hideHealthBar(player);
            }
        }, playerHideDelay));
    }

    public static void hideBar(LivingEntity mob) {
        int idForName;
        StringBoolean sb;
        String cname = mob.getCustomName();
        if (cname != null && !cname.startsWith("\u00a7r")) {
            return;
        }
        Integer id = mobTable.remove(mob.getEntityId());
        if (id != null) {
            scheduler.cancelTask(id.intValue());
        }
        if (showOnCustomNames && (sb = namesTable.remove(idForName = mob.getEntityId())) != null) {
            mob.setCustomName(sb.getString());
            mob.setCustomNameVisible(sb.getBoolean().booleanValue());
            return;
        }
        mob.setCustomName("");
        mob.setCustomNameVisible(false);
    }

    public static String getNameWhileHavingBar(LivingEntity mob) {
        String cname = mob.getCustomName();
        if (cname == null) {
            return null;
        }
        if (cname.startsWith("\u00a7r")) {
            int id;
            StringBoolean sb;
            if (showOnCustomNames && (sb = namesTable.get(id = mob.getEntityId())) != null) {
                return sb.getString();
            }
            return null;
        }
        return cname;
    }

    private static void showPlayerHealthBar(final Player p) {
        scheduler.scheduleSyncDelayedTask(plugin, new Runnable(){

            @Override
            public void run() {
                double health = p.getHealth();
                double max = p.getMaxHealth();
                if (health == 0.0) {
                    PlayerBar.hideHealthBar(p);
                    return;
                }
                PlayerBar.setHealthSuffix(p, health, max);
            }
        });
    }

    public static void removeAllMobHealthBars() {
        scheduler.cancelTasks(plugin);
        mobTable.clear();
        List worldsList = plugin.getServer().getWorlds();
        for (World w : worldsList) {
            List entityList = w.getLivingEntities();
            for (LivingEntity e : entityList) {
                if (e.getType() == EntityType.PLAYER) continue;
                DamageListener.hideBar(e);
            }
        }
    }

    private static String getName(LivingEntity mob, String mobType) {
        String customName;
        if (hookEpicboss) {
            try {
                if (EpicBossAPI.isBoss((LivingEntity)mob)) {
                    return Utils.colorize(EpicBossAPI.getBossDisplayName((LivingEntity)mob));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Main.logger.warning("Could not get boss name from EpicBoss. Hook disabled. Is it updated?");
                hookEpicboss = false;
            }
        }
        if ((customName = mob.getCustomName()) != null && !customName.startsWith("\u00a7r")) {
            return customName;
        }
        StringBoolean sb = namesTable.get(mob.getEntityId());
        if (sb != null) {
            return sb.getString();
        }
        String name = localeMap.get(mobType);
        if (name != null) {
            return name;
        }
        return "";
    }

    public static void loadConfiguration() {
        DamageListener.removeAllMobHealthBars();
        FileConfiguration config = plugin.getConfig();
        mobEnabled = config.getBoolean(Configuration.Nodes.MOB_ENABLE.getNode());
        mobUseText = config.getBoolean(Configuration.Nodes.MOB_TEXT_MODE.getNode());
        mobUseCustomText = config.getBoolean(Configuration.Nodes.MOB_CUSTOM_TEXT_ENABLE.getNode());
        mobCustomText = Utils.replaceSymbols(config.getString(Configuration.Nodes.MOB_CUSTOM_TEXT.getNode()));
        mobSemiHidden = config.getBoolean(Configuration.Nodes.MOB_SHOW_IF_LOOKING.getNode());
        mobHideDelay = (long)config.getInt(Configuration.Nodes.MOB_DELAY.getNode()) * 20L;
        if (config.getBoolean(Configuration.Nodes.MOB_ALWAYS_SHOWN.getNode(), false)) {
            mobHideDelay = 0L;
        }
        mobUseCustomBar = config.getBoolean(Configuration.Nodes.MOB_USE_CUSTOM.getNode());
        showOnCustomNames = config.getBoolean(Configuration.Nodes.MOB_SHOW_ON_NAMED.getNode());
        mobUseDisabledWorlds = config.getBoolean(Configuration.Nodes.MOB_WORLD_DISABLING.getNode());
        if (mobUseDisabledWorlds) {
            mobDisabledWorlds = Arrays.asList(plugin.getConfig().getString(Configuration.Nodes.MOB_DISABLED_WORLDS.getNode()).toLowerCase().replace(" ", "").split(","));
        }
        mobTypeDisabling = config.getBoolean(Configuration.Nodes.MOB_TYPE_DISABLING.getNode());
        playerEnabled = config.getBoolean(Configuration.Nodes.PLAYERS_ENABLE.getNode());
        playerHideDelay = (long)config.getInt("player-bars.after-name.hide-delay-seconds") * 20L;
        if (config.getBoolean(Configuration.Nodes.PLAYERS_AFTER_ALWAYS_SHOWN.getNode(), false)) {
            playerHideDelay = 0L;
        }
        playerUseAfter = config.getBoolean(Configuration.Nodes.PLAYERS_AFTER_ENABLE.getNode());
        hookEpicboss = config.getBoolean(Configuration.Nodes.HOOKS_EPIBOSS.getNode());
        if (hookEpicboss) {
            if (!Bukkit.getPluginManager().isPluginEnabled("EpicBoss Gold Edition")) {
                hookEpicboss = false;
                Bukkit.getConsoleSender().sendMessage("\u00a7a[HealthBar] \u00a7fCould not find plugin EpicBoss Gold Edition, check that you have installed it and it's correctly loaded. If not, set 'hooks, epicboss: false' in the configs. If you think that is an error, contact the developer.");
            } else {
                Main.logger.info("Hooked plugin EpicBoss Gold Edition.");
            }
        }
        if (mobCustomText.contains("{name}")) {
            customTextContains_Name = true;
            mobCustomText = mobCustomText.replace("{name}", "{n}");
        } else {
            customTextContains_Name = false;
        }
        barArray = new String[21];
        if (mobUseCustomBar) {
            barStyle = BarType.BAR;
        } else if (mobUseText) {
            if (mobUseCustomText) {
                mobCustomText = mobCustomText.replace("{health}", "{h}");
                mobCustomText = mobCustomText.replace("{max}", "{m}");
                barStyle = BarType.CUSTOM_TEXT;
            } else {
                barStyle = BarType.DEFAULT_TEXT;
            }
        } else {
            barStyle = BarType.BAR;
        }
        if (barStyle == BarType.BAR) {
            barArray = mobUseCustomBar ? MobBarsUtils.getCustomBars(Utils.loadFile("custom-mob-bar.yml", plugin)) : MobBarsUtils.getDefaultsBars(config);
        }
        if (mobUseCustomText && customTextContains_Name) {
            localeMap = Utils.getTranslationMap(plugin);
        }
        if (mobTypeDisabling) {
            mobDisabledTypes = Utils.getTypesFromString(config.getString(Configuration.Nodes.MOB_DISABLED_TYPES.getNode()));
        }
        if (mobHideDelay == 0L) {
            for (World world : Bukkit.getWorlds()) {
                for (LivingEntity mob : world.getLivingEntities()) {
                    if (mob.getType() == EntityType.PLAYER) continue;
                    DamageListener.parseMobHit(mob, true);
                }
            }
        }
    }
}

