/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.filoghost.healthbar;

import com.gmail.filoghost.healthbar.Configuration;
import com.gmail.filoghost.healthbar.Main;
import com.gmail.filoghost.healthbar.api.HealthBarAPI;
import org.apache.commons.lang.WordUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.projectiles.ProjectileSource;

public class DeathListener
implements Listener {
    private static boolean wantDeathListener;

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerDeathEvent(PlayerDeathEvent event) {
        if (!wantDeathListener) {
            return;
        }
        try {
            String deathMessage = event.getDeathMessage();
            String victim = event.getEntity().getName();
            EntityDamageEvent damageEvent = event.getEntity().getLastDamageCause();
            if (damageEvent instanceof EntityDamageByEntityEvent) {
                ProjectileSource shooter;
                Entity damager = ((EntityDamageByEntityEvent)damageEvent).getDamager();
                if (deathMessage.contains("killed") || deathMessage.contains("slain") || deathMessage.contains("got finished")) {
                    if (damager instanceof Player) {
                        String itemname = ((Player)damager).getItemInHand().getItemMeta().getDisplayName();
                        if (itemname == null) {
                            event.setDeathMessage(String.valueOf(victim) + " was slain by " + ((Player)damager).getName());
                            return;
                        }
                        event.setDeathMessage(String.valueOf(victim) + " was slain by " + ((Player)damager).getName() + " using " + itemname);
                        return;
                    }
                    if (damager instanceof LivingEntity) {
                        event.setDeathMessage(String.valueOf(victim) + " was slain by " + this.getName((LivingEntity)damager));
                        return;
                    }
                }
                if (deathMessage.contains("blown up")) {
                    if (damager instanceof Player) {
                        event.setDeathMessage(String.valueOf(victim) + " was blown up by " + ((Player)damager).getName());
                        return;
                    }
                    if (damager instanceof LivingEntity) {
                        event.setDeathMessage(String.valueOf(victim) + " was blown up by " + this.getName((LivingEntity)damager));
                        return;
                    }
                }
                if ((deathMessage.contains("shot") || deathMessage.contains("shooted")) && damager instanceof Projectile) {
                    shooter = ((Projectile)damager).getShooter();
                    if (shooter instanceof Player) {
                        String itemname = ((Player)shooter).getItemInHand().getItemMeta().getDisplayName();
                        if (itemname == null) {
                            event.setDeathMessage(String.valueOf(victim) + " was shot by " + ((Player)shooter).getName());
                            return;
                        }
                        event.setDeathMessage(String.valueOf(victim) + " was shot by " + ((Player)shooter).getName() + " using " + itemname);
                        return;
                    }
                    if (shooter instanceof LivingEntity) {
                        event.setDeathMessage(String.valueOf(victim) + " was shot by " + this.getName((LivingEntity)shooter));
                        return;
                    }
                }
                if (deathMessage.contains("fireballed") && damager instanceof Projectile) {
                    shooter = ((Projectile)damager).getShooter();
                    if (shooter instanceof Player) {
                        event.setDeathMessage(String.valueOf(victim) + " was fireballed by " + ((Player)shooter).getName());
                        return;
                    }
                    if (shooter instanceof LivingEntity) {
                        event.setDeathMessage(String.valueOf(victim) + "was fireballed by " + this.getName((LivingEntity)shooter));
                        return;
                    }
                }
            }
            if (deathMessage.contains("high place") || deathMessage.contains("doomed to fall") || deathMessage.contains("fell off") || deathMessage.contains("fell out of the water")) {
                event.setDeathMessage(String.valueOf(victim) + " fell from a high place");
                return;
            }
            if (deathMessage.contains("lava")) {
                event.setDeathMessage(String.valueOf(victim) + " tried to swim in lava");
                return;
            }
            if (deathMessage.contains("blew up")) {
                event.setDeathMessage(String.valueOf(victim) + " blew up");
                return;
            }
            if (deathMessage.contains("burned") || deathMessage.contains("crisp")) {
                event.setDeathMessage(String.valueOf(victim) + " was burned to death");
                return;
            }
            if (deathMessage.contains("flames") || deathMessage.contains("fire")) {
                event.setDeathMessage(String.valueOf(victim) + " went up in flames");
                return;
            }
            if (deathMessage.contains("drowned")) {
                event.setDeathMessage(String.valueOf(victim) + " drowned");
                return;
            }
            if (deathMessage.contains("shooted") || deathMessage.contains("shot")) {
                event.setDeathMessage(String.valueOf(victim) + " was shot by an arrow");
                return;
            }
            if (deathMessage.contains("wall")) {
                event.setDeathMessage(String.valueOf(victim) + " suffucated in a wall");
                return;
            }
            if (deathMessage.contains("starved")) {
                event.setDeathMessage(String.valueOf(victim) + " starved to death");
                return;
            }
            if (deathMessage.contains("magic")) {
                event.setDeathMessage(String.valueOf(victim) + " was killed by magic");
                return;
            }
            if (deathMessage.contains("fireball")) {
                event.setDeathMessage(String.valueOf(victim) + " was fireballed");
                return;
            }
            if (deathMessage.contains("pricked") || deathMessage.contains("cactus") || deathMessage.contains("cacti")) {
                event.setDeathMessage(String.valueOf(victim) + " was pricked to death");
                return;
            }
            if (deathMessage.contains("world")) {
                event.setDeathMessage(String.valueOf(victim) + " fell out of the world");
                return;
            }
            if (deathMessage.contains("squashed")) {
                event.setDeathMessage(String.valueOf(victim) + " was squashed by a falling anvil");
                return;
            }
            event.setDeathMessage(String.valueOf(victim) + " died");
            return;
        }
        catch (Exception e) {
            event.setDeathMessage(String.valueOf(event.getEntity().getName()) + " died");
            return;
        }
    }

    private String getName(LivingEntity mob) {
        String customName = HealthBarAPI.getMobName(mob);
        if (customName != null) {
            return customName;
        }
        if (mob.getType() == EntityType.PIG_ZOMBIE) {
            return "Zombie Pigman";
        }
        if (mob.getType() == EntityType.MUSHROOM_COW) {
            return "Mooshroom";
        }
        return WordUtils.capitalizeFully((String)mob.getType().toString().replace("_", " "));
    }

    public static void loadConfiguration() {
        wantDeathListener = Main.plugin.getConfig().getBoolean(Configuration.Nodes.FIX_DEATH_MESSAGES.getNode());
    }
}

