/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.filoghost.healthbar;

import com.gmail.filoghost.healthbar.Commands;
import com.gmail.filoghost.healthbar.Configuration;
import com.gmail.filoghost.healthbar.DamageListener;
import com.gmail.filoghost.healthbar.DeathListener;
import com.gmail.filoghost.healthbar.MiscListeners;
import com.gmail.filoghost.healthbar.PlayerBar;
import com.gmail.filoghost.healthbar.Updater;
import com.gmail.filoghost.healthbar.metrics.MetricsLite;
import com.gmail.filoghost.healthbar.utils.Debug;
import com.gmail.filoghost.healthbar.utils.PlayerBarUtils;
import com.gmail.filoghost.healthbar.utils.Utils;
import java.io.File;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    public static Main plugin;
    public static Logger logger;
    private static DamageListener damageListener;
    private static DeathListener deathListener;
    private static MiscListeners miscListeners;

    public void onEnable() {
        plugin = this;
        logger = this.getLogger();
        try {
            String build = Utils.getBukkitBuild();
            if (build != null && Integer.parseInt(build) < 2811) {
                logger.warning("------------------------------------------");
                logger.warning("Your bukkit build (#" + build + ") is old.");
                logger.warning("HealthBar cannot work properly,");
                logger.warning("please update CraftBukkit.");
                logger.warning("------------------------------------------");
                this.setEnabled(false);
                return;
            }
        }
        catch (Exception build) {
            // empty catch block
        }
        damageListener = new DamageListener();
        deathListener = new DeathListener();
        miscListeners = new MiscListeners();
        Debug.color("\u00a7c[HealthBar] Debug ON");
        if (this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        Utils.loadFile("config.yml", (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)damageListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)deathListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)miscListeners, (Plugin)this);
        this.reloadConfigFromDisk();
        FileConfiguration config = this.getConfig();
        Updater.UpdaterHandler.setup((Plugin)this, 54447, "\u00a72[\u00a7aHealthBar\u00a72] ", super.getFile(), ChatColor.GREEN, "/hbr update", "health-bar");
        if (config.getBoolean("update-notification")) {
            Thread updaterThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    Updater.UpdaterHandler.startupUpdateCheck();
                }
            });
            updaterThread.start();
        }
        this.getCommand("healthbar").setExecutor((CommandExecutor)new Commands(this));
        try {
            MetricsLite metrics = new MetricsLite((Plugin)this);
            metrics.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onDisable() {
        PlayerBarUtils.removeAllHealthbarTeams(Bukkit.getScoreboardManager().getMainScoreboard());
        PlayerBar.removeBelowObj();
        DamageListener.removeAllMobHealthBars();
        System.out.println("HealthBar disabled, all the health bars have been removed.");
    }

    public void reloadConfigFromDisk() {
        this.reloadConfig();
        Configuration.checkConfigYML();
        Utils.loadFile("custom-mob-bar.yml", (Plugin)this);
        Utils.loadFile("custom-player-bar.yml", (Plugin)this);
        Utils.loadFile("locale.yml", (Plugin)this);
        Utils.loadFile("config.yml", (Plugin)this);
        Utils.getTranslationMap((Plugin)this);
        DamageListener.loadConfiguration();
        DeathListener.loadConfiguration();
        PlayerBar.loadConfiguration();
        MiscListeners.loadConfiguration();
    }

    public static MiscListeners getLoginListenerInstance() {
        return miscListeners;
    }

    public static File getPluginFile() {
        return plugin.getFile();
    }
}

