/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.filoghost.healthbar;

import com.gmail.filoghost.healthbar.Configuration;
import com.gmail.filoghost.healthbar.DamageListener;
import com.gmail.filoghost.healthbar.Main;
import com.gmail.filoghost.healthbar.PlayerBar;
import com.gmail.filoghost.healthbar.Updater;
import com.gmail.filoghost.healthbar.api.HealthBarAPI;
import com.gmail.filoghost.healthbar.utils.VersionUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scoreboard.Scoreboard;

public class MiscListeners
implements Listener {
    private static final Plugin instance = Main.plugin;
    private static boolean fixTabNames;
    private static boolean usePlayerPermissions;
    private static Scoreboard fakeSb;
    private static Scoreboard mainSb;
    private static boolean playerEnabled;
    private static int playerHideDelay;
    private static boolean playerUseAfter;
    private static boolean pluginDisabledWhiteTabNames;
    private static BukkitScheduler scheduler;
    private static boolean overrideOtherScoreboards;
    private static boolean playerUseDisabledWorlds;
    private static List<String> playerDisabledWorlds;

    static {
        fakeSb = instance.getServer().getScoreboardManager().getNewScoreboard();
        mainSb = instance.getServer().getScoreboardManager().getMainScoreboard();
        pluginDisabledWhiteTabNames = false;
        scheduler = Bukkit.getScheduler();
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onInteract(PlayerInteractEntityEvent event) {
        Horse horse;
        Entity entity = event.getRightClicked();
        if (event.getPlayer().getItemInHand().getType() == Material.NAME_TAG && entity instanceof LivingEntity) {
            final LivingEntity mob = (LivingEntity)entity;
            if (DamageListener.mobHideDelay == 0L && HealthBarAPI.mobHasBar(mob)) {
                scheduler.scheduleSyncDelayedTask(instance, new Runnable(){

                    @Override
                    public void run() {
                        DamageListener.parseMobHit(mob, true);
                    }
                }, 20L);
            }
            DamageListener.hideBar(mob);
            mob.setCustomNameVisible(false);
            return;
        }
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            if (villager.isAdult() && HealthBarAPI.mobHasBar((LivingEntity)villager)) {
                DamageListener.hideBar((LivingEntity)villager);
                if (DamageListener.mobHideDelay == 0L) {
                    DamageListener.parseMobHit((LivingEntity)villager, true);
                }
            }
        } else if (entity instanceof Horse && ((horse = (Horse)entity).getVariant() == Horse.Variant.DONKEY || horse.getVariant() == Horse.Variant.MULE) && HealthBarAPI.mobHasBar((LivingEntity)horse)) {
            DamageListener.hideBar((LivingEntity)horse);
            if (DamageListener.mobHideDelay == 0L) {
                scheduler.scheduleSyncDelayedTask((Plugin)Main.plugin, new Runnable(){

                    @Override
                    public void run() {
                        DamageListener.parseMobHit((LivingEntity)horse, true);
                    }
                }, 1L);
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onVehicleEnter(VehicleEnterEvent event) {
        Horse horse;
        Vehicle vehicle = event.getVehicle();
        if (vehicle instanceof Horse && HealthBarAPI.mobHasBar((LivingEntity)(horse = (Horse)vehicle))) {
            DamageListener.hideBar((LivingEntity)horse);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onVehicleLeave(VehicleExitEvent event) {
        Vehicle vehicle = event.getVehicle();
        if (vehicle instanceof Horse) {
            final Horse horse = (Horse)vehicle;
            if (DamageListener.mobHideDelay == 0L) {
                scheduler.scheduleSyncDelayedTask(instance, new Runnable(){

                    @Override
                    public void run() {
                        DamageListener.parseMobHit((LivingEntity)horse, true);
                    }
                }, 1L);
            }
        }
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        if (DamageListener.mobHideDelay == 0L && DamageListener.mobEnabled) {
            Entity[] entityArray = event.getChunk().getEntities();
            int n = entityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Entity entity = entityArray[n2];
                if (entity instanceof LivingEntity && entity.getType() != EntityType.PLAYER) {
                    DamageListener.parseMobHit((LivingEntity)entity, true);
                }
                ++n2;
            }
        }
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent event) {
        if (!DamageListener.mobEnabled) {
            return;
        }
        Entity[] entityArray = event.getChunk().getEntities();
        int n = entityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Entity entity = entityArray[n2];
            if (entity instanceof LivingEntity && entity.getType() != EntityType.PLAYER) {
                DamageListener.hideBar((LivingEntity)entity);
            }
            ++n2;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void joinLowest(PlayerJoinEvent event) {
        if (!playerEnabled) {
            return;
        }
        try {
            MiscListeners.fixTabName(event.getPlayer());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void joinHighest(PlayerJoinEvent event) {
        if (!playerEnabled) {
            return;
        }
        final Player p = event.getPlayer();
        MiscListeners.updateScoreboard(p, p.getWorld().getName().toLowerCase());
        scheduler.scheduleSyncDelayedTask(instance, new Runnable(){

            @Override
            public void run() {
                MiscListeners.updatePlayer(p);
            }
        }, 1L);
        Updater.UpdaterHandler.notifyIfUpdateWasFound(p, "healthbar.update");
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void playerTeleport(final PlayerTeleportEvent event) {
        if (!playerEnabled) {
            return;
        }
        final Player player = event.getPlayer();
        if (event.getFrom().getWorld().equals(event.getTo().getWorld())) {
            scheduler.scheduleSyncDelayedTask(instance, new Runnable(){

                @Override
                public void run() {
                    if (overrideOtherScoreboards) {
                        MiscListeners.updateScoreboard(player, player.getWorld().getName().toLowerCase());
                    }
                    MiscListeners.updatePlayer(player);
                }
            }, 1L);
        } else {
            scheduler.scheduleSyncDelayedTask(instance, new Runnable(){

                @Override
                public void run() {
                    MiscListeners.updatePlayer(player);
                }
            }, 1L);
            if (overrideOtherScoreboards) {
                scheduler.scheduleSyncDelayedTask(instance, new Runnable(){

                    @Override
                    public void run() {
                        MiscListeners.updateScoreboard(player, event.getTo().getWorld().getName().toLowerCase());
                    }
                }, 1L);
            } else {
                MiscListeners.updateScoreboard(player, event.getTo().getWorld().getName().toLowerCase());
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void playerRespawn(PlayerRespawnEvent event) {
        if (!playerEnabled) {
            return;
        }
        final Player player = event.getPlayer();
        MiscListeners.updateScoreboard(player, player.getWorld().getName().toLowerCase());
        scheduler.scheduleSyncDelayedTask(instance, new Runnable(){

            @Override
            public void run() {
                MiscListeners.updatePlayer(player);
            }
        }, 1L);
    }

    private static void updateScoreboard(Player p, String worldName) {
        if (!p.isOnline()) {
            return;
        }
        if (usePlayerPermissions && !p.hasPermission("healthbar.see.onplayer")) {
            try {
                p.setScoreboard(fakeSb);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        if (playerUseDisabledWorlds && playerDisabledWorlds.contains(worldName)) {
            try {
                p.setScoreboard(fakeSb);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        try {
            p.setScoreboard(mainSb);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void updatePlayer(Player p) {
        PlayerBar.updateHealthBelow(p);
        if (playerUseAfter && playerHideDelay == 0) {
            PlayerBar.setHealthSuffix(p, p.getHealth(), p.getMaxHealth());
        }
    }

    private static void fixTabName(Player p) {
        if (fixTabNames && !pluginDisabledWhiteTabNames) {
            if (p.getPlayerListName().startsWith("\u00a7")) {
                return;
            }
            if (p.getName().length() > 14) {
                p.setPlayerListName(p.getName().substring(0, 14));
                p.setPlayerListName(p.getName());
            } else {
                p.setPlayerListName("\u00a7f" + p.getName());
            }
        }
    }

    public static void loadConfiguration() {
        Collection<? extends Player> playerlist;
        FileConfiguration config = instance.getConfig();
        usePlayerPermissions = config.getBoolean(Configuration.Nodes.USE_PLAYER_PERMISSIONS.getNode());
        fixTabNames = config.getBoolean(Configuration.Nodes.FIX_TAB_NAMES.getNode());
        playerHideDelay = config.getInt(Configuration.Nodes.PLAYERS_AFTER_DELAY.getNode());
        playerEnabled = config.getBoolean(Configuration.Nodes.PLAYERS_ENABLE.getNode());
        playerUseAfter = config.getBoolean(Configuration.Nodes.PLAYERS_AFTER_ENABLE.getNode());
        playerUseDisabledWorlds = config.getBoolean(Configuration.Nodes.PLAYERS_WORLD_DISABLING.getNode());
        overrideOtherScoreboards = config.getBoolean(Configuration.Nodes.OVERRIDE_OTHER_SCOREBOARD.getNode());
        if (playerUseDisabledWorlds) {
            playerDisabledWorlds = Arrays.asList(instance.getConfig().getString(Configuration.Nodes.PLAYERS_DISABLED_WORLDS.getNode()).toLowerCase().replace(" ", "").split(","));
        }
        if (!(playerlist = VersionUtils.getOnlinePlayers()).isEmpty()) {
            for (Player player : playerlist) {
                MiscListeners.updatePlayer(player);
                MiscListeners.updateScoreboard(player, player.getWorld().getName().toLowerCase());
                MiscListeners.fixTabName(player);
            }
        }
    }

    public static void disableTabNamesFix() {
        pluginDisabledWhiteTabNames = true;
    }
}

